/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import codechicken.lib.render.block.CCBlockRendererDispatcher;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.util.EnumHelper;

public class BlockRenderingRegistry {
    private static final Map<EnumBlockRenderType, ICCBlockRenderer> blockRendererList = new HashMap<EnumBlockRenderType, ICCBlockRenderer>();
    private static final ImmutableList<EnumBlockRenderType> vanillaRenderTypes = ImmutableList.copyOf((Object[])EnumBlockRenderType.values());
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.func_71410_x();
            BlockRendererDispatcher parentDispatcher = mc.func_175602_ab();
            CCBlockRendererDispatcher newDispatcher = new CCBlockRendererDispatcher(parentDispatcher, mc.func_184125_al());
            ObfMapping mapping = new ObfMapping("net/minecraft/client/Minecraft", "field_175618_aM");
            ReflectionManager.setField(mapping, mc, newDispatcher);
            TextureUtils.addIconRegister(newDispatcher);
            initialized = true;
        }
    }

    public static EnumBlockRenderType createRenderType(String name) {
        return (EnumBlockRenderType)EnumHelper.addEnum(EnumBlockRenderType.class, (String)name, (Class[])new Class[0], (Object[])new Object[0]);
    }

    public static boolean canHandle(EnumBlockRenderType type) {
        return blockRendererList.containsKey(type);
    }

    public static void registerRenderer(EnumBlockRenderType type, ICCBlockRenderer renderer) {
        if (vanillaRenderTypes.contains((Object)type)) {
            throw new IllegalArgumentException("Invalid EnumBlockRenderType! " + type.name());
        }
        if (blockRendererList.containsKey(type)) {
            throw new IllegalArgumentException("Unable to register duplicate render type!" + type.name());
        }
        blockRendererList.put(type, renderer);
        if (renderer instanceof TextureUtils.IIconRegister) {
            TextureUtils.addIconRegister((TextureUtils.IIconRegister)((Object)renderer));
        }
    }

    static void renderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite) {
        ICCBlockRenderer renderer = blockRendererList.get(state.func_185901_i());
        if (renderer != null) {
            state = state.func_185899_b(world, pos);
            BufferBuilder parent = Tessellator.func_178181_a().func_178180_c();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_178969_c(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
            buffer.func_181668_a(7, parent.func_178973_g());
            renderer.handleRenderBlockDamage(world, pos, state, sprite, buffer);
            buffer.func_178977_d();
            buffer.func_178969_c(0.0, 0.0, 0.0);
            BlockModelRenderer modelRenderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
            modelRenderer.func_178267_a(world, (IBakedModel)new PerspectiveAwareBakedModel(buffer.bake(), (IModelState)TransformUtils.DEFAULT_BLOCK, new ModelProperties(true, true, null)), state, pos, parent, true);
        }
    }

    static boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        ICCBlockRenderer renderer = blockRendererList.get(state.func_185901_i());
        return renderer != null && renderer.renderBlock(world, pos, state, buffer);
    }

    static void renderBlockBrightness(IBlockState state, float brightness) {
        ICCBlockRenderer renderer = blockRendererList.get(state.func_185901_i());
        if (renderer != null) {
            renderer.renderBrightness(state, brightness);
        }
    }

    @Deprecated
    static void registerTextures(TextureMap map) {
        for (ICCBlockRenderer renderer : blockRendererList.values()) {
            renderer.registerTextures(map);
        }
    }
}

