/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.table;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.common.TableRecipeFactory;
import slimeknights.tconstruct.tools.common.item.ItemBlockTable;

public class TableRecipeWrapper
implements IRecipeWrapper,
IShapedCraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final TableRecipeFactory.TableRecipe recipe;
    private final int width;
    private final int height;
    private final List<List<ItemStack>> outputs;

    public TableRecipeWrapper(TableRecipeFactory.TableRecipe recipe) {
        this.recipe = recipe;
        for (Object input : this.recipe.func_192400_c()) {
            ItemStack itemStack;
            if (!(input instanceof ItemStack) || (itemStack = (ItemStack)input).func_190916_E() == 1) continue;
            itemStack.func_190920_e(1);
        }
        this.width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((Object)this.recipe), (String[])new String[]{"width"});
        this.height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((Object)this.recipe), (String[])new String[]{"height"});
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : recipe.ingredients.func_193365_a()) {
            BlockTable block = (BlockTable)BlockTable.func_149634_a((Item)recipe.func_77571_b().func_77973_b());
            Block legBlock = Block.func_149634_a((Item)stack.func_77973_b());
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                for (ItemStack sub : JEIPlugin.jeiHelpers.getStackHelper().getSubtypes(stack)) {
                    builder.add((Object)BlockTable.createItemstack(block, recipe.func_77571_b().func_77952_i(), legBlock, sub.func_77952_i()));
                }
                continue;
            }
            builder.add((Object)BlockTable.createItemstack(block, recipe.func_77571_b().func_77952_i(), legBlock, stack.func_77952_i()));
        }
        this.outputs = ImmutableList.of((Object)builder.build());
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = JEIPlugin.jeiHelpers.getStackHelper();
        List inputs = stackHelper.expandRecipeItemStackInputs((List)this.recipe.func_192400_c());
        ingredients.setInputLists(ItemStack.class, inputs);
        if (!this.outputs.isEmpty()) {
            ingredients.setOutputLists(ItemStack.class, this.outputs);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean isOutputBlock(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack output : this.recipe.ingredients.func_193365_a()) {
            if (!OreDictionary.itemMatches((ItemStack)output, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = (List)ingredients.getOutputs(ItemStack.class).get(0);
        IFocus ifocus = recipeLayout.getFocus();
        Object focusObj = ifocus.getValue();
        if (focusObj instanceof ItemStack) {
            ItemStack legs;
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(ItemStack.class);
            ItemStack focus = (ItemStack)focusObj;
            IFocus.Mode mode = ifocus.getMode();
            if (mode == IFocus.Mode.INPUT && this.isOutputBlock(focus)) {
                ItemStack output = this.recipe.getPlainRecipeOutput();
                BlockTable block = (BlockTable)Block.func_149634_a((Item)output.func_77973_b());
                ItemStack outputFocus = BlockTable.createItemstack(block, output.func_77952_i(), Block.func_149634_a((Item)focus.func_77973_b()), focus.func_77952_i());
                guiIngredients.setOverrideDisplayFocus(JEIPlugin.recipeRegistry.createFocus(IFocus.Mode.OUTPUT, (Object)outputFocus));
            } else if (mode == IFocus.Mode.OUTPUT && !(legs = ItemBlockTable.getLegStack(focus)).func_190926_b()) {
                guiIngredients.setOverrideDisplayFocus(JEIPlugin.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)legs));
            }
        }
        JEIPlugin.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.getWidth(), this.getHeight());
        recipeLayout.getItemStacks().set(0, outputs);
    }
}

