/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.multiblock.saltFission.tile.TileSaltFissionPartBase;
import nc.recipe.NCRecipes;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.util.GasHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileSaltFissionDistributor
extends TileSaltFissionPartBase
implements ITileFluid {
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, NCRecipes.salt_fission_valid_fluids.get(0))});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(TankSorption.IN);
    @Nonnull
    private FluidTileWrapper[] fluidSides = ITileFluid.getDefaultFluidSides(this);
    @Nonnull
    private GasTileWrapper gasWrapper = new GasTileWrapper(this);

    public TileSaltFissionDistributor() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(SaltFissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public boolean getVoidExcessFluidOutput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidExcessFluidOutput(int tankNumber, boolean voidExcessFluidOutput) {
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return true;
            }
            if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
                return true;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
                return (T)this.getGasWrapper();
            }
        }
        return super.getCapability(capability, side);
    }
}

