/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.IRecipe;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeMatchResult;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidArrayIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.CollectionHelper;
import nc.util.FluidRegHelper;
import nc.util.GasHelper;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHelper {
    public static boolean containsItemIngredient(List<IItemIngredient> list, IItemIngredient ingredient) {
        for (IItemIngredient i : list) {
            if (i == null || !i.match(ingredient, IngredientSorption.NEUTRAL).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFluidIngredient(List<IFluidIngredient> list, IFluidIngredient ingredient) {
        for (IFluidIngredient i : list) {
            if (i == null || !i.match(ingredient, IngredientSorption.NEUTRAL).matches()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack fixItemStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ItemStack) {
            ItemStack stack = ((ItemStack)object).func_77946_l();
            if (stack.func_190916_E() <= 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object, 1);
        }
        if (!(object instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", object));
        }
        return new ItemStack((Block)object, 1);
    }

    public static FluidStack fixFluidStack(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FluidStack) {
            FluidStack fluidstack = ((FluidStack)object).copy();
            if (fluidstack.amount <= 0) {
                fluidstack.amount = 1000;
            }
            return fluidstack;
        }
        if (!(object instanceof Fluid)) {
            throw new RuntimeException(String.format("Invalid FluidStack: %s", object));
        }
        return new FluidStack((Fluid)object, 1000);
    }

    public static OreIngredient oreStackFromString(String name) {
        if (OreDictHelper.oreExists(name)) {
            return new OreIngredient(name, 1);
        }
        return null;
    }

    public static FluidIngredient fluidStackFromString(String name) {
        if (FluidRegHelper.fluidExists(name)) {
            return new FluidIngredient(name, 1000);
        }
        return null;
    }

    public static List<List<ItemStack>> getItemInputLists(List<IItemIngredient> ingredientList) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<FluidStack>> getFluidInputLists(List<IFluidIngredient> ingredientList) {
        ArrayList<List<FluidStack>> values = new ArrayList<List<FluidStack>>();
        ingredientList.forEach(ingredient -> values.add(ingredient.getInputStackList()));
        return values;
    }

    public static List<List<ItemStack>> getItemOutputLists(List<IItemIngredient> ingredientList) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        ingredientList.forEach(ingredient -> values.add(RecipeHelper.getItemOutputStackList(ingredient)));
        return values;
    }

    public static List<List<FluidStack>> getFluidOutputLists(List<IFluidIngredient> ingredientList) {
        ArrayList<List<FluidStack>> values = new ArrayList<List<FluidStack>>();
        ingredientList.forEach(ingredient -> values.add(RecipeHelper.getFluidOutputStackList(ingredient)));
        return values;
    }

    public static List<ItemStack> getItemOutputStackList(IItemIngredient ingredient) {
        if (ingredient instanceof ChanceItemIngredient) {
            return ingredient.getOutputStackList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)ingredient.getStack()});
    }

    public static List<FluidStack> getFluidOutputStackList(IFluidIngredient ingredient) {
        if (ingredient instanceof ChanceFluidIngredient) {
            return ingredient.getOutputStackList();
        }
        return Lists.newArrayList((Object[])new FluidStack[]{(FluidStack)ingredient.getStack()});
    }

    @Nullable
    public static List<ItemStack> getItemOutputList(List<IItemIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        list.forEach(ingredient -> stacks.add((ItemStack)ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<ItemStack>();
        }
        return stacks;
    }

    @Nullable
    public static List<FluidStack> getFluidOutputList(List<IFluidIngredient> list) {
        if (list.contains(null)) {
            return new ArrayList<FluidStack>();
        }
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        list.forEach(ingredient -> stacks.add((FluidStack)ingredient.getStack()));
        if (stacks.contains(null)) {
            return new ArrayList<FluidStack>();
        }
        return stacks;
    }

    @Nullable
    public static ItemStack getItemStackFromIngredientList(List<IItemIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IItemIngredient object = list.get(pos);
            return (ItemStack)object.getStack();
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidStackFromIngredientList(List<IFluidIngredient> list, int pos) {
        if (!list.isEmpty() && pos < list.size()) {
            IFluidIngredient object = list.get(pos);
            return (FluidStack)object.getStack();
        }
        return null;
    }

    @Nullable
    public static IItemIngredient buildItemIngredient(Object object) {
        if (AbstractRecipeHandler.requiresItemFixing(object)) {
            object = RecipeHelper.fixItemStack(object);
        }
        if (object instanceof IItemIngredient) {
            return RecipeHelper.checkedItemIngredient((IItemIngredient)object);
        }
        if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            ArrayList<IItemIngredient> buildList = new ArrayList<IItemIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IItemIngredient recipeObject;
                    if (listObject instanceof IItemIngredient) {
                        buildList.add((IItemIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = RecipeHelper.checkedItemIngredient(RecipeHelper.buildItemIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return RecipeHelper.checkedItemIngredient(new ItemArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return RecipeHelper.checkedItemIngredient(RecipeHelper.oreStackFromString((String)object));
        }
        if (object instanceof ItemStack) {
            return RecipeHelper.checkedItemIngredient(new ItemIngredient((ItemStack)object));
        }
        return null;
    }

    @Nullable
    public static IItemIngredient checkedItemIngredient(IItemIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    @Nullable
    public static IFluidIngredient buildFluidIngredient(Object object) {
        if (AbstractRecipeHandler.requiresFluidFixing(object)) {
            object = RecipeHelper.fixFluidStack(object);
        }
        if (RecipeHelper.needsExpanding() && object instanceof FluidIngredient) {
            return RecipeHelper.checkedFluidIngredient(RecipeHelper.buildFluidIngredient(RecipeHelper.expandedFluidStackList((FluidIngredient)object)));
        }
        if (object instanceof IFluidIngredient) {
            return RecipeHelper.checkedFluidIngredient((IFluidIngredient)object);
        }
        if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            ArrayList<IFluidIngredient> buildList = new ArrayList<IFluidIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IFluidIngredient recipeObject;
                    if (listObject instanceof IFluidIngredient) {
                        buildList.add((IFluidIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = RecipeHelper.checkedFluidIngredient(RecipeHelper.buildFluidIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return RecipeHelper.checkedFluidIngredient(new FluidArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return RecipeHelper.checkedFluidIngredient(RecipeHelper.fluidStackFromString((String)object));
        }
        if (object instanceof FluidStack) {
            return RecipeHelper.checkedFluidIngredient(new FluidIngredient((FluidStack)object));
        }
        return null;
    }

    @Nullable
    public static IFluidIngredient checkedFluidIngredient(IFluidIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    public static boolean needsExpanding() {
        return ModCheck.mekanismLoaded() || ModCheck.techRebornLoaded();
    }

    public static List<FluidIngredient> expandedFluidStackList(FluidIngredient stack) {
        ArrayList fluidStackList = Lists.newArrayList((Object[])new FluidIngredient[]{stack});
        if (ModCheck.mekanismLoaded() && !stack.fluidName.equals("helium")) {
            if (GasHelper.TRANSLATION_MAP.containsKey(stack.fluidName)) {
                fluidStackList.add(AbstractRecipeHandler.fluidStack(GasHelper.TRANSLATION_MAP.get(stack.fluidName), stack.amount));
            } else {
                fluidStackList.add(AbstractRecipeHandler.fluidStack("liquid" + stack.fluidName, stack.amount));
            }
        }
        if (ModCheck.techRebornLoaded()) {
            fluidStackList.add(AbstractRecipeHandler.fluidStack("fluid" + stack.fluidName, stack.amount));
        }
        return fluidStackList;
    }

    public static RecipeMatchResult matchIngredients(IngredientSorption sorption, List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List items, List fluids, boolean shapeless) {
        if (itemIngredients.size() != items.size() || fluidIngredients.size() != fluids.size()) {
            return RecipeMatchResult.FAIL;
        }
        ArrayList<Integer> itemIngredientNumbers = new ArrayList<Integer>(Collections.nCopies(itemIngredients.size(), 0));
        ArrayList<Integer> fluidIngredientNumbers = new ArrayList<Integer>(Collections.nCopies(fluidIngredients.size(), 0));
        List<Integer> itemInputOrder = CollectionHelper.increasingList(itemIngredients.size());
        List<Integer> fluidInputOrder = CollectionHelper.increasingList(fluidIngredients.size());
        if (!shapeless) {
            int i;
            for (i = 0; i < items.size(); ++i) {
                IngredientMatchResult matchResult = itemIngredients.get(i).match(items.get(i), sorption);
                if (!matchResult.matches()) {
                    return RecipeMatchResult.FAIL;
                }
                itemIngredientNumbers.set(i, matchResult.getIngredientNumber());
            }
            for (i = 0; i < fluids.size(); ++i) {
                Object fluid = fluids.get(i) instanceof Tank ? ((Tank)((Object)fluids.get(i))).getFluid() : fluids.get(i);
                IngredientMatchResult matchResult = fluidIngredients.get(i).match(fluid, sorption);
                if (!matchResult.matches()) {
                    return RecipeMatchResult.FAIL;
                }
                fluidIngredientNumbers.set(i, matchResult.getIngredientNumber());
            }
        } else {
            ArrayList<IItemIngredient> itemIngredientsRemaining = new ArrayList<IItemIngredient>(itemIngredients);
            for (int i = 0; i < items.size(); ++i) {
                IngredientMatchResult matchResult;
                int j;
                block13: {
                    for (j = 0; j < itemIngredients.size(); ++j) {
                        IItemIngredient itemIngredient = (IItemIngredient)itemIngredientsRemaining.get(j);
                        if (itemIngredient == null || !(matchResult = itemIngredient.match(items.get(i), sorption)).matches()) {
                            continue;
                        }
                        break block13;
                    }
                    return RecipeMatchResult.FAIL;
                }
                itemIngredientsRemaining.set(j, null);
                itemIngredientNumbers.set(i, matchResult.getIngredientNumber());
                itemInputOrder.set(i, j);
            }
            ArrayList<IFluidIngredient> fluidIngredientsRemaining = new ArrayList<IFluidIngredient>(fluidIngredients);
            for (int i = 0; i < fluids.size(); ++i) {
                IngredientMatchResult matchResult;
                int j;
                block14: {
                    Object fluid = fluids.get(i) instanceof Tank ? ((Tank)((Object)fluids.get(i))).getFluid() : fluids.get(i);
                    for (j = 0; j < fluidIngredients.size(); ++j) {
                        IFluidIngredient fluidIngredient = (IFluidIngredient)fluidIngredientsRemaining.get(j);
                        if (fluidIngredient == null || !(matchResult = fluidIngredient.match(fluid, sorption)).matches()) {
                            continue;
                        }
                        break block14;
                    }
                    return RecipeMatchResult.FAIL;
                }
                fluidIngredientsRemaining.set(j, null);
                fluidIngredientNumbers.set(i, matchResult.getIngredientNumber());
                fluidInputOrder.set(i, j);
            }
        }
        return new RecipeMatchResult(true, itemIngredientNumbers, fluidIngredientNumbers, itemInputOrder, fluidInputOrder);
    }

    public static List<String> getItemIngredientNames(List<IItemIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IItemIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyItemIngredient) {
                ingredientNames.add("null");
                continue;
            }
            if (ingredient instanceof ItemArrayIngredient) {
                ingredientNames.add(((ItemArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> getFluidIngredientNames(List<IFluidIngredient> ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (IFluidIngredient ingredient : ingredientList) {
            if (ingredient == null || ingredient instanceof EmptyFluidIngredient) {
                ingredientNames.add("null");
                continue;
            }
            if (ingredient instanceof FluidArrayIngredient) {
                ingredientNames.add(((FluidArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static String getAllIngredientNamesConcat(List<IItemIngredient> itemIngredientList, List<IFluidIngredient> fluidIngredientList) {
        return StringHelper.stringListConcat(RecipeHelper.getItemIngredientNames(itemIngredientList), RecipeHelper.getFluidIngredientNames(fluidIngredientList));
    }

    public static String getRecipeString(List<IItemIngredient> itemIngredientList, List<IFluidIngredient> fluidIngredientList, List<IItemIngredient> itemProductList, List<IFluidIngredient> fluidProductList) {
        return RecipeHelper.getAllIngredientNamesConcat(itemIngredientList, fluidIngredientList) + " -> " + RecipeHelper.getAllIngredientNamesConcat(itemProductList, fluidProductList);
    }

    public static String getRecipeString(IRecipe recipe) {
        if (recipe == null) {
            return "nullRecipe";
        }
        return RecipeHelper.getRecipeString(recipe.itemIngredients(), recipe.fluidIngredients(), recipe.itemProducts(), recipe.fluidProducts());
    }

    public static List<String> buildItemIngredientNames(List ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Object obj : ingredientList) {
            IItemIngredient ingredient;
            if (obj == null) {
                ingredientNames.add("null");
                continue;
            }
            if (!(obj instanceof IItemIngredient)) {
                obj = RecipeHelper.buildItemIngredient(obj);
            }
            if ((ingredient = (IItemIngredient)obj) instanceof ItemArrayIngredient) {
                ingredientNames.add(((ItemArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<String> buildFluidIngredientNames(List ingredientList) {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Object obj : ingredientList) {
            IFluidIngredient ingredient;
            if (obj == null) {
                ingredientNames.add("null");
                continue;
            }
            if (!(obj instanceof IFluidIngredient)) {
                obj = RecipeHelper.buildFluidIngredient(obj);
            }
            if ((ingredient = (IFluidIngredient)obj) instanceof FluidArrayIngredient) {
                ingredientNames.add(((FluidArrayIngredient)ingredient).getIngredientRecipeString());
                continue;
            }
            ingredientNames.add(ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName());
        }
        return ingredientNames;
    }

    public static List<List<String>> validFluids(ProcessorRecipeHandler recipes) {
        return RecipeHelper.validFluids(recipes, new ArrayList<String>());
    }

    public static List<List<String>> validFluids(ProcessorRecipeHandler recipes, List<String> exceptions) {
        int i;
        int fluidInputSize = recipes.fluidInputSize;
        int fluidOutputSize = recipes.fluidOutputSize;
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (Object fluid : FluidRegistry.getRegisteredFluids().values()) {
            fluidStackList.add(new FluidStack((Fluid)fluid, 1000));
        }
        ArrayList<String> fluidNameList = new ArrayList<String>();
        for (FluidStack fluidStack : fluidStackList) {
            String fluidName = fluidStack.getFluid().getName();
            if (!recipes.isValidFluidInput(fluidStack) || exceptions.contains(fluidName)) continue;
            fluidNameList.add(fluidName);
        }
        ArrayList<List<String>> allowedFluidLists = new ArrayList<List<String>>();
        for (i = 0; i < fluidInputSize; ++i) {
            allowedFluidLists.add(fluidNameList);
        }
        for (i = fluidInputSize; i < fluidInputSize + fluidOutputSize; ++i) {
            allowedFluidLists.add(null);
        }
        return allowedFluidLists;
    }

    public static OreIngredient getOreStackFromItems(List<ItemStack> stackList, int stackSize) {
        if (stackList == null || stackList.isEmpty()) {
            return null;
        }
        String oreName = OreDictHelper.getOreNameFromStacks(stackList);
        if (oreName.equals("Unknown")) {
            return null;
        }
        return new OreIngredient(oreName, stackSize);
    }

    public static InventoryCrafting fakeCrafter(int width, int height) {
        return new FakeCrafting(width, height);
    }

    private static class FakeCrafting
    extends InventoryCrafting {
        private static final FakeCraftingContainer FAKE_CONTAINER = new FakeCraftingContainer();

        private FakeCrafting(int width, int height) {
            super((Container)FAKE_CONTAINER, width, height);
        }

        private static class FakeCraftingContainer
        extends Container {
            private FakeCraftingContainer() {
            }

            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

