/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeHelper;
import nc.util.ItemStackHelper;
import nc.util.OreDictHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ManufactoryRecipes
extends ProcessorRecipeHandler {
    public ManufactoryRecipes() {
        super("manufactory", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addRecipe("coal", "dustCoal", 0.5, 1.0);
        this.addRecipe("dustCoal", "dustGraphite", 0.25, 0.5);
        this.addRecipe("charcoal", "dustCharcoal", 0.5, 0.5);
        this.addRecipe("gemDiamond", "dustDiamond", 1.5, 1.5);
        this.addRecipe("gemLapis", "dustLapis", 1.0, 1.0);
        this.addRecipe("gemRhodochrosite", "dustRhodochrosite", 1.5, 1.5);
        this.addRecipe("gemQuartz", "dustQuartz", 1.0, 1.0);
        this.addRecipe("gemPrismarine", "dustPrismarine", 1.0, 1.0);
        this.addRecipe("gemBoronNitride", "dustBoronNitride", 1.5, 1.5);
        this.addRecipe("gemFluorite", "dustFluorite", 1.5, 1.5);
        this.addRecipe("gemVilliaumite", "dustVilliaumite", 1.5, 1.5);
        this.addRecipe("gemCarobbiite", "dustCarobbiite", 1.5, 1.5);
        this.addRecipe("dustVilliaumite", "dustSodiumFluoride", 1.0, 1.0);
        this.addRecipe("dustCarobbiite", "dustPotassiumFluoride", 1.0, 1.0);
        if (OreDictHelper.oreExists("ingotSilicon")) {
            this.addRecipe("sand", "ingotSilicon", 1.0, 1.0);
            this.addRecipe("ingotSilicon", "itemSilicon", 0.5, 0.5);
        } else {
            this.addRecipe("sand", "itemSilicon", 1.0, 1.0);
        }
        this.addRecipe("obsidian", ManufactoryRecipes.oreStack("dustObsidian", 4), 2.0, 1.0);
        this.addRecipe("cobblestone", Blocks.field_150354_m, 1.0, 1.0);
        this.addRecipe("gravel", Items.field_151145_ak, 1.0, 1.0);
        this.addRecipe("endstone", "dustEndstone", 1.0, 1.0);
        this.addRecipe(Items.field_151072_bj, new ItemStack(Items.field_151065_br, 4), 1.0, 1.0);
        this.addRecipe(new ItemStack(Items.field_151078_bh, 4), Items.field_151116_aA, 0.5, 1.0);
        this.addRecipe(new ItemStack(Items.field_151120_aE, 2), "bioplastic", 1.0, 0.5);
        this.addRecipe("cropWheat", "dustWheat", 0.25, 0.5);
        this.addRecipe("cropBarley", "dustBarley", 0.25, 0.5);
        this.addRecipe("bone", new ItemStack(Items.field_151100_aR, 6, 15), 0.5, 1.0);
        this.addRecipe(NCItems.roasted_cocoa_beans, NCItems.ground_cocoa_nibs, 0.5, 0.5);
        this.addRecipe(Items.field_151147_al, new ItemStack(NCItems.gelatin, 8), 0.5, 0.5);
        this.addRecipe(Lists.newArrayList((Object[])new Object[]{Items.field_151115_aP, new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_151115_aP, 1, 2), new ItemStack(Items.field_151115_aP, 1, 3)}), new ItemStack(NCItems.gelatin, 4), 0.5, 0.5);
        this.addRecipe("itemPrecientCrystal", "itemPrecientPowder", 1.0, 1.0);
        this.addRecipe("itemVibrantCrystal", "itemVibrantPowder", 1.0, 1.0);
        this.addRecipe("itemPulsatingCrystal", "itemPulsatingPowder", 1.0, 1.0);
        this.addRecipe("itemPulsatingCrystal", "itemPulsatingPowder", 1.0, 1.0);
        this.addRecipe("itemEnderCrystal", "itemEnderCrystalPowder", 1.0, 1.0);
        this.addRecipe(ManufactoryRecipes.oreStack("dustCoke", 8), "dustHOPGraphite", 2.0, 2.0);
        this.addRecipe(Blocks.field_150435_aG, ManufactoryRecipes.oreStack("dustClay", 2), 1.0, 0.5);
        this.addRecipe("stone", ManufactoryRecipes.oreStack("dustStone", 2), 1.0, 1.0);
        this.addRecipe("sandstone", ManufactoryRecipes.oreStack("dustSaltpeter", 2), 1.0, 1.0);
        if (NCConfig.ore_processing) {
            this.addRecipe("oreDilithium", ManufactoryRecipes.oreStack("dustDilithium", 2), 1.25, 1.0);
            this.addRecipe("ingotDilithium", "dustDilithium", 1.0, 1.0);
        }
        this.addRecipe(Items.field_151079_bi, ManufactoryRecipes.oreStackList(Lists.newArrayList((Object[])new String[]{"dustEnder", "dustEnderPearl"}), 2), 0.5, 1.0);
        this.addRecipe("crystalCertusQuartz", "dustCertusQuartz", 0.5, 1.0);
        this.addRecipe("crystalFluix", "dustFluix", 0.5, 1.0);
        if (NCConfig.ore_processing) {
            this.addMetalProcessingRecipes();
        }
        this.addRecipe("plankWood", new ItemStack(Items.field_151055_y, NCConfig.manufactory_wood[1]), 0.25, 0.5);
        this.addLogRecipes();
    }

    public void addMetalProcessingRecipes() {
        for (String ingot : OreDictionary.getOreNames()) {
            if (!ingot.startsWith("ingot")) continue;
            String ore = "ore" + ingot.substring(5);
            String dust = "dust" + ingot.substring(5);
            if (!OreDictHelper.oreExists(dust)) continue;
            this.addRecipe(ore, ManufactoryRecipes.oreStack(dust, 2), 1.25, 1.0);
            this.addRecipe(ingot, dust, 1.0, 1.0);
        }
    }

    public void addLogRecipes() {
        InventoryCrafting fakeCrafter = RecipeHelper.fakeCrafter(3, 3);
        for (ItemStack logWood : OreDictionary.getOres((String)"logWood", (boolean)false)) {
            Block logBlock = Block.func_149634_a((Item)logWood.func_77973_b());
            if (ItemStackHelper.getMetadata(logWood) == Short.MAX_VALUE) {
                NonNullList logVariants = NonNullList.func_191196_a();
                logBlock.func_149666_a(logBlock.func_149708_J(), logVariants);
                for (ItemStack log : logVariants) {
                    fakeCrafter.func_70299_a(0, log);
                    ItemStack plankWood = CraftingManager.func_82787_a((InventoryCrafting)fakeCrafter, null);
                    if (plankWood.func_190926_b()) continue;
                    plankWood.func_190920_e(NCConfig.manufactory_wood[0]);
                    this.addRecipe(log, plankWood, 0.5, 0.5);
                }
                continue;
            }
            fakeCrafter.func_70299_a(0, logWood);
            ItemStack plankWood = CraftingManager.func_82787_a((InventoryCrafting)fakeCrafter, null);
            if (plankWood.func_190926_b()) continue;
            plankWood.func_190920_e(NCConfig.manufactory_wood[0]);
            this.addRecipe(logWood, plankWood, 0.5, 0.5);
        }
    }
}

