/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.List;
import nc.config.NCConfig;
import nc.util.CollectionHelper;
import nc.util.FontRenderHelper;
import nc.util.Lang;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class InfoHelper {
    private static final int MINIMUM_TEXT_WIDTH = 225;
    public static final String SHIFT_STRING = Lang.localise("gui.inventory.shift_for_info");
    public static final String CTRL_STRING = Lang.localise("gui.inventory.ctrl_for_info");
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String[][] EMPTY_ARRAYS = new String[0][];

    public static void infoLine(List list, TextFormatting fixedColor, String line) {
        list.add(fixedColor + line);
    }

    public static void infoLine(List list, String line) {
        InfoHelper.infoLine(list, TextFormatting.AQUA, line);
    }

    public static void shiftInfo(List list) {
        list.add(TextFormatting.ITALIC + (NCConfig.ctrl_info ? CTRL_STRING : SHIFT_STRING));
    }

    public static void fixedInfoList(List list, boolean infoBelow, TextFormatting fixedColor, String ... fixedLines) {
        for (int i = 0; i < fixedLines.length; ++i) {
            InfoHelper.infoLine(list, fixedColor, fixedLines[i]);
        }
        if (infoBelow) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static boolean shift() {
        return NCConfig.ctrl_info ? Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) : Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static void infoList(List list, String ... lines) {
        for (int i = 0; i < lines.length; ++i) {
            InfoHelper.infoLine(list, lines[i]);
        }
    }

    public static void infoFull(List list, TextFormatting fixedColor, String[] fixedLines, String ... lines) {
        if (!(fixedLines == EMPTY_ARRAY || InfoHelper.shift() && lines != EMPTY_ARRAY)) {
            InfoHelper.fixedInfoList(list, lines != EMPTY_ARRAY, fixedColor, fixedLines);
        } else if (InfoHelper.shift() && lines != EMPTY_ARRAY || lines.length == 1) {
            InfoHelper.infoList(list, lines);
        } else if (lines != EMPTY_ARRAY) {
            InfoHelper.shiftInfo(list);
        }
    }

    public static void infoFull(List list, String ... lines) {
        InfoHelper.infoFull(list, TextFormatting.AQUA, EMPTY_ARRAY, lines);
    }

    public static String[] formattedInfo(String tooltip, Object ... args) {
        return FontRenderHelper.formattedString(Lang.localise(tooltip, args), 225);
    }

    public static String[] buildFixedInfo(String unlocName, String ... tooltip) {
        if (tooltip.length == 0) {
            return InfoHelper.standardFixedInfo(unlocName);
        }
        return tooltip;
    }

    public static String[] buildInfo(String unlocName, String ... tooltip) {
        if (tooltip.length == 0) {
            return InfoHelper.standardInfo(unlocName);
        }
        return tooltip;
    }

    public static String[] standardFixedInfo(String unlocName) {
        return InfoHelper.standardFixedInfo(unlocName, unlocName);
    }

    public static String[] standardInfo(String unlocName) {
        return InfoHelper.standardInfo(unlocName, unlocName);
    }

    public static <T extends Enum<T>> String[][] buildFixedInfo(String unlocNameBase, Class<T> enumm, String[] ... tooltips) {
        return InfoHelper.buildGeneralInfo(unlocNameBase, enumm, ".fixd", ".fix", tooltips);
    }

    public static <T extends Enum<T>> String[][] buildInfo(String unlocNameBase, Class<T> enumm, String[] ... tooltips) {
        return InfoHelper.buildGeneralInfo(unlocNameBase, enumm, ".desc", ".des", tooltips);
    }

    public static <T extends Enum<T>> String[][] buildGeneralInfo(String unlocNameBase, Class<T> enumm, String desc, String des, String[] ... tooltips) {
        String[] names = InfoHelper.getEnumNames(enumm);
        String[][] strings = new String[names.length][];
        for (int i = 0; i < names.length; ++i) {
            strings[i] = CollectionHelper.isNull(tooltips, i) ? EMPTY_ARRAY : (CollectionHelper.isEmpty(tooltips, i) ? InfoHelper.standardGeneralInfo(unlocNameBase + "." + names[i], unlocNameBase, desc, des) : tooltips[i]);
        }
        return strings;
    }

    public static String[] standardFixedInfo(String unlocName, String generalName) {
        return InfoHelper.standardGeneralInfo(unlocName, generalName, ".fixd", ".fix");
    }

    public static String[] standardInfo(String unlocName, String generalName) {
        return InfoHelper.standardGeneralInfo(unlocName, generalName, ".desc", ".des");
    }

    public static String[] standardGeneralInfo(String unlocName, String generalName, String desc, String des) {
        for (String name : new String[]{unlocName, generalName}) {
            if (!Lang.canLocalise(name + desc)) continue;
            return InfoHelper.formattedInfo(name + desc, new Object[0]);
        }
        return InfoHelper.getNumberedInfo(unlocName + des);
    }

    public static String[] getNumberedInfo(String base) {
        String firstLine = base + 0;
        if (!Lang.canLocalise(firstLine)) {
            return EMPTY_ARRAY;
        }
        String[] info = new String[]{Lang.localise(firstLine)};
        int line = 1;
        while (Lang.canLocalise(base + line)) {
            info = CollectionHelper.concatenate(info, Lang.localise(base + line));
            ++line;
        }
        return info;
    }

    public static <T extends Enum<T>> String[] getEnumNames(Class<T> enumm) {
        Enum[] values = (Enum[])enumm.getEnumConstants();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return names;
    }
}

