/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.IllegalFormatException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.Chisel;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.common.config.Configurations;

@ParametersAreNonnullByDefault
public class ItemChiselBlock
extends ItemBlock {
    private ICarvable block;

    public ItemChiselBlock(Block block) {
        super(block);
        this.block = (ICarvable)block;
        this.func_77627_a(true);
    }

    private String getTooltipUnloc(ItemStack stack) {
        VariationData varData = this.block.getVariationData(stack.func_77952_i());
        return stack.func_77977_a() + "." + varData.name + ".desc.";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        try {
            int line = Configurations.blockDescriptions ? 1 : 2;
            String desc = this.getTooltipUnloc(stack);
            while (I18n.func_94522_b((String)(desc + line)) || line == 1) {
                tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)(desc + line), (Object[])new Object[0]));
                desc.replaceAll(line++ + "$", "." + line);
            }
        }
        catch (Exception ignored) {
            tooltip.add("chisel.tooltip.invalid");
        }
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77653_i(@Nonnull ItemStack stack) {
        if (!Configurations.blockDescriptions) {
            String unlocpattern = "chisel.tooltip.blockname";
            String ret = null;
            try {
                ret = I18n.func_74837_a((String)unlocpattern, (Object[])new Object[]{super.func_77653_i(stack), I18n.func_74837_a((String)(this.getTooltipUnloc(stack) + "1"), (Object[])new Object[0])});
            }
            catch (IllegalFormatException e) {
                String raw = I18n.func_74838_a((String)unlocpattern);
                Chisel.logger.error("Invalid name pattern {}, check your resource pack lang key for {}", (Object)raw, (Object)unlocpattern);
            }
            if (ret != null) {
                return ret;
            }
        }
        return super.func_77653_i(stack);
    }
}

