/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.voice.VoiceClient;
import mekanism.common.Mekanism;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VoiceInput
extends Thread {
    private VoiceClient voiceClient;
    private DataLine.Info microphone;
    private TargetDataLine targetLine;

    public VoiceInput(VoiceClient client) {
        this.voiceClient = client;
        this.microphone = new DataLine.Info(TargetDataLine.class, this.voiceClient.getAudioFormat(), 2200);
        this.setDaemon(true);
        this.setName("VoiceServer Client Input Thread");
    }

    @Override
    public void run() {
        try {
            if (!AudioSystem.isLineSupported(this.microphone)) {
                Mekanism.logger.info("No audio system available.");
                return;
            }
            this.targetLine = (TargetDataLine)AudioSystem.getLine(this.microphone);
            this.targetLine.open(this.voiceClient.getAudioFormat(), 2200);
            this.targetLine.start();
            AudioInputStream audioInput = new AudioInputStream(this.targetLine);
            boolean doFlush = false;
            while (this.voiceClient.isRunning()) {
                if (MekanismKeyHandler.voiceKey.func_151468_f()) {
                    this.targetLine.flush();
                    while (this.voiceClient.isRunning() && MekanismKeyHandler.voiceKey.func_151468_f()) {
                        try {
                            int availableBytes = audioInput.available();
                            byte[] audioData = new byte[availableBytes > 2200 ? 2200 : availableBytes];
                            int bytesRead = audioInput.read(audioData, 0, audioData.length);
                            if (bytesRead <= 0) continue;
                            this.voiceClient.getOutputStream().writeShort(audioData.length);
                            this.voiceClient.getOutputStream().write(audioData);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    doFlush = true;
                } else if (doFlush) {
                    try {
                        this.voiceClient.getOutputStream().flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    doFlush = false;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
            audioInput.close();
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while running client input thread.", (Throwable)e);
        }
    }

    public void close() {
        if (this.targetLine != null) {
            this.targetLine.flush();
            this.targetLine.close();
        }
    }
}

