/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.LibRegistry;
import p455w0rdslib.util.ProxiedUtils;

public class PlayerUUIDUtils {
    public static String getPlayerName(UUID uuid) {
        String retVal = "";
        try {
            retVal = LibGlobals.THREAD_POOL.submit(() -> PlayerUUIDUtils.fetchPlayerName(uuid)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        return retVal;
    }

    public static UUID getPlayerUUID(String name) {
        try {
            return LibGlobals.THREAD_POOL.submit(() -> PlayerUUIDUtils.fetchPlayerUUID(name)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    public static EntityPlayer getPlayerFromWorld(World world, UUID player) {
        if (player == null || world == null) {
            return null;
        }
        return world.func_152378_a(player);
    }

    private static String fetchPlayerName(UUID uuid) throws IOException {
        if (LibRegistry.getNameRegistry().containsKey(uuid)) {
            return LibRegistry.getNameRegistry().get(uuid);
        }
        String USERNAME_API_URL = "https://api.mojang.com/user/profiles/%s/names";
        CharMatcher DASH_MATCHER = CharMatcher.is((char)'-');
        String uuidString = DASH_MATCHER.removeFrom((CharSequence)uuid.toString());
        try (BufferedReader reader = Resources.asCharSource((URL)new URL(String.format(USERNAME_API_URL, uuidString)), (Charset)StandardCharsets.UTF_8).openBufferedStream();){
            JsonReader json = new JsonReader((Reader)reader);
            json.beginArray();
            String name = null;
            long when = 0L;
            while (json.hasNext()) {
                String nameObj = null;
                long timeObj = 0L;
                json.beginObject();
                block18: while (json.hasNext()) {
                    String key;
                    switch (key = json.nextName()) {
                        case "name": {
                            nameObj = json.nextString();
                            continue block18;
                        }
                        case "changedToAt": {
                            timeObj = json.nextLong();
                            continue block18;
                        }
                    }
                    json.skipValue();
                }
                json.endObject();
                if (nameObj == null || timeObj < when) continue;
                name = nameObj;
            }
            json.endArray();
            json.close();
            name = name == null ? "" : name;
            LibRegistry.registerName(uuid, name);
            String string = name;
            return string;
        }
    }

    private static UUID fetchPlayerUUID(String name) {
        if (LibRegistry.getUUIDRegistry().containsKey(name)) {
            return LibRegistry.getUUIDRegistry().get(name);
        }
        if (!ProxiedUtils.isSMP() && ProxiedUtils.isClientSide() && ProxiedUtils.getWorld() != null && ProxiedUtils.getPlayer() != null) {
            UUID uuid = ProxiedUtils.getPlayer().func_146103_bH().getId();
            LibRegistry.registerUUID(name, uuid);
            return uuid;
        }
        if (!Strings.isNullOrEmpty((String)name)) {
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                JsonObject profile = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream()));
                UUID uuid = UUID.fromString(PlayerUUIDUtils.fullUUID(profile.get("id").toString()));
                LibRegistry.registerUUID(name, uuid);
                return uuid;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String fullUUID(String uuid) {
        uuid = uuid.replaceAll("[^a-zA-Z0-9]", "");
        uuid = uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, 32);
        return uuid;
    }
}

