/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageSyncAdvancements;

public final class AdvancementSyncHandler {
    public static Set<String> trackedNamespaces = new HashSet<String>();
    public static List<ResourceLocation> syncedAdvancements = null;

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            AdvancementSyncHandler.buildSyncSet(player);
            if (syncedAdvancements.contains(event.getAdvancement().func_192067_g())) {
                AdvancementSyncHandler.syncPlayer(player, true);
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            AdvancementSyncHandler.buildSyncSet(player);
            AdvancementSyncHandler.syncPlayer(player, false);
        }
    }

    private static void buildSyncSet(EntityPlayerMP player) {
        if (syncedAdvancements == null) {
            AdvancementManager manager = player.func_184102_h().func_191949_aK();
            Iterable allAdvancements = manager.func_192780_b();
            syncedAdvancements = new ArrayList<ResourceLocation>();
            for (Advancement a : allAdvancements) {
                if (a == null || !trackedNamespaces.contains(a.func_192067_g().func_110624_b())) continue;
                syncedAdvancements.add(a.func_192067_g());
            }
        }
    }

    public static void syncPlayer(EntityPlayerMP player, boolean showToast) {
        PlayerAdvancements advancements = player.func_192039_O();
        if (advancements == null) {
            return;
        }
        AdvancementManager manager = player.func_184102_h().func_191949_aK();
        LinkedList<String> completed = new LinkedList<String>();
        for (ResourceLocation res : syncedAdvancements) {
            AdvancementProgress p;
            Advancement adv = manager.func_192778_a(res);
            if (adv == null || !(p = advancements.func_192747_a(adv)).func_192105_a()) continue;
            completed.add(res.toString());
        }
        String[] completedArr = completed.toArray(new String[0]);
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncAdvancements(completedArr, showToast), player);
    }
}

