/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.tile.TileSuperMobSpawner;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.world.World;

public class BlockSuperMobSpawner
extends XUBlockStatic {
    public BlockSuperMobSpawner() {
        super(Material.field_151576_e);
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        return new BoxModel(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f).setTexture("mob_spawner")).setLayer(BlockRenderLayer.TRANSLUCENT);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileSuperMobSpawner();
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound var4;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        LinkedList list = Lists.newLinkedList();
        if (nbt.func_150297_b("SpawnPotentials", 9)) {
            NBTTagList nbttagcompound = nbt.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < nbttagcompound.func_74745_c(); ++i) {
                list.add(new WeightedSpawnerEntity(nbttagcompound.func_150305_b(i)));
            }
        }
        if (!(var4 = nbt.func_74775_l("SpawnData")).func_150297_b("id", 8)) {
            var4.func_74778_a("id", "Pig");
        }
        list.addFirst(new WeightedSpawnerEntity(1, var4));
        HashSet names = Sets.newHashSet();
        for (WeightedSpawnerEntity weightedSpawnerEntity : list) {
            NBTTagCompound entityTags = weightedSpawnerEntity.func_185277_b();
            if (!entityTags.func_74764_b("id")) continue;
            String id = entityTags.func_74779_i("id");
            String animal_name = CompatHelper.getName(id);
            names.add(animal_name);
        }
        tooltip.addAll(names);
    }
}

