/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.transfernodes.Grocket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class GrocketPower
extends Grocket
implements IPower {
    public static final String NBT_FREQUENCY = "Frequency";
    public static final String NBT_ACTIVE = "Active";
    public int frequency;
    public boolean active;

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a(NBT_FREQUENCY, this.frequency);
        compound.func_74757_a(NBT_ACTIVE, this.active);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.frequency = tag.func_74762_e(NBT_FREQUENCY);
        this.active = tag.func_74767_n(NBT_ACTIVE);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getType().createStack().func_82833_r();
    }

    @Override
    @Nullable
    public World world() {
        return this.holder.func_145831_w();
    }

    @Override
    public int frequency() {
        return this.frequency;
    }

    @Override
    public void powerChanged(boolean powered) {
        if (this.active != powered) {
            this.active = powered;
            this.holder.func_70296_d();
            this.onPowerChanged();
        }
    }

    @Override
    public IWorldPowerMultiplier getMultiplier() {
        return IWorldPowerMultiplier.CONSTANT;
    }

    public void onPowerChanged() {
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.holder.func_145831_w().field_72995_K) {
            PowerManager.instance.addPowerHandler(this);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (!this.holder.func_145831_w().field_72995_K) {
            PowerManager.instance.removePowerHandler(this);
        }
    }

    @Override
    public void onPlaced(EntityPlayer placer) {
        if (!this.holder.func_145831_w().field_72995_K && placer instanceof EntityPlayerMP) {
            this.frequency = Freq.getBasePlayerFreq((EntityPlayerMP)placer);
        }
    }

    public boolean isValidPlayer(EntityPlayer playerIn) {
        return PowerManager.canUse(playerIn, this);
    }
}

