/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers.accessories;

import c4.conarm.ConstructsArmory;
import c4.conarm.client.models.accessories.ModelBelt;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.modifiers.IAccessoryRender;
import c4.conarm.lib.utils.ConstructUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;

public class ModTravelPotion
extends AccessoryModifier
implements IAccessoryRender {
    private static final String TAG_POTION = "potions";
    @SideOnly(value=Side.CLIENT)
    private static ModelBelt model;
    private static ResourceLocation texture;

    public ModTravelPotion() {
        super("potion_belt");
    }

    @Override
    public void onKeybinding(ItemStack armor, EntityPlayer player) {
        player.openGui((Object)ConstructsArmory.instance, 1, player.field_70170_p, 0, 0, 0);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        NBTTagCompound oldBelt = modifierTag.func_74775_l(TAG_POTION);
        if (oldBelt.func_82582_d()) {
            modifierTag.func_74782_a(TAG_POTION, (NBTBase)new ItemStackHandler(7).serializeNBT());
        } else {
            modifierTag.func_74782_a(TAG_POTION, (NBTBase)oldBelt);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onAccessoryRender(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (model == null) {
            model = new ModelBelt();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS && super.canApplyCustom(stack);
    }

    static {
        texture = ConstructUtils.getResource("textures/models/accessories/travel_belt.png");
    }

    public static class PotionsData
    extends ModifierNBT {
        public ItemStackHandler potions = new ItemStackHandler(7);

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.potions.deserializeNBT(tag.func_74775_l(ModTravelPotion.TAG_POTION));
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74782_a(ModTravelPotion.TAG_POTION, (NBTBase)this.potions.serializeNBT());
        }
    }
}

