/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity.transvector;

import com.nekokittygames.thaumictinkerer.common.blocks.transvector.BlockTransvectorDislocator;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.tileentity.transvector.TileEntityTransvector;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.lib.utils.BlockUtils;

public class TileEntityTransvectorDislocator
extends TileEntityTransvector {
    boolean powered = false;
    private int cooldown = 0;

    @Override
    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        if (compound.func_74764_b("powered")) {
            this.powered = compound.func_74767_n("powered");
        }
        if (compound.func_74764_b("cooldown")) {
            this.cooldown = compound.func_74762_e("cooldown");
        }
    }

    @Override
    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        compound.func_74757_a("powered", this.powered);
        compound.func_74768_a("cooldown", this.cooldown);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.cooldown = Math.max(0, this.cooldown - 1);
        if (this.cooldown == 0 && this.powered) {
            this.powered = false;
            this.receiveRedstonePulse();
        }
    }

    public void receiveRedstonePulse() {
        this.getTile();
        if (this.getTilePos() == null) {
            return;
        }
        if (this.cooldown > 0) {
            this.powered = true;
            return;
        }
        BlockPos targetCoords = this.getBlockTarget();
        if (!this.field_145850_b.func_175623_d(this.getTilePos())) {
            BlockData endData = new BlockData(this.getTilePos());
            BlockData targetData = new BlockData(targetCoords);
            if (this.checkBlock(targetCoords) && this.checkBlock(this.getTilePos())) {
                endData.clearTileEntityAt();
                targetData.clearTileEntityAt();
                endData.setTo(targetCoords);
                targetData.setTo(this.getTilePos());
            }
        }
        List<Entity> entitiesAtEnd = this.getEntitiesAtPoint(this.getTilePos());
        List<Entity> entitiesAtTarget = this.getEntitiesAtPoint(targetCoords);
        for (Entity entity : entitiesAtEnd) {
            this.moveEntity(entity, targetCoords);
        }
        for (Entity entity : entitiesAtTarget) {
            this.moveEntity(entity, this.getTilePos());
        }
        this.cooldown = 10;
    }

    private void moveEntity(Entity entity, BlockPos pos) {
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        } else {
            entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    private List<Entity> getEntitiesAtPoint(BlockPos coords) {
        return this.field_145850_b.func_72872_a(Entity.class, this.field_145850_b.func_180495_p(coords).func_185900_c((IBlockAccess)this.field_145850_b, coords));
    }

    private boolean checkBlock(BlockPos coords) {
        IBlockState state = this.field_145850_b.func_180495_p(coords);
        return !this.field_145850_b.func_175623_d(coords) && !BlockUtils.isPortableHoleBlackListed((IBlockState)state);
    }

    public BlockPos getBlockTarget() {
        EnumFacing dir = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTransvectorDislocator.FACING);
        return this.field_174879_c.func_177972_a(dir);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.setCheaty(true);
    }

    @Override
    public int getMaxDistance() {
        return TTConfig.transvectorDislocatorDistance * TTConfig.transvectorDislocatorDistance;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == newSate.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newSate);
    }

    class BlockData {
        IBlockState state;
        NBTTagCompound tile;
        BlockPos pos;

        public BlockData(IBlockState state, TileEntity tile, BlockPos pos) {
            this.state = state;
            if (tile != null) {
                NBTTagCompound cmp = new NBTTagCompound();
                tile.func_189515_b(cmp);
                this.tile = cmp;
            }
            this.pos = pos;
        }

        public BlockData(BlockPos pos) {
            this(this$0.field_145850_b.func_180495_p(pos), this$0.field_145850_b.func_175625_s(pos), pos);
        }

        public void clearTileEntityAt() {
            if (this.state != null) {
                TileEntity tileToSet = this.state.func_177230_c().createTileEntity(TileEntityTransvectorDislocator.this.field_145850_b, this.state);
                TileEntityTransvectorDislocator.this.field_145850_b.func_175690_a(this.pos, tileToSet);
            }
        }

        public void setTo(BlockPos pos) {
            TileEntityTransvectorDislocator.this.field_145850_b.func_180501_a(pos, this.state, 3);
            TileEntity tile = this.tile == null ? null : TileEntity.func_190200_a((World)TileEntityTransvectorDislocator.this.field_145850_b, (NBTTagCompound)this.tile);
            TileEntityTransvectorDislocator.this.field_145850_b.func_175690_a(pos, tile);
            if (tile != null) {
                tile.func_174878_a(pos);
                tile.func_145836_u();
            }
            if (this.state != null) {
                this.state.func_177230_c().onNeighborChange((IBlockAccess)TileEntityTransvectorDislocator.this.field_145850_b, pos, TileEntityTransvectorDislocator.this.func_174877_v());
            }
        }
    }
}

