/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import extracells.api.ECApi;
import extracells.api.IHandlerGasStorage;
import extracells.api.IPortableGasStorageCell;
import extracells.integration.Integration;
import extracells.inventory.ECFluidFilterInventory;
import extracells.inventory.InventoryPlain;
import extracells.item.ItemECBase;
import extracells.item.ItemGas$;
import extracells.item.PowerItem;
import extracells.item.PowerItem$class;
import extracells.item.storage.ItemStorageCellPortableFluid$;
import extracells.models.ModelManager;
import extracells.util.StorageChannels$;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ItemStorageCellPortableGas$
extends ItemECBase
implements IPortableGasStorageCell,
PowerItem {
    public static final ItemStorageCellPortableGas$ MODULE$;
    private final double MAX_POWER;
    private final boolean isMekanismGasEnabled;

    static {
        new ItemStorageCellPortableGas$();
    }

    @Override
    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return PowerItem$class.extractEnergy(this, container, maxExtract, simulate);
    }

    @Override
    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack arg0) {
        return PowerItem$class.getEnergyStored(this, arg0);
    }

    @Override
    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack arg0) {
        return PowerItem$class.getMaxEnergyStored(this, arg0);
    }

    @Override
    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return PowerItem$class.receiveEnergy(this, container, maxReceive, simulate);
    }

    @Override
    public double injectAEPower(ItemStack itemStack, double amt, Actionable actionable) {
        return PowerItem$class.injectAEPower(this, itemStack, amt, actionable);
    }

    @Override
    public double extractAEPower(ItemStack itemStack, double amt, Actionable actionable) {
        return PowerItem$class.extractAEPower(this, itemStack, amt, actionable);
    }

    @Override
    public double getAECurrentPower(ItemStack itemStack) {
        return PowerItem$class.getAECurrentPower(this, itemStack);
    }

    @Override
    public double getAEMaxPower(ItemStack itemStack) {
        return PowerItem$class.getAEMaxPower(this, itemStack);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return PowerItem$class.shouldCauseReequipAnimation(this, oldStack, newStack, slotChanged);
    }

    @Override
    public double MAX_POWER() {
        return this.MAX_POWER;
    }

    public boolean isMekanismGasEnabled() {
        return this.isMekanismGasEnabled;
    }

    public ItemStorageCellPortableGas$ THIS() {
        return this;
    }

    @SuppressWarnings(value={"rawtypes", "unchecked"})
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag par4) {
        List<String> list2 = list;
        ICellInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, (IStorageChannel)StorageChannels$.MODULE$.FLUID());
        if (handler instanceof IHandlerGasStorage) {
            IHandlerGasStorage cellHandler = (IHandlerGasStorage)handler;
            boolean partitioned = cellHandler.isFormatted();
            long usedBytes = cellHandler.usedBytes();
            double aeCurrentPower = this.getAECurrentPower(itemStack);
            list2.add(String.format(I18n.func_74838_a((String)"extracells.tooltip.storage.gas.bytes"), BoxesRunTime.boxToLong((long)(usedBytes / 250L)), BoxesRunTime.boxToInteger((int)(cellHandler.totalBytes() / 250))));
            list2.add(String.format(I18n.func_74838_a((String)"extracells.tooltip.storage.gas.types"), BoxesRunTime.boxToInteger((int)cellHandler.usedTypes()), BoxesRunTime.boxToInteger((int)cellHandler.totalTypes())));
            Object object = usedBytes != 0L ? BoxesRunTime.boxToBoolean((boolean)list2.add(String.format(I18n.func_74838_a((String)"extracells.tooltip.storage.gas.content"), BoxesRunTime.boxToLong((long)usedBytes)))) : BoxedUnit.UNIT;
            Object object2 = partitioned ? BoxesRunTime.boxToBoolean((boolean)list2.add(new StringBuilder().append((Object)I18n.func_74838_a((String)"gui.appliedenergistics2.Partitioned")).append((Object)" - ").append((Object)I18n.func_74838_a((String)"gui.appliedenergistics2.Precise")).toString())) : BoxedUnit.UNIT;
            list2.add(new StringBuilder().append((Object)I18n.func_74838_a((String)"gui.appliedenergistics2.StoredEnergy")).append((Object)": ").append((Object)BoxesRunTime.boxToDouble((double)aeCurrentPower)).append((Object)" AE - ").append((Object)BoxesRunTime.boxToDouble((double)(Math.floor(aeCurrentPower / this.MAX_POWER() * 10000.0) / 100.0))).append((Object)"%").toString());
            return;
        }
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new InvWrapper((IInventory)new ECFluidFilterInventory("configFluidCell", 63, is));
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - this.getAECurrentPower(itemStack) / ItemStorageCellPortableFluid$.MODULE$.MAX_POWER();
    }

    @Override
    public ArrayList<Object> getFilter(ItemStack stack) {
        return this.isMekanismGasEnabled() ? this.getFilterGas(stack) : new ArrayList<Object>();
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public ArrayList<Object> getFilterGas(ItemStack stack) {
        ECFluidFilterInventory inventory = new ECFluidFilterInventory("", 63, stack);
        ItemStack[] stacks = inventory.slots;
        ArrayList<Object> filter = new ArrayList<Object>();
        if (stacks.length == 0) {
            return null;
        }
        Predef$.MODULE$.refArrayOps((Object[])stacks).foreach((Function1)new Serializable(filter){
            private final ArrayList filter$1;

            public final Object apply(ItemStack stack) {
                Gas gas;
                return stack == null ? BoxedUnit.UNIT : ((gas = GasRegistry.getGas((String)ItemGas$.MODULE$.getGasName(stack))) == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.filter$1.add(gas)));
            }
            {
                this.filter$1 = filter$1;
            }
        });
        return filter;
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    @Override
    public int getMaxBytes(ItemStack is) {
        return 512;
    }

    @Override
    public int getMaxTypes(ItemStack unused) {
        return 3;
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return AccessRestriction.READ_WRITE;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(creativeTab)) {
            NonNullList<ItemStack> itemList2 = itemList;
            itemList2.add(new ItemStack((Item)this));
            ItemStack itemStack = new ItemStack((Item)this);
            this.injectAEPower(itemStack, this.MAX_POWER(), Actionable.MODULATE);
            itemList2.add(itemStack);
            return;
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.storage.gas.portable";
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new InvWrapper((IInventory)new InventoryPlain("configInventory", 0, 64));
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amount, ItemStack is) {
        return this.getAECurrentPower(is) >= amount;
    }

    public boolean isEditable(ItemStack is) {
        if (is == null) {
            return false;
        }
        Item item = is.func_77973_b();
        ItemStorageCellPortableGas$ itemStorageCellPortableGas$ = this;
        return !(item != null ? !item.equals(itemStorageCellPortableGas$) : itemStorageCellPortableGas$ != null);
    }

    @SuppressWarnings(value={"rawtypes", "unchecked"})
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ECApi.instance().openPortableGasCellGui(player, hand, world));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        manager.registerItemModel(item, 0, "storage/gas/portable");
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = is.func_77978_p();
        tag.func_74778_a("fuzzyMode", fzMode.name());
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        this.extractAEPower(is, amount, Actionable.MODULATE);
        return true;
    }

    private ItemStorageCellPortableGas$() {
        MODULE$ = this;
        PowerItem$class.$init$(this);
        this.MAX_POWER = 20000.0;
        this.isMekanismGasEnabled = Integration.Mods.MEKANISMGAS.isEnabled();
        this.func_77625_d(1);
        this.func_77656_e(0);
    }
}

