/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public class BrightnessHandler {
    private static Map<TileEntity, BrightnessHandler> TILE_BRIGHTNESS_HANDLERS = new HashMap<TileEntity, BrightnessHandler>();
    private static Map<Entity, BrightnessHandler> ENTITY_BRIGHTNESS_HANDLERS = new HashMap<Entity, BrightnessHandler>();
    public static final int[] STEPS_MOST = new int[]{850, 700, 775, 900, 800};
    public static final int[] STEPS_LEAST = new int[]{500, 475, 625, 700, 575};
    public static final float[] RADIUS_MOST = new float[]{2.0f, 2.5f, 2.1f, 1.9f, 2.5f};
    public static final float[] RADIUS_LEAST = new float[]{1.85f, 2.0f, 1.9f, 1.75f, 2.2f};
    private int brightness = 0;
    private boolean brightnessDir = false;
    private int step = 0;
    private boolean initLight = false;
    private final Random r = new Random();

    public BrightnessHandler() {
        this.step = this.r.nextInt(4);
        this.tick();
    }

    public static void tickAllHandlers() {
        for (Map.Entry<TileEntity, BrightnessHandler> entry : TILE_BRIGHTNESS_HANDLERS.entrySet()) {
            entry.getValue().tick();
        }
        for (Map.Entry<TileEntity, BrightnessHandler> entry : ENTITY_BRIGHTNESS_HANDLERS.entrySet()) {
            entry.getValue().tick();
        }
    }

    public static BrightnessHandler getBrightness(TileEntity tile) {
        if (!TILE_BRIGHTNESS_HANDLERS.containsKey(tile)) {
            TILE_BRIGHTNESS_HANDLERS.put(tile, new BrightnessHandler());
        }
        return TILE_BRIGHTNESS_HANDLERS.get(tile);
    }

    public static BrightnessHandler getBrightness(Entity entity) {
        if (!ENTITY_BRIGHTNESS_HANDLERS.containsKey(entity)) {
            ENTITY_BRIGHTNESS_HANDLERS.put(entity, new BrightnessHandler());
        }
        return ENTITY_BRIGHTNESS_HANDLERS.get(entity);
    }

    public int value() {
        return this.brightness;
    }

    public void tick() {
        if (!this.initLight) {
            this.step = this.r.nextInt(4);
            this.initLight = true;
        }
        if (this.brightnessDir) {
            this.brightness += 15;
            if (this.brightness > STEPS_MOST[this.step]) {
                this.brightnessDir = !this.brightnessDir;
                ++this.step;
                if (this.step > 4) {
                    this.step = 0;
                }
            }
        } else {
            this.brightness -= 15;
            if (this.brightness < STEPS_LEAST[this.step]) {
                this.brightnessDir = !this.brightnessDir;
                ++this.step;
                if (this.step > 4) {
                    this.step = 0;
                }
            }
        }
    }

    public void reset() {
        this.brightness = 0;
        this.brightnessDir = false;
        this.initLight = false;
    }
}

