/*
 * Decompiled with CFR 0.152.
 */
package nc.init;

import java.util.ArrayList;
import java.util.List;
import nc.ModCheck;
import nc.NuclearCraft;
import nc.block.fluid.NCBlockFluid;
import nc.config.NCConfig;
import nc.enumm.FluidType;
import nc.util.ColorHelper;
import nc.util.NCUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class NCFluids {
    public static List<Pair<Fluid, NCBlockFluid>> fluidPairList = new ArrayList<Pair<Fluid, NCBlockFluid>>();

    public static void init() {
        try {
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "oxygen", 8293576));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "hydrogen", 11762372));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "deuterium", 10383343));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "tritium", 6142934));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "helium3", 13351783));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "helium", 12942209));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "boron", 0x7D7D7D));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "boron10", 0x7D7D7D));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "boron11", 0x7D7D7D));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "lithium", 0xEFEFEF));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "lithium6", 0xEFEFEF));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "lithium7", 0xEFEFEF));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "ferroboron", 0x4A4A4A));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "tough", 1380129));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "hard_carbon", 1661296));
            if (NCFluids.registerCoFHAlt()) {
                fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "coal", 0x202020));
            }
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "beryllium", 13949890));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "manganese", 7505100));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "manganese_dioxide", 2629918));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "sulfur", 14605946));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "arsenic", 8488053));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SUPERFLUID, "liquidhelium"));
            fluidPairList.add(NCFluids.fluidPair(FluidType.LIQUID, "liquid_nitrogen", false, 3260986, 810, 70, 170));
            fluidPairList.add(NCFluids.fluidPair(FluidType.PLASMA, "plasma"));
            fluidPairList.add(NCFluids.fluidPair(FluidType.PARTICLE, "neutron"));
            fluidPairList.add(NCFluids.fluidPair(FluidType.FLAMMABLE, "ethanol", 6639936));
            fluidPairList.add(NCFluids.fluidPair(FluidType.FLAMMABLE, "methanol", 7426636));
            fluidPairList.add(NCFluids.fluidPair(FluidType.LIQUID, "radaway"));
            fluidPairList.add(NCFluids.fluidPair(FluidType.LIQUID, "radaway_slow"));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "nitrogen", 8176507));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "fluorine", 13879133));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "carbon_dioxide", 6054746));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "carbon_monoxide", 5002825));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "ethene", 16770211));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "fluoromethane", 4344837));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "ammonia", 8045472));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "oxygen_difluoride", 15342337));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "diborane", 13397644));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "sulfur_dioxide", 12827770));
            fluidPairList.add(NCFluids.fluidPair(FluidType.GAS, "sulfur_trioxide", 13872733));
            fluidPairList.add(NCFluids.fluidPair(FluidType.ACID, "hydrofluoric_acid", 19461));
            fluidPairList.add(NCFluids.fluidPair(FluidType.ACID, "boric_acid", 0x696939));
            fluidPairList.add(NCFluids.fluidPair(FluidType.ACID, "sulfuric_acid", 0x454500));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "boron_nitride_solution", NCFluids.waterBlend(7310940)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "fluorite_water", NCFluids.waterBlend(9090194)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "calcium_sulfate_solution", NCFluids.waterBlend(12103846)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "sodium_fluoride_solution", NCFluids.waterBlend(12759457)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "potassium_fluoride_solution", NCFluids.waterBlend(12700061)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "sodium_hydroxide_solution", NCFluids.waterBlend(12761019)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "potassium_hydroxide_solution", NCFluids.waterBlend(12109488)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SALT_SOLUTION, "borax_solution", NCFluids.waterBlend(0xEEEEEE)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CORIUM, "corium", 8356216));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CHOCOLATE, "chocolate_liquor", 4269084));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CHOCOLATE, "cocoa_butter", 16182975));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CHOCOLATE, "unsweetened_chocolate", 2886152));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CHOCOLATE, "dark_chocolate", 2886406));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CHOCOLATE, "milk_chocolate", 8929569));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SUGAR, "sugar", 16766362));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SUGAR, "gelatin", 14536860));
            fluidPairList.add(NCFluids.fluidPair(FluidType.SUGAR, "hydrated_gelatin", NCFluids.waterBlend(14536860, 0.8f)));
            fluidPairList.add(NCFluids.fluidPair(FluidType.CHOCOLATE, "marshmallow", 0xE1E1E3));
            fluidPairList.add(NCFluids.fluidPair(FluidType.LIQUID, "milk", true, 14605263, 1100, 300, 1000));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "lif", 0xCDCDCB));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "bef2", 12502698));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "flibe", 12699824));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "naoh", 12761019));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "koh", 12109488));
            if (NCFluids.registerCoFHAlt()) {
                fluidPairList.add(NCFluids.fluidPair(FluidType.STEAM, "steam", 0x929292, 800));
            }
            fluidPairList.add(NCFluids.fluidPair(FluidType.STEAM, "high_pressure_steam", 0xBDBDBD, 1200));
            fluidPairList.add(NCFluids.fluidPair(FluidType.STEAM, "exhaust_steam", 0x7E7E7E, 500));
            fluidPairList.add(NCFluids.fluidPair(FluidType.STEAM, "low_pressure_steam", 0xA8A8A8, 800));
            fluidPairList.add(NCFluids.fluidPair(FluidType.STEAM, "low_quality_steam", 0x828282, 350));
            fluidPairList.add(NCFluids.fluidPair(FluidType.LIQUID, "preheated_water", false, 3097588, 1000, 400, 250));
            fluidPairList.add(NCFluids.fluidPair(FluidType.LIQUID, "condensate_water", false, 3097588, 1000, 300, 850));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "sodium", 12683660));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "potassium", 12109059));
            fluidPairList.add(NCFluids.fluidPair(FluidType.COOLANT, "nak", 16770492));
            fluidPairList.add(NCFluids.fluidPair(FluidType.HOT_COOLANT, "nak_hot", 16766380));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "bas", 0x9B9B89));
            fluidPairList.add(NCFluids.fluidPair(FluidType.HOT_GAS, "sic_vapor", 7894122));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "alugentum", 11913675));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "alumina", 9541760));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "aluminum", 11922645));
            fluidPairList.add(NCFluids.fluidPair(FluidType.MOLTEN, "silver", 14867190));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register() {
        for (Pair<Fluid, NCBlockFluid> fluidPair : fluidPairList) {
            Fluid fluid = (Fluid)fluidPair.getLeft();
            boolean defaultFluid = FluidRegistry.registerFluid((Fluid)fluid);
            if (!defaultFluid) {
                fluid = FluidRegistry.getFluid((String)fluid.getName());
            }
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            NCFluids.registerBlock((NCBlockFluid)((Object)fluidPair.getRight()));
        }
    }

    public static void registerBlock(NCBlockFluid block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register(new ItemBlock((Block)block).setRegistryName(block.getRegistryName()));
        NuclearCraft.proxy.registerFluidBlockRendering((Block)block, block.getName());
    }

    public static <T extends Fluid, V extends NCBlockFluid> Pair<Fluid, NCBlockFluid> fluidPair(FluidType fluidType, Object ... fluidArgs) throws Exception {
        Fluid fluid = (Fluid)NCUtil.newInstance(fluidType.getFluidClass(), fluidArgs);
        NCBlockFluid block = (NCBlockFluid)((Object)NCUtil.newInstance(fluidType.getBlockClass(), fluid));
        return Pair.of((Object)fluid, (Object)((Object)block));
    }

    private static int waterBlend(int soluteColor, float blendRatio) {
        return ColorHelper.blend(3097588, soluteColor, blendRatio);
    }

    private static int waterBlend(int soluteColor) {
        return NCFluids.waterBlend(soluteColor, 0.5f);
    }

    private static boolean registerCoFHAlt() {
        return NCConfig.register_cofh_fluids || !ModCheck.thermalFoundationLoaded();
    }
}

