/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.gtce;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class GTCERecipeHelper {
    @Optional.Method(modid="gregtech")
    public static void addGTCERecipe(String recipeName, ProcessorRecipe recipe) {
        RecipeMap recipeMap = null;
        RecipeBuilder<?> builder = null;
        switch (recipeName) {
            case "manufactory": {
                recipeMap = RecipeMaps.MACERATOR_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 12, 8);
                break;
            }
            case "isotope_separator": {
                recipeMap = RecipeMaps.THERMAL_CENTRIFUGE_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 48, 160);
                break;
            }
            case "decay_hastener": {
                return;
            }
            case "fuel_reprocessor": {
                recipeMap = RecipeMaps.CENTRIFUGE_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 24, 60);
                break;
            }
            case "alloy_furnace": {
                recipeMap = RecipeMaps.ALLOY_SMELTER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 16, 10);
                break;
            }
            case "infuser": {
                recipeMap = RecipeMaps.CHEMICAL_BATH_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 10);
                break;
            }
            case "melter": {
                recipeMap = RecipeMaps.FLUID_EXTRACTION_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 32, 16);
                break;
            }
            case "supercooler": {
                recipeMap = RecipeMaps.VACUUM_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 240, 20);
                break;
            }
            case "electrolyser": {
                recipeMap = RecipeMaps.ELECTROLYZER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 16);
                break;
            }
            case "irradiator": {
                return;
            }
            case "ingot_former": {
                recipeMap = RecipeMaps.FLUID_SOLIDFICATION_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 8, 1);
                break;
            }
            case "pressurizer": {
                if (GTCERecipeHelper.isPlateRecipe(recipe)) {
                    recipeMap = RecipeMaps.BENDER_RECIPES;
                    builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 2, 20);
                    break;
                }
                recipeMap = RecipeMaps.COMPRESSOR_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 2, 20);
                break;
            }
            case "chemical_reactor": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 30);
                break;
            }
            case "salt_mixer": {
                recipeMap = RecipeMaps.MIXER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 8, 12);
                break;
            }
            case "crystallizer": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 10);
                break;
            }
            case "dissolver": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 20, 20);
                break;
            }
            case "extractor": {
                recipeMap = RecipeMaps.FLUID_EXTRACTION_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 16, 12);
                break;
            }
            case "centrifuge": {
                recipeMap = RecipeMaps.CENTRIFUGE_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 16, 80);
                break;
            }
            case "rock_crusher": {
                recipeMap = RecipeMaps.MACERATOR_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 20, 12);
                return;
            }
        }
        if (recipeMap == null || builder == null) {
            return;
        }
        ArrayList<List<ItemStack>> itemInputLists = new ArrayList<List<ItemStack>>();
        ArrayList<List<FluidStack>> fluidInputLists = new ArrayList<List<FluidStack>>();
        for (IItemIngredient item : recipe.itemIngredients()) {
            itemInputLists.add(item.getInputStackList());
        }
        for (IFluidIngredient fluid : recipe.fluidIngredients()) {
            fluidInputLists.add(fluid.getInputStackList());
        }
        ArrayList<Pair<List<ItemStack>, List<FluidStack>>> ingredientListTuples = new ArrayList<Pair<List<ItemStack>, List<FluidStack>>>();
        int[] inputNumbers = new int[recipe.itemIngredients().size() + recipe.fluidIngredients().size()];
        Arrays.fill(inputNumbers, 0);
        GTCERecipeHelper.generateIngredientListTuples(ingredientListTuples, inputNumbers, 0, itemInputLists, fluidInputLists);
        for (Pair pair : ingredientListTuples) {
            if (GTCERecipeHelper.findRecipe(recipeMap, (List)pair.getLeft(), (List)pair.getRight()) == null) continue;
            return;
        }
        ArrayList builders = new ArrayList();
        builders.add(builder);
        for (IItemIngredient iItemIngredient : recipe.itemIngredients()) {
            if (iItemIngredient instanceof OreIngredient) {
                for (RecipeBuilder recipeBuilder : builders) {
                    recipeBuilder.input(((OreIngredient)iItemIngredient).oreName, ((OreIngredient)iItemIngredient).stackSize);
                }
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<RecipeBuilder> arrayList2 = new ArrayList<RecipeBuilder>();
            for (ItemStack inputVariant : iItemIngredient.getInputStackList()) {
                if (inputVariant.func_190926_b()) continue;
                Set<String> variantOreList = OreDictHelper.getOreNames(inputVariant);
                if (!variantOreList.isEmpty()) {
                    if (arrayList.containsAll(variantOreList)) continue;
                    arrayList.addAll(variantOreList);
                    for (RecipeBuilder recipeBuilder : builders) {
                        arrayList2.add(recipeBuilder.copy().input(variantOreList.iterator().next(), inputVariant.func_190916_E()));
                    }
                    continue;
                }
                for (RecipeBuilder recipeBuilder : builders) {
                    arrayList2.add(recipeBuilder.copy().inputs(new ItemStack[]{inputVariant}));
                }
            }
            builders = arrayList2;
        }
        if (recipeMap == RecipeMaps.FLUID_SOLIDFICATION_RECIPES) {
            MetaItem.MetaValueItem metaValueItem = GTCERecipeHelper.getIngotFormerMold(recipe);
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.notConsumable(metaValueItem);
            }
        } else if (recipeMap == RecipeMaps.BENDER_RECIPES) {
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.notConsumable(MetaItems.INTEGRATED_CIRCUIT);
            }
        }
        for (IFluidIngredient iFluidIngredient : recipe.fluidIngredients()) {
            if (iFluidIngredient.getInputStackList().isEmpty()) continue;
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.fluidInputs(new FluidStack[]{(FluidStack)iFluidIngredient.getInputStackList().get(0)});
            }
        }
        for (IItemIngredient iItemIngredient : recipe.itemProducts()) {
            List list = iItemIngredient.getOutputStackList();
            if (list.isEmpty()) continue;
            for (RecipeBuilder recipeBuilder : builders) {
                RecipeBuilder recipeBuilder2 = recipeBuilder.outputs(new ItemStack[]{(ItemStack)list.get(0)});
            }
        }
        for (IFluidIngredient iFluidIngredient : recipe.fluidProducts()) {
            if (iFluidIngredient.getOutputStackList().isEmpty()) continue;
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.fluidOutputs(new FluidStack[]{(FluidStack)iFluidIngredient.getOutputStackList().get(0)});
            }
        }
        for (RecipeBuilder recipeBuilder : builders) {
            if (recipeBuilder.getInputs().isEmpty()) continue;
            recipeBuilder.buildAndRegister();
        }
    }

    @Optional.Method(modid="gregtech")
    private static RecipeBuilder<?> addStats(RecipeBuilder<?> builder, ProcessorRecipe recipe, int processPower, int processTime) {
        return builder.EUt(Math.max((int)recipe.getBaseProcessPower(processPower), 8)).duration((int)recipe.getBaseProcessTime(20.0 * (double)processTime));
    }

    @Optional.Method(modid="gregtech")
    private static void generateIngredientListTuples(List<Pair<List<ItemStack>, List<FluidStack>>> tuples, int[] inputNumbers, int activeIndex, List<List<ItemStack>> itemInputLists, List<List<FluidStack>> fluidInputLists) {
        int i;
        int itemInputSize = itemInputLists.size();
        int fluidInputSize = fluidInputLists.size();
        ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
        for (i = 0; i < itemInputSize; ++i) {
            if (itemInputLists.get(i).size() > inputNumbers[i]) {
                itemInputs.add(itemInputLists.get(i).get(inputNumbers[i]));
                continue;
            }
            if (activeIndex == i) {
                ++activeIndex;
            }
            inputNumbers[i] = -1;
        }
        for (i = 0; i < fluidInputSize; ++i) {
            if (fluidInputLists.get(i).size() > inputNumbers[i + itemInputSize]) {
                fluidInputs.add(fluidInputLists.get(i).get(inputNumbers[i + itemInputSize]));
                continue;
            }
            if (activeIndex == i + itemInputSize) {
                ++activeIndex;
            }
            inputNumbers[i + itemInputSize] = -1;
        }
        if (itemInputs.size() == itemInputSize && fluidInputs.size() == fluidInputSize) {
            tuples.add((Pair<List<ItemStack>, List<FluidStack>>)Pair.of(itemInputs, fluidInputs));
        }
        if (activeIndex < itemInputSize + fluidInputSize) {
            i = 0;
            while (i <= activeIndex) {
                int n = i++;
                inputNumbers[n] = inputNumbers[n] + 1;
            }
            GTCERecipeHelper.generateIngredientListTuples(tuples, inputNumbers, activeIndex, itemInputLists, fluidInputLists);
        }
    }

    @Optional.Method(modid="gregtech")
    private static Recipe findRecipe(RecipeMap<?> recipeMap, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        if (recipeMap.getRecipeList().isEmpty()) {
            return null;
        }
        if (recipeMap.getMinFluidInputs() > 0 && GTUtility.amountOfNonNullElements(fluidInputs) < recipeMap.getMinFluidInputs()) {
            return null;
        }
        if (recipeMap.getMinInputs() > 0 && GTUtility.amountOfNonEmptyStacks(inputs) < recipeMap.getMinInputs()) {
            return null;
        }
        if (recipeMap.getMaxInputs() > 0) {
            return GTCERecipeHelper.findByInputs(recipeMap, inputs, fluidInputs);
        }
        return GTCERecipeHelper.findByFluidInputs(recipeMap, inputs, fluidInputs);
    }

    @Optional.Method(modid="gregtech")
    private static Recipe findByFluidInputs(RecipeMap<?> recipeMap, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        for (FluidStack fluid : fluidInputs) {
            Collection recipes;
            if (fluid == null || (recipes = recipeMap.getRecipesForFluid(fluid)) == null) continue;
            for (Recipe recipe : recipes) {
                if (!GTCERecipeHelper.recipeMatches(recipe, inputs, fluidInputs)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Optional.Method(modid="gregtech")
    private static Recipe findByInputs(RecipeMap<?> recipeMap, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        for (Recipe recipe : recipeMap.getRecipeList()) {
            if (!GTCERecipeHelper.recipeMatches(recipe, inputs, fluidInputs)) continue;
            return recipe;
        }
        return null;
    }

    @Optional.Method(modid="gregtech")
    private static boolean recipeMatches(Recipe recipe, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        block0: for (CountableIngredient ingredient : recipe.getInputs()) {
            for (ItemStack itemStack : inputs) {
                if (itemStack.func_190926_b() || !ingredient.getIngredient().apply(itemStack)) continue;
                continue block0;
            }
            return false;
        }
        block2: for (FluidStack fluid : recipe.getFluidInputs()) {
            for (FluidStack fluidStack : fluidInputs) {
                if (fluidStack == null || !fluidStack.isFluidEqual(fluid)) continue;
                continue block2;
            }
            return false;
        }
        return true;
    }

    private static boolean isPlateRecipe(ProcessorRecipe recipe) {
        ItemStack output = (ItemStack)recipe.itemProducts().get(0).getStack();
        return output != null && OreDictHelper.hasOrePrefix(output, "plate", "plateDense");
    }

    private static MetaItem.MetaValueItem getIngotFormerMold(ProcessorRecipe recipe) {
        ItemStack output = (ItemStack)recipe.itemProducts().get(0).getStack();
        if (output != null) {
            if (OreDictHelper.hasOrePrefix(output, "ingot")) {
                return MetaItems.SHAPE_MOLD_INGOT;
            }
            if (OreDictHelper.hasOrePrefix(output, "block")) {
                return MetaItems.SHAPE_MOLD_BLOCK;
            }
        }
        return MetaItems.SHAPE_MOLD_BALL;
    }
}

