/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.network.PacketHandler;
import nc.network.radiation.PlayerRadsUpdatePacket;
import nc.radiation.RadBiomes;
import nc.radiation.RadEffects;
import nc.radiation.RadStructures;
import nc.radiation.RadWorlds;
import nc.radiation.RadiationHelper;
import nc.radiation.RadiationRenders;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.DamageSources;
import nc.util.Lang;
import nc.util.StructureHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class RadiationHandler {
    private Random rand = new Random();
    private static final String RAD_X_WORE_OFF = Lang.localise("message.nuclearcraft.rad_x_wore_off");
    private static final String RAD_WARNING = Lang.localise("message.nuclearcraft.rad_warning");
    private static final int WORLD_TICK_RATE = NCConfig.radiation_world_tick_rate;
    private static final int PLAYER_TICK_RATE = NCConfig.radiation_player_tick_rate;
    private static EnumFacing tile_side = EnumFacing.DOWN;
    private static final List<byte[]> ADJACENT_COORDS = Lists.newArrayList((Object[])new byte[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}});

    @SubscribeEvent
    public void updatePlayerRadiation(TickEvent.PlayerTickEvent event) {
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (!NCConfig.radiation_require_counter && event.phase == TickEvent.Phase.START && event.side == Side.CLIENT) {
            this.playGeigerSound(event.player);
        }
        if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.func_82737_E() % (long)PLAYER_TICK_RATE != 0L) {
            return;
        }
        if (event.side == Side.SERVER && event.player instanceof EntityPlayerMP) {
            double change;
            double radXDecayRate;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            IEntityRads playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
            if (playerRads == null) {
                return;
            }
            IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)player.field_70170_p.func_72964_e((int)Math.floor(player.field_70165_t) >> 4, (int)Math.floor(player.field_70161_v) >> 4));
            double previousImmunityTime = playerRads.getRadiationImmunityTime();
            if (previousImmunityTime > 0.0) {
                playerRads.setRadiationImmunityTime(previousImmunityTime - (double)PLAYER_TICK_RATE);
            }
            double previousRadPercentage = playerRads.getRadsPercentage();
            playerRads.setExternalRadiationResistance(RadiationHelper.getArmorInventoryRadResistance((Entity)player));
            if (NCConfig.radiation_player_decay_rate > 0.0) {
                playerRads.setTotalRads(playerRads.getTotalRads() * Math.pow(1.0 - NCConfig.radiation_player_decay_rate, PLAYER_TICK_RATE), false);
            }
            double radiationLevel = RadiationHelper.transferRadsToPlayer(chunkSource, playerRads, (EntityPlayer)player, PLAYER_TICK_RATE) + RadiationHelper.transferRadsFromInventoryToPlayer(playerRads, (EntityPlayer)player, PLAYER_TICK_RATE);
            if (playerRads.getPoisonBuffer() > 0.0) {
                double poisonRads = Math.min(playerRads.getPoisonBuffer() / (double)PLAYER_TICK_RATE, playerRads.getRecentPoisonAddition() / NCConfig.radiation_poison_time);
                radiationLevel += RadiationHelper.addRadsToEntity(playerRads, poisonRads, true, PLAYER_TICK_RATE);
                playerRads.setPoisonBuffer(playerRads.getPoisonBuffer() - poisonRads * (double)PLAYER_TICK_RATE);
                if (playerRads.getPoisonBuffer() == 0.0) {
                    playerRads.resetRecentPoisonAddition();
                }
            } else {
                playerRads.resetRecentPoisonAddition();
            }
            playerRads.setRadiationLevel(radiationLevel);
            if (!player.func_184812_l_()) {
                if (playerRads.isFatal()) {
                    player.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
                } else if (!RadEffects.PLAYER_RAD_LEVEL_LIST.isEmpty() && previousRadPercentage < RadEffects.PLAYER_RAD_LEVEL_LIST.get(0) && playerRads.getRadsPercentage() >= RadEffects.PLAYER_RAD_LEVEL_LIST.get(0) && !RadiationRenders.shouldShowHUD((EntityPlayer)player)) {
                    playerRads.setShouldWarn(true);
                } else {
                    playerRads.setShouldWarn(false);
                }
            }
            double previousInternalResistance = playerRads.getInternalRadiationResistance();
            double recentRadXAdditionModified = NCConfig.radiation_rad_x_amount * (1.0 + playerRads.getRecentRadXAddition()) / (1.0 + NCConfig.radiation_rad_x_amount);
            if (previousInternalResistance > 0.0) {
                radXDecayRate = Math.max(previousInternalResistance, recentRadXAdditionModified) / NCConfig.radiation_rad_x_lifetime;
                playerRads.setInternalRadiationResistance(Math.max(0.0, previousInternalResistance - radXDecayRate * (double)PLAYER_TICK_RATE));
                if (playerRads.getInternalRadiationResistance() == 0.0) {
                    playerRads.resetRecentRadXAddition();
                    playerRads.setRadXWoreOff(true);
                }
            } else {
                if (previousInternalResistance < 0.0) {
                    radXDecayRate = Math.max(-previousInternalResistance, recentRadXAdditionModified) / NCConfig.radiation_rad_x_lifetime;
                    playerRads.setInternalRadiationResistance(Math.min(0.0, previousInternalResistance + radXDecayRate * (double)PLAYER_TICK_RATE));
                    if (playerRads.getInternalRadiationResistance() == 0.0) {
                        playerRads.resetRecentRadXAddition();
                    }
                } else {
                    playerRads.resetRecentRadXAddition();
                }
                playerRads.setRadXWoreOff(false);
            }
            if (playerRads.getRadXWoreOff() && playerRads.getRadXUsed()) {
                playerRads.setRadXUsed(false);
            }
            if (playerRads.getRadawayBuffer(false) > 0.0) {
                change = Math.min(playerRads.getRadawayBuffer(false), playerRads.getRecentRadawayAddition() * NCConfig.radiation_radaway_rate * (double)PLAYER_TICK_RATE / NCConfig.radiation_radaway_amount);
                playerRads.setTotalRads(playerRads.getTotalRads() - change, false);
                playerRads.setRadawayBuffer(false, playerRads.getRadawayBuffer(false) - change);
                if (playerRads.getRadawayBuffer(false) == 0.0) {
                    playerRads.resetRecentRadawayAddition();
                }
            } else {
                playerRads.resetRecentRadawayAddition();
            }
            if (playerRads.getRadawayBuffer(true) > 0.0) {
                change = Math.min(playerRads.getRadawayBuffer(true), NCConfig.radiation_radaway_slow_rate * (double)PLAYER_TICK_RATE);
                playerRads.setTotalRads(playerRads.getTotalRads() - change, false);
                playerRads.setRadawayBuffer(true, playerRads.getRadawayBuffer(true) - change);
            }
            if (playerRads.getRadawayCooldown() > 0.0) {
                playerRads.setRadawayCooldown(playerRads.getRadawayCooldown() - (double)PLAYER_TICK_RATE);
            }
            if (playerRads.getRadXCooldown() > 0.0) {
                playerRads.setRadXCooldown(playerRads.getRadXCooldown() - (double)PLAYER_TICK_RATE);
            }
            PacketHandler.instance.sendTo((IMessage)new PlayerRadsUpdatePacket(playerRads), player);
            if (!player.func_184812_l_() && !playerRads.isImmune()) {
                RadiationHelper.applyPotionEffects((EntityLivingBase)player, playerRads, RadEffects.PLAYER_RAD_LEVEL_LIST, RadEffects.PLAYER_DEBUFF_LIST);
            }
        } else {
            EntityPlayer player = event.player;
            IEntityRads playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
            if (playerRads == null) {
                return;
            }
            if (playerRads.getRadXWoreOff() && playerRads.getRadXUsed()) {
                player.func_184185_a(SoundHandler.chems_wear_off, 0.65f, 1.0f);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + RAD_X_WORE_OFF));
            }
            if (playerRads.getShouldWarn()) {
                player.func_184185_a(SoundHandler.chems_wear_off, 0.8f, 0.7f);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + RAD_WARNING));
            }
        }
    }

    @SubscribeEvent
    public void updateWorldRadiation(TickEvent.WorldTickEvent event) {
        Chunk chunk;
        IRadiationSource chunkSource;
        TileEntity[] tileArray;
        Entity[] entityArray;
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.START || event.side == Side.CLIENT || event.world.func_82737_E() % (long)WORLD_TICK_RATE != 0L || !(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        ChunkProviderServer chunkProvider = world.func_72863_F();
        Chunk[] chunkArray = chunkProvider.func_189548_a().toArray(new Chunk[chunkProvider.func_189548_a().size()]);
        for (Entity entity : entityArray = world.field_72996_f.toArray(new Entity[world.field_72996_f.size()])) {
            EntityLiving entityLiving;
            IEntityRads entityRads;
            IRadiationSource chunkSource2 = RadiationHelper.getRadiationSource((ICapabilityProvider)world.func_72964_e((int)Math.floor(entity.field_70165_t) >> 4, (int)Math.floor(entity.field_70161_v) >> 4));
            if (entity instanceof EntityPlayer) {
                RadiationHelper.transferRadsFromInventoryToChunkBuffer(((EntityPlayer)entity).field_71071_by, chunkSource2);
                continue;
            }
            if (NCConfig.radiation_dropped_items && entity instanceof EntityItem) {
                RadiationHelper.transferRadiationFromStackToChunkBuffer(((EntityItem)entity).func_92059_d(), chunkSource2, 1.0);
                continue;
            }
            if (!(entity instanceof EntityLiving) || (entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)(entityLiving = (EntityLiving)entity))) == null) continue;
            entityRads.setExternalRadiationResistance(RadiationHelper.getEntityArmorRadResistance(entityLiving));
            RadiationHelper.transferRadsFromSourceToEntity(chunkSource2, entityRads, entityLiving, WORLD_TICK_RATE);
            if (entityRads.getPoisonBuffer() > 0.0) {
                double poisonRads = Math.min(entityRads.getPoisonBuffer(), entityRads.getRecentPoisonAddition() * (double)WORLD_TICK_RATE / NCConfig.radiation_poison_time);
                entityRads.setTotalRads(entityRads.getTotalRads() + poisonRads, false);
                entityRads.setPoisonBuffer(entityRads.getPoisonBuffer() - poisonRads);
                if (entityRads.getPoisonBuffer() == 0.0) {
                    entityRads.resetRecentPoisonAddition();
                }
            } else {
                entityRads.resetRecentPoisonAddition();
            }
            if (NCConfig.radiation_entity_decay_rate > 0.0) {
                entityRads.setTotalRads(entityRads.getTotalRads() * Math.pow(1.0 - NCConfig.radiation_entity_decay_rate, WORLD_TICK_RATE), false);
            }
            if (entityLiving instanceof IMob) {
                RadiationHelper.applyPotionEffects((EntityLivingBase)entityLiving, entityRads, RadEffects.MOB_RAD_LEVEL_LIST, RadEffects.MOB_EFFECTS_LIST);
            } else if (entityRads.isFatal()) {
                entityLiving.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
            } else {
                RadiationHelper.applyPotionEffects((EntityLivingBase)entityLiving, entityRads, RadEffects.ENTITY_RAD_LEVEL_LIST, RadEffects.ENTITY_DEBUFF_LIST);
            }
            entityRads.setRadiationLevel(entityRads.getRadiationLevel() * Math.pow(1.0 - NCConfig.radiation_decay_rate, WORLD_TICK_RATE));
        }
        for (TileEntity tile : tileArray = world.field_147482_g.toArray(new TileEntity[world.field_147482_g.size()])) {
            Chunk chunk2 = world.func_175726_f(tile.func_174877_v());
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)tile, tile_side, RadiationHelper.getRadiationSource((ICapabilityProvider)chunk2));
        }
        BiomeProvider biomeProvider = world.func_72959_q();
        int dimension = world.field_73011_w.getDimension();
        BlockPos randomOffsetPos = new BlockPos(this.rand.nextInt(16), this.rand.nextInt(256), this.rand.nextInt(16));
        String randomStructure = RadStructures.STRUCTURE_LIST.isEmpty() ? null : RadStructures.STRUCTURE_LIST.get(this.rand.nextInt(RadStructures.STRUCTURE_LIST.size()));
        for (Chunk chunk2 : chunkArray) {
            Double structureRadiation;
            Double biomeRadiation;
            if (!chunk2.func_177410_o() || (chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk2)) == null) continue;
            chunkSource.resetScrubbingFraction();
            if (RadWorlds.RAD_MAP.containsKey(dimension)) {
                RadiationHelper.addToSourceBuffer(chunkSource, RadWorlds.RAD_MAP.get(dimension));
            }
            if (!RadBiomes.DIM_BLACKLIST.contains(dimension) && (biomeRadiation = RadBiomes.RAD_MAP.get(chunk2.func_177411_a(randomOffsetPos, biomeProvider))) != null) {
                RadiationHelper.addToSourceBuffer(chunkSource, biomeRadiation);
            }
            BlockPos randomChunkPos = chunk2.func_76632_l().func_180331_a(randomOffsetPos.func_177958_n(), randomOffsetPos.func_177956_o(), randomOffsetPos.func_177952_p());
            if (randomStructure == null || !StructureHelper.CACHE.isInStructure((World)world, randomStructure, randomChunkPos) || (structureRadiation = RadStructures.RAD_MAP.get(randomStructure)) == null) continue;
            RadiationHelper.addToSourceBuffer(chunkSource, structureRadiation);
        }
        for (Chunk chunk3 : tileArray) {
            IRadiationSource chunkSource3;
            if (!(chunk3 instanceof ITileRadiationEnvironment) || (chunkSource3 = RadiationHelper.getRadiationSource((ICapabilityProvider)(chunk = world.func_175726_f(chunk3.func_174877_v())))) == null) continue;
            ((ITileRadiationEnvironment)chunk3).setCurrentChunkBuffer(chunkSource3.getRadiationBuffer());
        }
        for (Chunk chunk4 : tileArray) {
            if (!(chunk4 instanceof ITileRadiationEnvironment)) continue;
            chunk = world.func_175726_f(chunk4.func_174877_v());
            RadiationHelper.addFractionToChunkBuffer(RadiationHelper.getRadiationSource((ICapabilityProvider)chunk), (ITileRadiationEnvironment)chunk4);
        }
        for (Chunk chunk5 : chunkArray) {
            if (!chunk5.func_177410_o() || (chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk5)) == null) continue;
            double changeRate = chunkSource.getRadiationLevel() < chunkSource.getRadiationBuffer() ? NCConfig.radiation_spread_rate : NCConfig.radiation_decay_rate * (1.0 - chunkSource.getScrubbingFraction()) + NCConfig.radiation_spread_rate * chunkSource.getScrubbingFraction();
            double newLevel = Math.max(0.0, chunkSource.getRadiationLevel() + (chunkSource.getRadiationBuffer() - chunkSource.getRadiationLevel()) * changeRate);
            if (NCConfig.radiation_chunk_limit >= 0.0) {
                newLevel = Math.min(newLevel, NCConfig.radiation_chunk_limit);
            }
            Biome biome = chunk5.func_177411_a(randomOffsetPos, biomeProvider);
            if (!RadBiomes.LIMIT_MAP.isEmpty() && RadBiomes.LIMIT_MAP.containsKey(biome)) {
                newLevel = Math.min(newLevel, RadBiomes.LIMIT_MAP.get(biome));
            }
            if (!RadWorlds.LIMIT_MAP.isEmpty() && RadWorlds.LIMIT_MAP.containsKey(dimension)) {
                newLevel = Math.min(newLevel, RadWorlds.LIMIT_MAP.get(dimension));
            }
            chunkSource.setRadiationLevel(newLevel);
        }
        for (Chunk chunk6 : chunkArray) {
            RadiationHelper.spreadRadiationFromChunk(chunk6, RadiationHandler.getRandomAdjacentChunk(chunkProvider, chunk6));
        }
        tile_side = EnumFacing.func_82600_a((int)(tile_side.func_176745_a() + 1));
    }

    private static Chunk getRandomAdjacentChunk(ChunkProviderServer chunkProvider, Chunk chunk) {
        if (chunkProvider == null || chunk == null || !chunk.func_177410_o()) {
            return null;
        }
        int x = chunk.func_76632_l().field_77276_a;
        int z = chunk.func_76632_l().field_77275_b;
        Collections.shuffle(ADJACENT_COORDS);
        for (byte[] pos : ADJACENT_COORDS) {
            Chunk adjChunk;
            if (!chunkProvider.func_73149_a(x + pos[0], z + pos[1]) || (adjChunk = chunkProvider.func_186026_b(x + pos[0], z + pos[1])) == null) continue;
            return adjChunk;
        }
        return null;
    }

    private void playGeigerSound(EntityPlayer player) {
        IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
        if (entityRads == null) {
            return;
        }
        if (!entityRads.isRadiationUndetectable()) {
            double soundChance = Math.cbrt(entityRads.getRawRadiationLevel() / 200.0);
            for (int i = 0; i < 2; ++i) {
                if (!(this.rand.nextDouble() < soundChance)) continue;
                player.func_184185_a(SoundHandler.geiger_tick, 0.6f + this.rand.nextFloat() * 0.2f, 0.92f + this.rand.nextFloat() * 0.16f);
            }
        }
    }
}

