/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DirectionalPieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DungeonStartIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.PieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.SizedPieceIo;
import galaxyspace.systems.SolarSystem.planets.ceres.blocks.CeresBlocks;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class RoomBossIo
extends SizedPieceIo {
    private EnumFacing exitDirection;
    private BlockPos chestPos;

    public RoomBossIo() {
    }

    public RoomBossIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(6) + 14, rand.nextInt(2) + 8, rand.nextInt(6) + 14, entranceDir);
    }

    public RoomBossIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.sizeY = sizeY;
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        if (this.exitDirection != null) {
            tagCompound.func_74768_a("direction_exit", this.exitDirection.ordinal());
        }
        tagCompound.func_74757_a("chestPosNull", this.chestPos == null);
        if (this.chestPos != null) {
            tagCompound.func_74768_a("chestX", this.chestPos.func_177958_n());
            tagCompound.func_74768_a("chestY", this.chestPos.func_177956_o());
            tagCompound.func_74768_a("chestZ", this.chestPos.func_177952_p());
        }
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        this.exitDirection = tagCompound.func_74764_b("direction_exit") ? EnumFacing.func_82600_a((int)tagCompound.func_74762_e("direction_exit")) : null;
        if (tagCompound.func_74764_b("chestPosNull") && !tagCompound.func_74767_n("chestPosNull")) {
            this.chestPos = new BlockPos(tagCompound.func_74762_e("chestX"), tagCompound.func_74762_e("chestY"), tagCompound.func_74762_e("chestZ"));
        }
    }

    public boolean func_74875_a(World worldIn, Random random, StructureBoundingBox chunkBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            if (j == 0) {
                                if (i == this.sizeX / 2 && k > 1 && k < this.sizeZ - 1) {
                                    this.func_175811_a(worldIn, GSBlocks.FUTURE_GLASS_BASIC.func_176223_P(), i, j, k, chunkBox);
                                    this.func_175811_a(worldIn, Blocks.field_150403_cj.func_176223_P(), i, j - 1, k, chunkBox);
                                    continue;
                                }
                                if (k == this.sizeZ / 2 && i > 1 && i < this.sizeX - 1) {
                                    this.func_175811_a(worldIn, GSBlocks.FUTURE_GLASS_BASIC.func_176223_P(), i, j, k, chunkBox);
                                    this.func_175811_a(worldIn, Blocks.field_150403_cj.func_176223_P(), i, j - 1, k, chunkBox);
                                    continue;
                                }
                                if (!(i != 3 && i != this.sizeX - 3 || k != 3 && k != this.sizeZ - 3)) {
                                    this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), i, j, k, chunkBox);
                                    continue;
                                }
                                this.func_175811_a(worldIn, GSBlocks.CERES_BLOCKS.func_176223_P().func_177226_a(CeresBlocks.BASIC_TYPE, (Comparable)((Object)CeresBlocks.EnumCeresBlocks.CERES_DUNGEON_FLOOR)), i, j, k, this.field_74887_e);
                                continue;
                            }
                            this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, chunkBox);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, chunkBox);
                        continue;
                    }
                    if (j == this.sizeY) {
                        if ((i <= 2 || k <= 2 || i >= this.sizeX - 2 || k >= this.sizeZ - 2) && random.nextInt(4) == 0) {
                            this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), i, j, k, chunkBox);
                            continue;
                        }
                        this.func_175811_a(worldIn, GSBlocks.CERES_BLOCKS.func_176223_P().func_177226_a(CeresBlocks.BASIC_TYPE, (Comparable)((Object)CeresBlocks.EnumCeresBlocks.CERES_DUNGEON_TOP)), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if ((i == 2 || i == 4 || i == this.sizeX - 2 || i == this.sizeX - 4) && (k == 2 || k == 4 && i != 4 && i != this.sizeX - 4 || k == this.sizeZ - 2 || k == this.sizeZ - 4 && i != 4 && i != this.sizeX - 4)) {
                        this.func_175811_a(worldIn, Blocks.field_150403_cj.func_176223_P(), i, j, k, chunkBox);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, chunkBox);
                }
            }
        }
        int spawnerX = this.sizeX / 2;
        int spawnerY = 1;
        int spawnerZ = this.sizeZ / 2;
        BlockPos blockpos = new BlockPos(this.func_74865_a(spawnerX, spawnerZ), this.func_74862_a(spawnerY), this.func_74873_b(spawnerX, spawnerZ));
        if (chunkBox.func_175898_b((Vec3i)blockpos)) {
            worldIn.func_180501_a(blockpos, GSBlocks.BOSS_SPAWNER_CERES.func_176223_P(), 2);
            TileEntityDungeonSpawner spawner = (TileEntityDungeonSpawner)worldIn.func_175625_s(blockpos);
            if (spawner != null) {
                spawner.setRoom(new Vector3((double)(this.field_74887_e.field_78897_a + 1), (double)(this.field_74887_e.field_78895_b + 1), (double)(this.field_74887_e.field_78896_c + 1)), new Vector3((double)(this.sizeX - 1), (double)(this.sizeY - 1), (double)(this.sizeZ - 1)));
            }
        }
        return true;
    }

    public BlockPos getChestPos() {
        return this.chestPos;
    }

    public void setChestPos(BlockPos chestPos) {
        this.chestPos = chestPos;
    }

    @Override
    public PieceIo getNextPiece(DungeonStartIo startPiece, Random rand) {
        DirectionalPieceIo corridor = (DirectionalPieceIo)this.getCorridor(rand, startPiece, 10, true);
        this.exitDirection = corridor == null ? null : corridor.getDirection().func_176734_d();
        return corridor;
    }
}

