/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension;

import asmodeuscore.core.astronomy.dimension.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.KuiperBeltSaveData;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.sky.SkyProviderKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.world.gen.BiomeProviderKuiperBelt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderKuiperBelt
extends WorldProviderAdvancedSpace
implements ISolarLevel,
IZeroGDimension {
    private HashSet<AsteroidData> asteroids = new HashSet();
    private boolean dataNotLoaded = true;
    private KuiperBeltSaveData datafile;
    private double solarMultiplier = -1.0;

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.planetKuiperBelt;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 0L;
    }

    public boolean isDaytime() {
        return true;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderKuiperBelt.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderKuiperBelt.class;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.22f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 96;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    public float getFallDamageModifier() {
        return 0.1f;
    }

    public IRenderHandler getCloudRenderer() {
        return new CloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderKuiperBelt());
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.25f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        float f3 = this.field_76579_a.func_72820_D();
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.2f - f2;
        return f2 * 1.0f;
    }

    public void addAsteroid(int x, int y, int z, int size, int core) {
        AsteroidData coords = new AsteroidData(x, y, z, size, core);
        if (!this.asteroids.contains(coords)) {
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            if (!this.asteroids.contains(coords)) {
                this.addToNBT(this.datafile.datacompound, coords);
                this.asteroids.add(coords);
            }
        }
    }

    public void removeAsteroid(int x, int y, int z) {
        AsteroidData coords = new AsteroidData(x, y, z);
        if (this.asteroids.contains(coords)) {
            this.asteroids.remove(coords);
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            this.writeToNBT(this.datafile.datacompound);
        }
    }

    private void loadAsteroidSavedData() {
        this.datafile = (KuiperBeltSaveData)this.field_76579_a.func_72943_a(KuiperBeltSaveData.class, "../galacticraft/GSKuiperBeltData");
        if (this.datafile == null) {
            this.datafile = new KuiperBeltSaveData("");
            this.field_76579_a.func_72823_a("../galacticraft/GSKuiperBeltData", (WorldSavedData)this.datafile);
            this.writeToNBT(this.datafile.datacompound);
        } else {
            this.readFromNBT(this.datafile.datacompound);
        }
        this.dataNotLoaded = false;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        if (coordList.func_74745_c() > 0) {
            for (int j = 0; j < coordList.func_74745_c(); ++j) {
                NBTTagCompound tag1 = coordList.func_150305_b(j);
                if (tag1 == null) continue;
                this.asteroids.add(AsteroidData.readFromNBT(tag1));
            }
        }
    }

    private void writeToNBT(NBTTagCompound nbt) {
        NBTTagList coordList = new NBTTagList();
        for (AsteroidData coords : this.asteroids) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            coordList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    private void addToNBT(NBTTagCompound nbt, AsteroidData coords) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        coordList.func_74742_a((NBTBase)tag);
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    public boolean checkHasAsteroids() {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        return this.asteroids.size() != 0;
    }

    public BlockVec3 getClosestAsteroidXZ(int x, int y, int z, boolean mark) {
        if (!this.checkHasAsteroids()) {
            return null;
        }
        BlockVec3 result = null;
        AsteroidData resultRoid = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (AsteroidData test : this.asteroids) {
            int dz;
            int dx;
            int a;
            if (mark && (test.sizeAndLandedFlag & 0x80) > 0 || (a = (dx = x - test.centre.x) * dx + (dz = z - test.centre.z) * dz) >= lowestDistance) continue;
            lowestDistance = a;
            result = test.centre;
            resultRoid = test;
        }
        if (result == null) {
            return null;
        }
        if (mark) {
            resultRoid.sizeAndLandedFlag |= 0x80;
            this.writeToNBT(this.datafile.datacompound);
        }
        result = result.clone();
        result.sideDoneBits = resultRoid.sizeAndLandedFlag & 0x7F;
        return result;
    }

    public ArrayList<BlockVec3> getClosestAsteroidsXZ(int x, int y, int z, int facing, int count) {
        if (!this.checkHasAsteroids()) {
            return null;
        }
        TreeMap<Integer, BlockVec3> targets = new TreeMap<Integer, BlockVec3>();
        block12: for (AsteroidData roid : this.asteroids) {
            int dz;
            int dx;
            int a;
            BlockVec3 test = roid.centre;
            switch (facing) {
                case 2: {
                    if (z - 16 >= test.z) break;
                    continue block12;
                }
                case 3: {
                    if (z + 16 <= test.z) break;
                    continue block12;
                }
                case 4: {
                    if (x - 16 >= test.x) break;
                    continue block12;
                }
                case 5: {
                    if (x + 16 <= test.x) break;
                    continue block12;
                }
            }
            if ((a = (dx = x - test.x) * dx + (dz = z - test.z) * dz) >= 262144) continue;
            targets.put(a, test);
        }
        int max = Math.max(count, targets.size());
        if (max <= 0) {
            return null;
        }
        ArrayList<BlockVec3> returnValues = new ArrayList<BlockVec3>();
        int i = 0;
        int offset = 6;
        for (BlockVec3 target : targets.values()) {
            BlockVec3 coords = target.clone();
            GCLog.debug((String)("Found nearby asteroid at " + target.toString()));
            switch (facing) {
                case 2: {
                    coords.z += offset;
                    break;
                }
                case 3: {
                    coords.z -= offset;
                    break;
                }
                case 4: {
                    coords.x += offset;
                    break;
                }
                case 5: {
                    coords.x -= offset;
                }
            }
            returnValues.add(coords);
            if (++i < count) continue;
            break;
        }
        return returnValues;
    }

    public int getActualHeight() {
        return 256;
    }

    protected void func_76572_b() {
        super.func_76572_b();
        this.field_76576_e = true;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            this.solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return this.solarMultiplier;
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public DimensionType func_186058_p() {
        return GSDimensions.KUIPER_BELT;
    }

    public float getArrowGravity() {
        return 0.002f;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public boolean func_191066_m() {
        return false;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public boolean inFreefall(Entity entity) {
        return true;
    }

    public void setInFreefall(Entity entity) {
    }

    public boolean enableAdvancedThermalLevel() {
        return false;
    }

    private static class AsteroidData {
        protected BlockVec3 centre;
        protected int sizeAndLandedFlag = 15;
        protected int coreAndSpawnedFlag = -2;

        public AsteroidData(int x, int y, int z) {
            this.centre = new BlockVec3(x, y, z);
        }

        public AsteroidData(int x, int y, int z, int size, int core) {
            this.centre = new BlockVec3(x, y, z);
            this.sizeAndLandedFlag = size;
            this.coreAndSpawnedFlag = core;
        }

        public AsteroidData(BlockVec3 bv) {
            this.centre = bv;
        }

        public int hashCode() {
            if (this.centre != null) {
                return this.centre.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof AsteroidData) {
                BlockVec3 vector = ((AsteroidData)o).centre;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            if (o instanceof BlockVec3) {
                BlockVec3 vector = (BlockVec3)o;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            return false;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("x", this.centre.x);
            tag.func_74768_a("y", this.centre.y);
            tag.func_74768_a("z", this.centre.z);
            tag.func_74768_a("coreAndFlag", this.coreAndSpawnedFlag);
            tag.func_74768_a("sizeAndFlag", this.sizeAndLandedFlag);
            return tag;
        }

        public static AsteroidData readFromNBT(NBTTagCompound tag) {
            BlockVec3 tempVector = new BlockVec3();
            tempVector.x = tag.func_74762_e("x");
            tempVector.y = tag.func_74762_e("y");
            tempVector.z = tag.func_74762_e("z");
            AsteroidData roid = new AsteroidData(tempVector);
            if (tag.func_74764_b("coreAndFlag")) {
                roid.coreAndSpawnedFlag = tag.func_74762_e("coreAndFlag");
            }
            if (tag.func_74764_b("sizeAndFlag")) {
                roid.sizeAndLandedFlag = tag.func_74762_e("sizeAndFlag");
            }
            return roid;
        }
    }
}

