/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.audio;

import com.google.common.base.Objects;
import ic2.api.classic.audio.AudioPosition;
import ic2.api.classic.audio.IAudioPosition;
import ic2.api.classic.audio.ISoundProvider;
import ic2.api.classic.audio.PositionSpec;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class SoundWrapperEntity
implements ISoundProvider {
    PositionSpec spec;
    Entity entity;
    int hashCode;

    public SoundWrapperEntity(PositionSpec spec, Entity entity) {
        this.spec = spec;
        this.entity = entity;
        this.hashCode = Objects.hashCode((Object[])new Object[]{entity});
    }

    @Override
    public boolean isValid(World world) {
        if (this.entity.field_70128_L) {
            return false;
        }
        return this.getDimensionID(world) == this.getDimensionID(this.entity.func_130014_f_());
    }

    @Override
    public IAudioPosition getAudioPositon() {
        return AudioPosition.getFrom(this.entity, this.spec);
    }

    private int getDimensionID(World world) {
        if (world == null) {
            return 0;
        }
        return world.field_73011_w.getDimension();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SoundWrapperEntity) {
            SoundWrapperEntity other = (SoundWrapperEntity)obj;
            return Objects.equal((Object)this.entity, (Object)other.entity);
        }
        return false;
    }

    public String toString() {
        return "EntitySound: " + this.entity + ", SoundType: " + (Object)((Object)this.spec);
    }
}

