/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropFerru
extends CropCardBase {
    public CropFerru() {
        super(new CropProperties(6, 2, 0, 0, 1, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[35];
        }
        return this.getSprite("bc")[31 + state];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Gray", "Leaves", "Metal"};
    }

    @Override
    public String getId() {
        return "Ferru";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 || cropTile.getCurrentSize() == 3 && (cropTile.isBlockBelow(Blocks.field_150366_p) || cropTile.isBlockBelow(Blocks.field_150339_S));
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.ironDust.func_77946_l();
    }

    @Override
    public double dropGainChance() {
        return super.dropGainChance() / 2.0;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 2000;
        }
        return 800;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

