/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import ic2.api.classic.network.ICustomNetworkClientTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.ITeleporterTarget;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.machine.high.TileEntityTeleporter;
import ic2.core.block.machine.high.container.ContainerTeleporterHub;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTeleporterHub
extends TileEntityElecMachine
implements ITeleporterTarget,
IHasGui,
ICustomNetworkClientTileEventListener,
IEnergyStorage {
    @NetworkField(index=7)
    public TargetSet targets = new TargetSet();
    public static int newTarget = 0;

    public TileEntityTeleporterHub() {
        super(0, 32768);
        this.maxEnergy = 100000000;
        this.addGuiFields("targets");
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.teleporterHub;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targets.readFromNBT(nbt.func_74775_l("Targets"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("Targets", (NBTBase)this.targets.writeToNBT());
        return nbt;
    }

    @Override
    public void setCustomName(String name) {
        super.setCustomName(name);
        if (Strings.isNullOrEmpty((String)name)) {
            ITeleporterTarget.TeleporterNameRegistry.removeTeleporter(new ITeleporterTarget.TeleporterTarget(this));
        } else {
            ITeleporterTarget.TeleporterNameRegistry.addTeleporter(new ITeleporterTarget.TeleporterTarget(this), this.customName);
        }
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isSimulating()) {
            if (Strings.isNullOrEmpty((String)this.customName)) {
                ITeleporterTarget.TeleporterNameRegistry.removeTeleporter(new ITeleporterTarget.TeleporterTarget(this));
            } else {
                ITeleporterTarget.TeleporterNameRegistry.addTeleporter(new ITeleporterTarget.TeleporterTarget(this), this.customName);
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating()) {
            ITeleporterTarget.TeleporterNameRegistry.removeTeleporter(new ITeleporterTarget.TeleporterTarget(this));
        }
        super.onUnloaded();
    }

    @Override
    public void onClientNetworkEvent(EntityPlayer player, INetworkFieldData data) {
        if (!(data instanceof NBTFieldPacket) || player == null) {
            return;
        }
        NBTTagCompound nbt = ((NBTFieldPacket)data).getNBTData();
        ITeleporterTarget.TeleporterTarget target = new ITeleporterTarget.TeleporterTarget(nbt);
        if (nbt.func_74764_b("Teleport")) {
            this.teleportPlayer(player, target);
        } else if (nbt.func_74764_b("Delete")) {
            this.targets.remove(target);
            this.getNetwork().updateTileGuiField(this, "targets");
        } else if (target.equals(new ITeleporterTarget.TeleporterTarget(this))) {
            this.setCustomName(nbt.func_74779_i("Name"));
        } else {
            this.targets.setName(target, nbt.func_74779_i("Name"));
            this.getNetwork().updateTileGuiField(this, "targets");
        }
        this.setActive(this.targets.count() > 0);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerTeleporterHub(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public ITeleporterTarget.TeleportType getSendingType() {
        return ITeleporterTarget.TeleportType.Entity;
    }

    @Override
    public boolean canReceiveType(ITeleporterTarget.TeleportType type) {
        return type == ITeleporterTarget.TeleportType.Entity;
    }

    @Override
    public EnumFacing getTeleporterFacing() {
        return this.getFacing();
    }

    @Override
    public void setTarget(ITeleporterTarget.TeleporterTarget target) {
        this.targets.addTarget(target, Ic2GuiLang.teleporterNewName.getLocalizedFormatted(newTarget++));
        this.targets.updateTargetName(target);
        this.getNetwork().updateTileGuiField(this, "targets");
        this.setActive(this.targets.count() > 0);
    }

    @Override
    public boolean hasTarget(ITeleporterTarget.TeleporterTarget target) {
        return this.targets.contains(target);
    }

    public void teleportPlayer(EntityPlayer player, ITeleporterTarget.TeleporterTarget target) {
        boolean dimSwitch;
        TileEntity tile = target.getTile();
        if (!TileEntityTeleporter.isTeleporter(tile)) {
            this.targets.remove(target);
            this.getNetwork().updateTileGuiField(this, "targets");
            IC2.platform.messagePlayer(player, Ic2GuiLang.teleporterInvalidTarget);
            return;
        }
        if (!TileEntityTeleporter.isSameType(tile, ITeleporterTarget.TeleportType.Entity)) {
            IC2.platform.messagePlayer(player, Ic2GuiLang.teleporterTargetTypeInvalid);
            return;
        }
        this.targets.updateTargetName(target);
        ITeleporterTarget tele = (ITeleporterTarget)tile;
        player.func_184210_p();
        player.func_184226_ay();
        int weight = TileEntityTeleporter.getWeightOfUser((Entity)player);
        if (weight == 0) {
            return;
        }
        double distance = Math.sqrt(this.getDistance(this.func_174877_v(), target.getPos()));
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, (dimSwitch = this.field_145850_b.field_73011_w.getDimension() != target.getDimID()) ? 0.9 : 0.7) * 5.0);
        if (!this.hasEnergy(energyCost)) {
            return;
        }
        EnumFacing side = tele.getTeleporterFacing();
        this.useEnergy(energyCost);
        IC2.achievements.issueStat(player, "distanceTeleported", (int)distance);
        if (distance >= 1000.0) {
            IC2.achievements.issueStat(player, "teleportFarAway");
        }
        double x = (float)(target.getPos().func_177958_n() + side.func_82601_c()) + 0.5f;
        double y = (float)(target.getPos().func_177956_o() + side.func_96559_d()) + 0.5f + player.func_70047_e();
        double z = (float)(target.getPos().func_177952_p() + side.func_82599_e()) + 0.5f;
        if (side.func_176740_k().func_176720_b()) {
            y = side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)target.getPos().func_177956_o() - 2.5 : (double)((float)target.getPos().func_177956_o() + player.func_70047_e());
        }
        if (!IC2.config.getFlag("TeleporterInventory")) {
            player.field_71071_by.func_70436_m();
        }
        player.func_70634_a(x, y, z);
        if (dimSwitch) {
            TileEntityTeleporter.transferPlayerToDimension((EntityPlayerMP)player, target.getDimID());
        }
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public void setStored(int energy) {
        this.energy = energy;
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int addEnergy(int amount) {
        int newValue;
        this.energy = newValue = this.energy + amount;
        this.getNetwork().updateTileGuiField(this, "energy");
        return newValue;
    }

    @Override
    public int getCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getOutput() {
        return 0;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return 0.0;
    }

    @Override
    public boolean isTeleporterCompatible(EnumFacing side) {
        return false;
    }

    public double getDistance(BlockPos key, BlockPos value) {
        return key.func_177951_i((Vec3i)value);
    }

    public static class OverrideTarget
    extends ITeleporterTarget.TeleporterTarget {
        protected OverrideTarget(ITeleporterTarget.TeleporterTarget target) {
            super(target);
            this.isCustom = target.isCustom;
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                ITeleporterTarget.TeleporterTarget target = (ITeleporterTarget.TeleporterTarget)obj;
                target.isCustom = this.isCustom;
                return true;
            }
            return false;
        }
    }

    public static class TargetSet
    implements INetworkFieldData,
    Iterable<Map.Entry<ITeleporterTarget.TeleporterTarget, String>> {
        Map<ITeleporterTarget.TeleporterTarget, String> targets = new LinkedHashMap<ITeleporterTarget.TeleporterTarget, String>();
        List<Tuple<ITeleporterTarget.TeleporterTarget, String>> clientTargets = new ArrayList<Tuple<ITeleporterTarget.TeleporterTarget, String>>();

        public void addTarget(ITeleporterTarget.TeleporterTarget target, String name) {
            this.targets.putIfAbsent(target, name);
        }

        public void setName(ITeleporterTarget.TeleporterTarget target, String name) {
            if (this.targets.containsKey(target)) {
                this.targets.put(new OverrideTarget(target), name);
                return;
            }
            this.targets.put(target, name);
        }

        public boolean contains(ITeleporterTarget.TeleporterTarget target) {
            return this.targets.containsKey(target);
        }

        public void remove(ITeleporterTarget.TeleporterTarget target) {
            this.targets.remove(target);
        }

        @SideOnly(value=Side.CLIENT)
        public List<Tuple<ITeleporterTarget.TeleporterTarget, String>> getTargets() {
            return this.clientTargets;
        }

        @Override
        public Iterator<Map.Entry<ITeleporterTarget.TeleporterTarget, String>> iterator() {
            return this.targets.entrySet().iterator();
        }

        public int count() {
            return this.targets.size();
        }

        public void updateTargetName(ITeleporterTarget.TeleporterTarget target) {
            if (target.isCustom) {
                return;
            }
            String name = this.targets.get(target);
            String registry = this.getName(target);
            if (!Strings.isNullOrEmpty((String)registry) && !Objects.equal((Object)name, (Object)registry)) {
                this.setName(target, name);
            }
        }

        public String getName(ITeleporterTarget.TeleporterTarget target) {
            IWorldNameable name;
            TileEntity tile = target.getTile();
            if (tile instanceof IWorldNameable && (name = (IWorldNameable)tile).func_145818_k_()) {
                return name.func_70005_c_();
            }
            return ITeleporterTarget.TeleporterNameRegistry.getName(target);
        }

        @Override
        public void read(IInputBuffer buffer) {
            this.clientTargets.clear();
            int max = buffer.readShort();
            for (int i = 0; i < max; ++i) {
                int dim = buffer.readInt();
                BlockPos pos = BlockPos.func_177969_a((long)buffer.readLong());
                boolean custom = buffer.readBoolean();
                String text = buffer.readString();
                ITeleporterTarget.TeleporterTarget tele = new ITeleporterTarget.TeleporterTarget(pos, dim);
                tele.isCustom = custom;
                this.clientTargets.add((Tuple<ITeleporterTarget.TeleporterTarget, String>)new Tuple((Object)tele, (Object)text));
            }
        }

        @Override
        public void write(IOutputBuffer buffer) {
            buffer.writeShort((short)this.targets.size());
            for (Map.Entry<ITeleporterTarget.TeleporterTarget, String> entry : this.targets.entrySet()) {
                String registry;
                ITeleporterTarget.TeleporterTarget target = entry.getKey();
                buffer.writeInt(target.getDimID());
                buffer.writeLong(target.getPos().func_177986_g());
                buffer.writeBoolean(target.isCustom);
                String name = entry.getValue();
                if (!(target.isCustom || Strings.isNullOrEmpty((String)(registry = ITeleporterTarget.TeleporterNameRegistry.getName(target))) || Objects.equal((Object)name, (Object)registry))) {
                    name = registry;
                    entry.setValue(name);
                }
                buffer.writeString(name);
            }
        }

        public NBTTagCompound writeToNBT() {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<ITeleporterTarget.TeleporterTarget, String> entry : this.targets.entrySet()) {
                NBTTagCompound nbt = entry.getKey().writeToNBT();
                nbt.func_74778_a("Name", entry.getValue());
                list.func_74742_a((NBTBase)nbt);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("Data", (NBTBase)list);
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.targets.clear();
            NBTTagList list = nbt.func_150295_c("Data", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                this.targets.put(new ITeleporterTarget.TeleporterTarget(data), data.func_74779_i("Name"));
            }
        }
    }
}

