/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.classic.item.IScannerItem;
import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.low.TileEntityPump;
import ic2.core.block.machine.low.container.ContainerMiner;
import ic2.core.block.machine.low.logic.miner.FluidMiningTarget;
import ic2.core.block.machine.low.logic.miner.IMiningTarget;
import ic2.core.block.machine.low.logic.miner.MinerCache;
import ic2.core.block.machine.low.logic.miner.NormalMiningTarget;
import ic2.core.block.misc.BlockMiningPipe;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityMiner
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
IBitLevelOverride {
    public MinerCache cache = new MinerCache(this);
    public IMiningTarget target;
    public IMiningTarget mining;
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    public short miningTicker = 0;
    public String stuckOn = null;
    private AudioSource audioSource;
    private TileEntityPump[] connectedPumps = new TileEntityPump[6];
    private Set<Integer> iterator = new LinkedHashSet<Integer>();
    public int ticker = 0;

    public TileEntityMiner() {
        super(4, 32);
        this.setFuelSlot(0);
        this.maxEnergy = 10000;
        this.addInfos(new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.DOWN.invert());
        handler.registerDefaultSideAccess(AccessRule.None, RotationList.DOWN);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1, 2, 3);
        handler.registerDefaultSlotsForSide(RotationList.UP, 2);
        handler.registerDefaultSlotsForSide(RotationList.PCORNER, 3);
        handler.registerDefaultSlotsForSide(RotationList.NCORNER, 1);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(CommonFilters.Scanners, 1);
        handler.registerInputFilter(CommonFilters.NoneNullBlock, 2);
        handler.registerInputFilter(CommonFilters.MiningDrills, 3);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Tools, 1, 3);
        handler.registerSlotType(SlotType.Input, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit16;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public float getProgress() {
        if (this.miningTicker < 0) {
            return 0.0f;
        }
        return this.miningTicker;
    }

    @Override
    public float getMaxProgress() {
        return 200.0f;
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") && this.isActiveChanged()) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.minerOp, true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.miningTicker = nbt.func_74765_d("miningTicker");
        this.cache.readFromNBT(nbt.func_74775_l("cache"));
        byte type = nbt.func_74771_c("TypeID");
        this.mining = null;
        this.target = null;
        if (type == 0) {
            return;
        }
        IMiningTarget iMiningTarget = this.target = type == 1 ? new NormalMiningTarget() : new FluidMiningTarget();
        if (!this.target.loadFromNBT(nbt.func_74775_l("Target"))) {
            this.target = null;
            return;
        }
        byte miningId = nbt.func_74771_c("MiningID");
        IMiningTarget iMiningTarget2 = this.mining = miningId == 1 ? new NormalMiningTarget() : new FluidMiningTarget();
        if (!this.mining.loadFromNBT(nbt.func_74775_l("Mining"))) {
            this.mining = this.target;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("miningTicker", this.miningTicker);
        this.cache.writeToNBT(this.getTag(nbt, "cache"));
        if (this.target == null) {
            nbt.func_74774_a("TypeID", (byte)0);
            return nbt;
        }
        nbt.func_74774_a("TypeID", this.target.getID());
        nbt.func_74782_a("Target", (NBTBase)this.target.save());
        nbt.func_74774_a("MiningID", this.mining.getID());
        nbt.func_74782_a("Mining", (NBTBase)this.mining.save());
        return nbt;
    }

    @Override
    public int getTier() {
        return IC2.config.getFlag("MinerLapotron") ? 4 : 1;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (this.ticker++ % 80 == 0) {
            this.updatePumps();
        }
        if (this.hasEnergy()) {
            if (((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IElectricItem) {
                this.energy = (int)((double)this.energy - ElectricItem.manager.charge((ItemStack)this.inventory.get(1), this.energy, 2, true, false));
            }
            if (((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IElectricItem) {
                this.energy = (int)((double)this.energy - ElectricItem.manager.charge((ItemStack)this.inventory.get(3), this.energy, 2, true, false));
            }
        }
        this.handleChargeSlot(this.maxEnergy);
        boolean operating = this.isOperating();
        if (operating) {
            this.mine();
        } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.stuckOn = null;
                this.target = null;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.useEnergy(2);
                if (this.miningTicker >= 5) {
                    this.miningTicker = 0;
                    this.withdrawPipe();
                }
                if (this.cache.canClear()) {
                    this.cache.clear();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        } else if (this.isStuck() && this.field_145850_b.func_82737_E() % 120L == 0L) {
            this.miningTicker = 0;
        }
        this.setActive(operating);
        this.updateComparators();
    }

    public void withdrawPipe() {
        BlockPos target = this.getPipeTip();
        if (!this.field_145850_b.func_175623_d(target)) {
            IBlockState state;
            List list;
            if (this.func_174877_v().func_177956_o() - target.func_177956_o() > 0 && !this.sendItemAway(list = (state = this.field_145850_b.func_180495_p(target)).func_177230_c().getDrops((IBlockAccess)this.func_145831_w(), target, state, 0))) {
                for (int i = 0; i < list.size(); ++i) {
                    StackUtil.dropAsEntity(this.field_145850_b, target, (ItemStack)list.get(i));
                }
            }
            this.field_145850_b.func_175698_g(target);
        }
        if (((ItemStack)this.inventory.get(2)).func_77973_b() != Ic2Items.miningPipe.func_77973_b() && Block.func_149634_a((Item)((ItemStack)this.inventory.get(2)).func_77973_b()) != Blocks.field_150350_a) {
            Item item = ((ItemStack)this.inventory.get(2)).func_77973_b();
            this.field_145850_b.func_175656_a(target, Block.func_149634_a((Item)item).func_176203_a(item.func_77647_b(((ItemStack)this.inventory.get(2)).func_77960_j())));
            ((ItemStack)this.inventory.get(2)).func_190918_g(1);
        }
        this.updateMineTip(target.func_177956_o() + 1);
    }

    public boolean sendItemAway(List<ItemStack> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (Direction dir : Direction.directions) {
            IItemTransporter trans;
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile == null || tile instanceof TileEntityMiner || tile instanceof TileEntityPump || (trans = TransporterManager.manager.getTransporter(tile, false)) == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (stack.func_190926_b()) {
                    list.remove(i--);
                    if (!list.isEmpty()) continue;
                    trans.onFinishedActions();
                    return true;
                }
                ItemStack injected = trans.addItem(stack, dir.getInverse().toFacing(), true);
                if (injected.func_190926_b()) continue;
                stack.func_190918_g(injected.func_190916_E());
                if (!stack.func_190926_b()) continue;
                list.remove(i--);
                if (!list.isEmpty()) continue;
                trans.onFinishedActions();
                return true;
            }
            trans.onFinishedActions();
        }
        return false;
    }

    public boolean canWithdraw() {
        return BlockMiningPipe.isMiningPipe(this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()));
    }

    public void mine() {
        if (this.target == null) {
            this.aquireTarget();
            return;
        }
        if (this.mining == null) {
            this.mining = this.target;
        }
        boolean forcedTickSkip = false;
        int checksLeft = 20;
        BlockPos.MutableBlockPos miningTarget = new BlockPos.MutableBlockPos(this.mining.getTargetPos());
        BlockPos target = this.mining.getTargetPos();
        while (!this.canReachTarget(miningTarget, true)) {
            int xdif = target.func_177958_n() - this.func_174877_v().func_177958_n();
            int zdif = target.func_177952_p() - this.func_174877_v().func_177952_p();
            target = Math.abs(xdif) > Math.abs(zdif) ? (xdif > 0 ? target.func_177972_a(EnumFacing.WEST) : target.func_177972_a(EnumFacing.EAST)) : (zdif > 0 ? target.func_177972_a(EnumFacing.NORTH) : target.func_177972_a(EnumFacing.SOUTH));
            forcedTickSkip = true;
            if (checksLeft-- > 0) continue;
            break;
        }
        if (!this.mining.getTargetPos().equals((Object)target)) {
            this.mining = this.createTarget(target.func_185334_h());
        }
        if (forcedTickSkip) {
            return;
        }
        if (!this.mining.canMine(this)) {
            this.miningTicker = (short)-1;
            this.stuckOn = this.field_145850_b.func_180495_p(this.mining.getTargetPos()).func_177230_c().func_149739_a();
        } else if (this.mining.canContinue(this)) {
            this.stuckOn = null;
            this.miningTicker = (short)(this.miningTicker + 1);
            this.useEnergy(1);
            IMiningDrill drill = (IMiningDrill)((ItemStack)this.inventory.get(3)).func_77973_b();
            if (!drill.isBasicDrill((ItemStack)this.inventory.get(3))) {
                this.miningTicker = (short)(this.miningTicker + drill.getExtraSpeed((ItemStack)this.inventory.get(3)));
                this.useEnergy(drill.getExtraEnergyCost((ItemStack)this.inventory.get(3)));
            }
            if (this.miningTicker >= 200) {
                this.miningTicker = 0;
                this.mineBlock();
            }
        }
    }

    public void mineBlock() {
        if (((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IMiningDrill) {
            ((IMiningDrill)((ItemStack)this.inventory.get(3)).func_77973_b()).useDrill((ItemStack)this.inventory.get(3));
        }
        this.mining.createDrops(this);
        BlockPos miningPos = this.mining.getTargetPos();
        IBlockState oldState = this.mining.getMemoryState();
        this.field_145850_b.func_180501_a(miningPos, Blocks.field_150350_a.func_176223_P(), 2);
        TileEntityMiner.doBlockUpdates(this.field_145850_b, miningPos, oldState, this.field_174879_c);
        List<ItemStack> list = this.mining.getDrops();
        if (!this.sendItemAway(list)) {
            for (int i = 0; i < list.size(); ++i) {
                StackUtil.dropAsEntity(this.field_145850_b, this.func_174877_v(), list.get(i));
            }
        }
        if (this.matchHorizontally(miningPos, this.func_174877_v())) {
            this.field_145850_b.func_175656_a(miningPos, Ic2States.miningPipe);
            ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            this.useEnergy(10);
        }
        this.updateMineTip(miningPos.func_177956_o());
        if (miningPos.func_177956_o() != this.getPipeTip().func_177956_o()) {
            this.target = null;
            this.mining = null;
            this.cache.clear();
            return;
        }
        BlockPos targetPos = this.target.getTargetPos();
        if (miningPos.equals((Object)targetPos) || !this.field_145850_b.func_175667_e(targetPos) || this.field_145850_b.func_175623_d(targetPos) || !this.isValuableOre(targetPos)) {
            this.target = null;
            this.mining = null;
        } else {
            this.mining = this.target;
        }
    }

    public static void doBlockUpdates(World world, BlockPos toChange, IBlockState old, BlockPos ownPos) {
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)toChange, (IBlockState)Blocks.field_150350_a.func_176223_P(), EnumSet.allOf(EnumFacing.class), (boolean)false).isCanceled()) {
            return;
        }
        final Block oldBlock = old.func_177230_c();
        for (EnumFacing offset : EnumFacing.field_176754_o) {
            IBlockState state;
            Block newBlock;
            BlockPos targetBlock = toChange.func_177972_a(offset);
            if (!world.func_175667_e(targetBlock) || (newBlock = (state = world.func_180495_p(targetBlock)).func_177230_c()) instanceof BlockStaticLiquid || newBlock instanceof IFluidBlock) continue;
            try {
                state.func_189546_a(world, targetBlock, oldBlock, ownPos);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
                crashreportcategory.func_189529_a("Source block type", (ICrashReportDetail)new ICrashReportDetail<String>(){

                    public String call() throws Exception {
                        try {
                            return String.format("ID #%d (%s // %s)", Block.func_149682_b((Block)oldBlock), oldBlock.func_149739_a(), oldBlock.getClass().getCanonicalName());
                        }
                        catch (Throwable var2) {
                            return "ID #" + Block.func_149682_b((Block)oldBlock);
                        }
                    }
                });
                CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)targetBlock, (IBlockState)state);
                throw new ReportedException(crashreport);
            }
        }
    }

    private boolean isValuableOre(BlockPos pos) {
        ItemStack stack = (ItemStack)this.inventory.get(1);
        if (stack.func_190926_b()) {
            return false;
        }
        IScannerItem item = (IScannerItem)stack.func_77973_b();
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return item.isAdvancedScanner(stack) ? item.isValuableOre(stack, state, this.field_145850_b, pos) : item.isValuableOre(stack, state);
    }

    private boolean matchHorizontally(BlockPos key, BlockPos value) {
        return key.func_177958_n() == value.func_177958_n() && key.func_177952_p() == value.func_177952_p();
    }

    public void updateMineTip(int low) {
        if (low == this.func_174877_v().func_177956_o()) {
            return;
        }
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos(this.func_174877_v().func_177977_b());
        while (target.func_177956_o() > low) {
            IBlockState state = this.field_145850_b.func_180495_p((BlockPos)target);
            Block block = state.func_177230_c();
            boolean miningPipe = BlockMiningPipe.isMiningPipe(state);
            boolean isTip = BlockMiningPipe.isMiningPipeTip(state);
            if (!miningPipe && ((ItemStack)this.inventory.get(2)).func_190916_E() > 0 || isTip) {
                this.field_145850_b.func_175656_a((BlockPos)target, Ic2States.miningPipe);
                if (!miningPipe) {
                    ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                }
            }
            target.func_185336_p(target.func_177956_o() - 1);
        }
        this.field_145850_b.func_175656_a((BlockPos)target, Ic2States.miningPipeTip);
    }

    public boolean canReachTarget(BlockPos.MutableBlockPos targetPos, boolean ignore) {
        IBlockState state;
        int xCoord = this.func_174877_v().func_177958_n();
        int zCoord = this.func_174877_v().func_177952_p();
        if (this.matchHorizontally((BlockPos)targetPos, this.func_174877_v())) {
            return true;
        }
        if (!(ignore || (state = this.field_145850_b.func_180495_p((BlockPos)targetPos)).func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, (BlockPos)targetPos) || this.canPass(state, this.field_145850_b, (BlockPos)targetPos))) {
            return false;
        }
        int xdif = targetPos.func_177958_n() - xCoord;
        int zdif = targetPos.func_177952_p() - zCoord;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            if (xdif > 0) {
                targetPos.func_189536_c(EnumFacing.WEST);
            } else {
                targetPos.func_189536_c(EnumFacing.EAST);
            }
        } else if (zdif > 0) {
            targetPos.func_189536_c(EnumFacing.NORTH);
        } else {
            targetPos.func_189536_c(EnumFacing.SOUTH);
        }
        return this.canReachTarget(targetPos, false);
    }

    public void aquireTarget() {
        BlockPos pipe = this.getPipeTip();
        if (pipe.func_177956_o() >= this.func_174877_v().func_177956_o() || !(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IScannerItem)) {
            this.setTarget(this.createTarget(pipe.func_177977_b()));
            return;
        }
        if (this.cache.hasTargets()) {
            this.setTarget(this.cache.getTarget());
            return;
        }
        this.cache.findTargets(pipe, (IScannerItem)((ItemStack)this.inventory.get(1)).func_77973_b(), (ItemStack)this.inventory.get(1));
        if (this.cache.hasTargets()) {
            this.setTarget(this.cache.getTarget());
            return;
        }
        this.setTarget(this.createTarget(pipe.func_177977_b()));
    }

    public List<BlockPos> getList(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            list.add(pos.func_177972_a(dir));
        }
        return list;
    }

    public void setTarget(IMiningTarget newTarget) {
        if (newTarget.validateTarget(this)) {
            this.target = newTarget;
            this.mining = newTarget;
        } else {
            this.target = null;
            this.mining = null;
        }
    }

    public IMiningTarget createTarget(BlockPos target) {
        IBlockState state = this.field_145850_b.func_180495_p(target);
        IFluidHandler handler = FluidHelper.getBlockHandler(state, this.field_145850_b, target);
        if (handler != null && handler.getTankProperties()[0].getContents() != null) {
            return new FluidMiningTarget(state, target);
        }
        return new NormalMiningTarget(state, target);
    }

    public boolean canPass(IBlockState state, World world, BlockPos pos) {
        IFluidHandler handler = FluidHelper.getBlockHandler(state, world, pos);
        if (handler != null) {
            return handler.getTankProperties()[0].getContents() == null;
        }
        return this.canPass(state);
    }

    public boolean canPass(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150350_a || BlockMiningPipe.isMiningPipe(state) || state == Ic2States.miner;
    }

    public boolean canMine(BlockPos target, IBlockState state) {
        IFluidHandler handler;
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)this.field_145850_b, target)) {
            return true;
        }
        if (BlockMiningPipe.isMiningPipe(state)) {
            return false;
        }
        if (this.hasPumps() && (handler = FluidHelper.getBlockHandler(state, this.field_145850_b, target)) != null) {
            IFluidTankProperties prop = handler.getTankProperties()[0];
            FluidStack fluid = prop.getContents();
            if (prop.canDrain() && fluid != null && this.hasFluidPump(fluid)) {
                return this.canMineEvent(target, state);
            }
            return true;
        }
        if (state.func_185887_b(this.field_145850_b, target) < 0.0f) {
            return false;
        }
        if (block.func_176209_a(state, false) && state.func_185904_a().func_76229_l()) {
            return this.canMineEvent(target, state);
        }
        if (block == Blocks.field_150321_G) {
            return this.canMineEvent(target, state);
        }
        if (((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IMiningDrill) {
            IMiningDrill mining = (IMiningDrill)((ItemStack)this.inventory.get(3)).func_77973_b();
            if (!mining.canMineBlock((ItemStack)this.inventory.get(3), state, (IBlockAccess)this.field_145850_b, target) && !((ItemStack)this.inventory.get(3)).func_150998_b(state)) {
                return false;
            }
            return this.canMineEvent(target, state);
        }
        return false;
    }

    public boolean canMineEvent(BlockPos target, IBlockState state) {
        BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(this.field_145850_b, target, state, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)));
        evt.setExpToDrop(0);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public BlockPos getPipeTip() {
        BlockPos.MutableBlockPos pipe = new BlockPos.MutableBlockPos(this.func_174877_v().func_177977_b());
        while (pipe.func_177956_o() >= 0) {
            IBlockState state = this.field_145850_b.func_180495_p((BlockPos)pipe);
            if (BlockMiningPipe.isMiningPipe(state)) {
                pipe.func_189536_c(EnumFacing.DOWN);
                continue;
            }
            pipe.func_189536_c(EnumFacing.UP);
            break;
        }
        return pipe.func_185334_h();
    }

    public boolean hasFluidPump(FluidStack fluid) {
        if (fluid == null) {
            return false;
        }
        for (Integer side : this.iterator) {
            TileEntityPump pump = this.connectedPumps[side];
            if (pump == null || pump.func_145837_r() || pump.pumpThis(fluid, false) == EnumActionResult.FAIL) continue;
            return true;
        }
        return false;
    }

    public EnumActionResult canPumpFluid(FluidStack fluid) {
        if (fluid == null) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult result = EnumActionResult.FAIL;
        for (Integer side : this.iterator) {
            TileEntityPump pump = this.connectedPumps[side];
            if (pump == null || pump.func_145837_r()) continue;
            EnumActionResult preResult = pump.pumpThis(fluid, false);
            if (preResult == EnumActionResult.SUCCESS) {
                return EnumActionResult.SUCCESS;
            }
            if (preResult != EnumActionResult.PASS) continue;
            result = preResult;
        }
        return result;
    }

    public boolean pumpFluid(FluidStack fluid) {
        for (Integer side : this.iterator) {
            TileEntityPump pump = this.connectedPumps[side];
            if (pump == null || pump.func_145837_r() || pump.pumpThis(fluid, true) != EnumActionResult.SUCCESS) continue;
            return true;
        }
        return false;
    }

    public boolean hasPumps() {
        return this.iterator.size() > 0;
    }

    public boolean isOperating() {
        return this.hasEnergy() && this.canOperate();
    }

    public boolean hasEnergy() {
        return this.energy > 100;
    }

    public boolean canOperate() {
        return !((ItemStack)this.inventory.get(3)).func_190926_b() && (((ItemStack)this.inventory.get(2)).func_77973_b() == Ic2Items.miningPipe.func_77973_b() || this.cache.hasTargets()) && this.canMiningDrillBeUsed() && !this.isStuck();
    }

    public boolean canMiningDrillBeUsed() {
        if (!(((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IMiningDrill)) {
            return false;
        }
        IMiningDrill drill = (IMiningDrill)((ItemStack)this.inventory.get(3)).func_77973_b();
        if (!drill.canMine((ItemStack)this.inventory.get(3))) {
            if (!(drill instanceof IElectricItem)) {
                return false;
            }
            IElectricItem item = (IElectricItem)((Object)drill);
            if (item.getMaxCharge((ItemStack)this.inventory.get(3)) == 0.0 || item.getTransferLimit((ItemStack)this.inventory.get(3)) == 0.0) {
                return false;
            }
        }
        return true;
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    private void updatePumps() {
        for (Direction dir : Direction.directions) {
            TileEntity tile = dir.applyToTileEntity(this);
            if (!(tile instanceof TileEntityPump)) {
                this.connectedPumps[dir.toSideValue()] = null;
                this.iterator.remove(dir.toSideValue());
                continue;
            }
            this.connectedPumps[dir.toSideValue()] = (TileEntityPump)tile;
            this.iterator.add(dir.toSideValue());
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerMiner(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        if (this.stuckOn != null) {
            IC2.platform.messagePlayer(player, "Miner is Stuck on: " + this.stuckOn);
        }
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.miner;
    }
}

