/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.render.model;

import ic2.core.block.wiring.BlockLuminator;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class LuminatorModel
extends BaseModel {
    Map<ItemWithMeta, List<BakedQuad>> quads = new HashMap<ItemWithMeta, List<BakedQuad>>();
    List<BakedQuad> itemQuads = new ArrayList<BakedQuad>();
    List<BakedQuad> noneGlass = new ArrayList<BakedQuad>();
    IBlockState state;
    boolean isItem;

    public LuminatorModel(IBlockState state, boolean item) {
        super(Ic2Models.getBlockTransforms());
        this.state = state;
        this.isItem = item;
    }

    @Override
    public void init() {
        this.setParticalTexture(Ic2Icons.getTextures("b0")[30]);
        if (this.isItem) {
            this.itemQuads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)this.func_177554_e(), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(Ic2Models.getItemTransforms().get((Object)ItemCameraTransforms.TransformType.FIXED))));
        }
        this.doEntry((EnumFacing)this.state.func_177229_b((IProperty)BlockLuminator.sides), (Boolean)this.state.func_177229_b((IProperty)BlockLuminator.big), (Boolean)this.state.func_177229_b((IProperty)BlockLuminator.active));
    }

    public void doEntry(EnumFacing side, boolean fullCover, boolean active) {
        this.noneGlass.addAll(this.makeBaseQuad(side, fullCover, active));
    }

    public List<BakedQuad> makeBaseQuad(EnumFacing face, boolean fullCover, boolean active) {
        FaceBakery bake = this.getBakery();
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        float[] box = this.getBox(face, fullCover);
        for (EnumFacing rotation : EnumFacing.field_82609_l) {
            float[] fArray;
            if (rotation == face || rotation.func_176734_d() == face) {
                float[] fArray2 = new float[4];
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
                fArray2[2] = 16.0f;
                fArray = fArray2;
                fArray2[3] = 16.0f;
            } else if (rotation.func_176740_k().func_176720_b()) {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.0f;
                fArray3[1] = 15.0f;
                fArray3[2] = 16.0f;
                fArray = fArray3;
                fArray3[3] = 16.0f;
            } else {
                float[] fArray4 = new float[4];
                fArray4[0] = 15.0f;
                fArray4[1] = 0.0f;
                fArray4[2] = 16.0f;
                fArray = fArray4;
                fArray4[3] = 16.0f;
            }
            float[] array = fArray;
            list.add(bake.func_178414_a(new Vector3f(16.0f * box[0], 16.0f * box[1], 16.0f * box[2]), new Vector3f(16.0f * box[3], 16.0f * box[4], 16.0f * box[5]), new BlockPartFace(null, 100, "", new BlockFaceUV(array, 0)), Ic2Icons.getTextures("b0")[active ? 31 : 30], rotation, ModelRotation.X0_Y0, null, true, true));
        }
        return list;
    }

    public float[] getBox(EnumFacing facing, boolean fullCover) {
        float px = 0.0625f;
        float glass = 0.01f;
        switch (facing.func_176745_a()) {
            case 1: {
                return new float[]{0.0f + glass, 0.0f, 0.0f + glass, 1.0f - glass, 1.0f * px, 1.0f - glass};
            }
            case 2: {
                if (fullCover) {
                    return new float[]{0.0f + glass, 0.0f + glass, 15.0f * px, 1.0f - glass, 1.0f - glass, 1.0f};
                }
                return new float[]{6.0f * px, 3.0f * px, 14.0f * px, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 1.0f};
            }
            case 3: {
                if (fullCover) {
                    return new float[]{0.0f + glass, 0.0f + glass, 0.0f, 1.0f - glass, 1.0f - glass, 1.0f * px};
                }
                return new float[]{6.0f * px, 3.0f * px, 0.0f, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 2.0f * px};
            }
            case 4: {
                if (fullCover) {
                    return new float[]{15.0f * px, 0.0f + glass, 0.0f + glass, 1.0f, 1.0f - glass, 1.0f - glass};
                }
                return new float[]{14.0f * px, 3.0f * px, 6.0f * px, 1.0f, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
            case 5: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f + glass, 0.0f + glass, 1.0f * px, 1.0f - glass, 1.0f - glass};
                }
                return new float[]{0.0f, 3.0f * px, 6.0f * px, 2.0f * px, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
        }
        if (fullCover) {
            return new float[]{0.0f + glass, 15.0f * px, 0.0f + glass, 1.0f - glass, 1.0f, 1.0f - glass};
        }
        return new float[]{4.0f * px, 13.0f * px, 4.0f * px, 1.0f - 4.0f * px, 1.0f, 1.0f - 4.0f * px};
    }

    public List<BakedQuad> createQuads(ItemWithMeta type) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(this.noneGlass);
        Item item = type.getItem();
        Block block = Block.func_149634_a((Item)item);
        if (block != null) {
            List list;
            IBlockState state = block.func_176203_a(item.func_77647_b(type.getMeta()));
            IBakedModel model = this.getShapes().func_178125_b(state);
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)state.func_177230_c().func_180664_k());
            boolean added = false;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                List list2 = model.func_188616_a(state, facing, 0L);
                if (list2.isEmpty()) continue;
                quads.addAll(list2);
                added = true;
            }
            if (!added && !(list = model.func_188616_a(state, null, 0L)).isEmpty()) {
                quads.addAll(list);
            }
            ForgeHooksClient.setRenderLayer(null);
        }
        return quads;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return this.getEmptyList();
        }
        if (state == null) {
            return this.itemQuads;
        }
        if (state instanceof BlockStateContainerIC2.IC2BlockState) {
            ItemWithMeta item = (ItemWithMeta)((BlockStateContainerIC2.IC2BlockState)state).getData();
            List<BakedQuad> quad = this.quads.get(item);
            if (quad == null) {
                quad = this.createQuads(item);
                this.quads.put(item, quad);
            }
            return quad;
        }
        return this.noneGlass;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    private BlockModelShapes getShapes() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a();
    }
}

