/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.info.EmitterInfo;
import ic2.core.block.base.util.info.EnergyPacketInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import ic2.core.block.wiring.container.ContainerCreativeEnergyStorage;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityCreativeEnergyStorage
extends TileEntityBlock
implements IMultiEnergySource,
IEmitterTile,
IEnergyStorage,
IHasGui,
INetworkClientTileEventListener {
    @NetworkField(index=3)
    public int offer = 32;
    @NetworkField(index=4, compression=NetworkField.BitLevel.Bit8)
    public int packets = 4;
    public boolean enet;

    public TileEntityCreativeEnergyStorage() {
        this.addGuiFields("offer", "packets");
        this.addInfos(new EmitterInfo(this), new EnergyPacketInfo(this), new SourceTierInfo(this));
    }

    @Override
    public void setFacing(EnumFacing face) {
    }

    @Override
    public EnumFacing getFacing() {
        return EnumFacing.NORTH;
    }

    @Override
    public double getOfferedEnergy() {
        return this.offer;
    }

    @Override
    public void drawEnergy(double amount) {
    }

    @Override
    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.offer);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public int getStored() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setStored(int energy) {
    }

    @Override
    public int addEnergy(int amount) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getOutput() {
        return this.offer;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return this.offer * this.packets;
    }

    @Override
    public boolean isTeleporterCompatible(EnumFacing side) {
        return true;
    }

    @Override
    public boolean sendMultipleEnergyPackets() {
        return this.packets > 1;
    }

    @Override
    public int getMultipleEnergyPacketAmount() {
        return this.packets;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.enet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.enet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.packets = nbt.func_74762_e("Packets");
        this.offer = nbt.func_74762_e("Offer");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Packets", this.packets);
        nbt.func_74768_a("Offer", this.offer);
        return nbt;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCreativeEnergyStorage(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.packets += value;
            if (this.packets < 1) {
                this.packets = 1;
            } else if (this.packets > 100) {
                this.packets = 100;
            }
            this.getNetwork().updateTileGuiField(this, "packets");
        } else if (event == 1) {
            this.offer += value;
            if (this.offer < 1) {
                this.offer = 1;
            } else if ((double)this.offer > EnergyNet.instance.getPowerFromTier(13)) {
                this.offer = (int)EnergyNet.instance.getPowerFromTier(13);
            }
            this.getNetwork().updateTileGuiField(this, "offer");
        }
    }
}

