/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.explosion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class PointExplosion {
    private Random ExplosionRNG;
    private World worldObj;
    public BlockPos explosionPos;
    public Entity exploder;
    public float explosionSize;
    public float explosionDropRate;
    public float explosionDamage;
    public Set<BlockPos> destroyedBlockPositions = new HashSet<BlockPos>();
    private Explosion fakeExplosion;
    private DamageSource damagesource;

    public PointExplosion(World world, Entity entity, BlockPos pos, float power, float drop, float entitydamage) {
        this.ExplosionRNG = world.field_73012_v;
        this.worldObj = world;
        this.exploder = entity;
        this.explosionSize = power;
        this.explosionDropRate = drop;
        this.explosionDamage = entitydamage;
        this.explosionPos = pos;
        if (pos.func_177958_n() < 0) {
            this.explosionPos = pos.func_177982_a(-1, 0, 0);
        }
        if (pos.func_177952_p() < 0) {
            this.explosionPos = pos.func_177982_a(0, 0, -1);
        }
        this.fakeExplosion = new Explosion(world, entity, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), power, false, false);
        this.damagesource = DamageSource.func_94539_a((Explosion)this.fakeExplosion);
    }

    public void doExplosionA(int lowX, int lowY, int lowZ, int highX, int highY, int highZ) {
        int minX = this.explosionPos.func_177958_n() - lowX;
        int minY = this.explosionPos.func_177956_o() - lowY;
        int minZ = this.explosionPos.func_177952_p() - lowZ;
        int maxX = this.explosionPos.func_177958_n() + highX;
        int maxY = this.explosionPos.func_177956_o() + highY;
        int maxZ = this.explosionPos.func_177952_p() + highZ;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.worldObj.func_180495_p(pos);
                    float resis = 0.0f;
                    if (state.func_177230_c() != Blocks.field_150350_a) {
                        resis = state.func_177230_c().getExplosionResistance(this.worldObj, pos, this.exploder, this.fakeExplosion);
                    }
                    if (!(this.explosionSize >= resis / 10.0f)) continue;
                    this.destroyedBlockPositions.add(pos);
                }
            }
        }
        this.explosionSize *= 2.0f;
        int k = MathHelper.func_76128_c((double)((double)((float)this.explosionPos.func_177958_n() - this.explosionSize) - 1.0));
        int i1 = MathHelper.func_76128_c((double)((double)((float)this.explosionPos.func_177958_n() + this.explosionSize) + 1.0));
        int k2 = MathHelper.func_76128_c((double)((double)((float)this.explosionPos.func_177956_o() - this.explosionSize) - 1.0));
        int l1 = MathHelper.func_76128_c((double)((double)((float)this.explosionPos.func_177956_o() + this.explosionSize) + 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)((float)this.explosionPos.func_177952_p() - this.explosionSize) - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)((float)this.explosionPos.func_177952_p() + this.explosionSize) + 1.0));
        List list = this.worldObj.func_72839_b(this.exploder, new AxisAlignedBB((double)k, (double)k2, (double)i2, (double)i1, (double)l1, (double)j2));
        Vec3d vec3d = new Vec3d((double)this.explosionPos.func_177958_n(), (double)this.explosionPos.func_177956_o(), (double)this.explosionPos.func_177952_p());
        for (int k3 = 0; k3 < list.size(); ++k3) {
            Entity entity = (Entity)list.get(k3);
            double d4 = entity.func_70011_f((double)this.explosionPos.func_177958_n(), (double)this.explosionPos.func_177956_o(), (double)this.explosionPos.func_177952_p()) / (double)this.explosionSize;
            if (!(d4 <= 1.0)) continue;
            double d2 = entity.field_70165_t - (double)this.explosionPos.func_177958_n();
            double d3 = entity.field_70163_u - (double)this.explosionPos.func_177956_o();
            d4 = entity.field_70161_v - (double)this.explosionPos.func_177952_p();
            double d5 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3 + d4 * d4));
            d2 /= d5;
            d3 /= d5;
            double d6 = this.worldObj.func_72842_a(vec3d, entity.func_174813_aQ());
            double d7 = (1.0 - (d4 /= d5)) * d6;
            entity.func_70097_a(this.damagesource, (float)((int)(((d7 * d7 + d7) / 2.0 * 8.0 * (double)this.explosionSize + 1.0) * (double)this.explosionDamage)));
            double d8 = d7;
            Entity entity2 = entity;
            entity2.field_70159_w += d2 * d8;
            Entity entity3 = entity;
            entity3.field_70181_x += d3 * d8;
            Entity entity4 = entity;
            entity4.field_70179_y += d4 * d8;
        }
    }

    public void doExplosionB(boolean flag) {
        this.worldObj.func_184133_a(null, this.explosionPos, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        ArrayList<BlockPos> arraylist = new ArrayList<BlockPos>();
        arraylist.addAll(this.destroyedBlockPositions);
        for (int i = arraylist.size() - 1; i >= 0; --i) {
            BlockPos pos = (BlockPos)arraylist.get(i);
            IBlockState state = this.worldObj.func_180495_p(pos);
            if (flag) {
                double d = (float)pos.func_177958_n() + this.worldObj.field_73012_v.nextFloat();
                double d2 = (float)pos.func_177956_o() + this.worldObj.field_73012_v.nextFloat();
                double d3 = (float)pos.func_177952_p() + this.worldObj.field_73012_v.nextFloat();
                double d4 = d - (double)this.explosionPos.func_177958_n();
                double d5 = d2 - (double)this.explosionPos.func_177956_o();
                double d6 = d3 - (double)this.explosionPos.func_177952_p();
                double d7 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5 + d6 * d6));
                d4 /= d7;
                d5 /= d7;
                d6 /= d7;
                double d8 = 0.5 / (d7 / (double)this.explosionSize + 0.1);
                this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d + (double)this.explosionPos.func_177958_n() * 1.0) / 2.0, (d2 + (double)this.explosionPos.func_177956_o() * 1.0) / 2.0, (d3 + (double)this.explosionPos.func_177952_p() * 1.0) / 2.0, d4 *= (d8 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d5 *= d8, d6 *= d8, new int[0]);
                this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d, d2, d3, d4, d5, d6, new int[0]);
            }
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            if (state.func_177230_c().func_149659_a(this.fakeExplosion)) {
                state.func_177230_c().func_180653_a(this.worldObj, pos, state, this.explosionDropRate, 0);
            }
            state.func_177230_c().onBlockExploded(this.worldObj, pos, this.fakeExplosion);
        }
    }
}

