/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.items;

import ic2.core.IC2;
import ic2.core.block.base.util.comparator.IComparator;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.item.inv.inventories.InventoryComparatorTool;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ComparatorToolComp
extends GuiComponent {
    public static final ItemStack cancelIcon = Ic2Items.displayIcons[1].func_77946_l();
    public static final ItemStack okIcon = Ic2Items.displayIcons[0].func_77946_l();
    InventoryComparatorTool tool;
    boolean superCircuit;

    public ComparatorToolComp(InventoryComparatorTool comp) {
        super(Ic2GuiComp.nullBox);
        this.tool = comp;
        this.superCircuit = Loader.isModLoaded((String)"rscircuits");
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IC2Button(0, x + 5, y + 19, 10, 10, "-"));
        gui.registerButton(new IC2Button(1, x + 80, y + 19, 10, 10, "+"));
        gui.registerButton(new IC2Button(2, x + 5, y + 34, 10, 10, "-"));
        gui.registerButton(new IC2Button(3, x + 160, y + 34, 10, 10, "+"));
        gui.registerButton(new ToggleButton(4, x + 5, y + 50, 20, 20).setIcon(new ItemStack(Items.field_151107_aW)).setState(this.tool.isStatic[this.tool.currentSelected]).addToolTip(Ic2GuiLang.staticValue));
        gui.registerButton(new ToggleButton(5, x + 30, y + 50, 20, 20).setIcon(new ItemStack(Blocks.field_150429_aA)).setState(this.tool.isInverted[this.tool.currentSelected]).addToolTip(Ic2GuiLang.invertedValue));
        if (this.superCircuit) {
            gui.registerButton(new ToggleButton(6, x + 55, y + 50, 20, 20).setIcon(new ItemStack(Items.field_151132_bS)).setState(this.tool.isByte[this.tool.currentSelected]).addToolTip(Ic2GuiLang.byteValue));
        }
        gui.registerButton(new IC2Button(7, x + 130, y + 65, 40, 10, Ic2GuiLang.saveButton));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        gui.getButton((int)0).field_146124_l = this.tool.currentSelected > 0;
        gui.getButton((int)1).field_146124_l = this.tool.currentSelected < 6;
        gui.getButton((int)2).field_146124_l = this.tool.selected[this.tool.currentSelected] != null;
        gui.getButton((int)3).field_146124_l = this.tool.ids.indexOf(this.tool.selected[this.tool.currentSelected]) < this.tool.ids.size() - 1;
        gui.getCastedButton(4, ToggleButton.class).setState(this.tool.isStatic[this.tool.currentSelected]);
        gui.getCastedButton(5, ToggleButton.class).setState(this.tool.isInverted[this.tool.currentSelected]);
        if (this.superCircuit) {
            gui.getCastedButton(6, ToggleButton.class).setState(this.tool.isByte[this.tool.currentSelected]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            --this.tool.currentSelected;
            if (this.tool.currentSelected < 0) {
                this.tool.currentSelected = 0;
            }
        } else if (id == 1) {
            ++this.tool.currentSelected;
            if (this.tool.currentSelected > 6) {
                this.tool.currentSelected = 6;
            }
        } else if (id == 2) {
            String idIndex = this.tool.selected[this.tool.currentSelected];
            if (idIndex == null) {
                return;
            }
            int slot = this.tool.ids.indexOf(idIndex);
            this.tool.selected[this.tool.currentSelected] = slot == 0 ? null : this.tool.ids.get(slot - 1);
        } else if (id == 3) {
            String idIndex = this.tool.selected[this.tool.currentSelected];
            if (idIndex == null) {
                this.tool.selected[this.tool.currentSelected] = this.tool.ids.get(0);
                return;
            }
            int slot = this.tool.ids.indexOf(idIndex);
            if (slot + 1 < this.tool.ids.size()) {
                this.tool.selected[this.tool.currentSelected] = this.tool.ids.get(slot + 1);
            }
        } else if (id == 4) {
            this.tool.isStatic[this.tool.currentSelected] = !this.tool.isStatic[this.tool.currentSelected];
        } else if (id == 5) {
            this.tool.isInverted[this.tool.currentSelected] = !this.tool.isInverted[this.tool.currentSelected];
        } else if (id == 6) {
            this.tool.isByte[this.tool.currentSelected] = !this.tool.isByte[this.tool.currentSelected];
        } else if (id == 7) {
            NBTTagCompound data = new NBTTagCompound();
            this.tool.writeToNBT(data);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("Data", (NBTBase)data);
            nbt.func_74757_a("Server", true);
            nbt.func_74783_a("Pos", new int[]{this.tool.pos.func_177958_n(), this.tool.pos.func_177956_o(), this.tool.pos.func_177952_p()});
            IC2.network.get().initiateCustomClientItemEvent(this.tool.stack, new NBTFieldPacket(nbt));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int index = this.tool.currentSelected;
        gui.drawString(Ic2GuiLang.sideInfo.getLocalizedFormatted(Ic2Lang.getFacingComp(index == 6 ? null : EnumFacing.field_82609_l[index])), 20, 20, 0x404040);
        IComparator comp = this.tool.comparators.get(this.tool.selected[index]);
        gui.drawString(Ic2GuiLang.comparatorInfo.getLocalizedFormatted(comp == null ? Ic2Lang.nothingComp : comp.getName()), 20, 35, 0x404040);
    }
}

