/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player;

import ic2.core.IC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.util.misc.StackUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerHandler {
    private static Map<UUID, PlayerHandler> handlers = new HashMap<UUID, PlayerHandler>();
    @SideOnly(value=Side.CLIENT)
    private static PlayerHandler clientHandler;
    EntityPlayer player;
    public boolean altKeyDown = false;
    public boolean boostKeyDown = false;
    public boolean forwardKeyDown = false;
    public boolean modeSwitchKeyDown = false;
    public boolean jumpKeyDown = false;
    public boolean sideinventoryKeyDown = false;
    public boolean hudModeKeyDown = false;
    public boolean toggleKeyDown = false;
    public boolean quantumArmorBoostSprint = false;
    public int quantumSpeedTicker = 0;
    public float quantumJumpCharge = 0.0f;
    public boolean windEffectsElytra = false;
    public float lastWindEffect = 0.0f;
    public TileEntity wailaWatching;
    public TileEntity watching;
    public long lastCheck = -1L;
    public int fallBack = 10;
    public boolean hasEUReader = false;
    public boolean hasThermometer = false;
    public boolean hasCropAnalyzer = false;
    public boolean hasWrench = false;

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public UUID getPlayerID() {
        return this.player != null ? this.player.func_110124_au() : null;
    }

    public void updateKeys(int keyState) {
        this.altKeyDown = (keyState & 1) != 0;
        this.boostKeyDown = (keyState & 2) != 0;
        this.forwardKeyDown = (keyState & 4) != 0;
        this.modeSwitchKeyDown = (keyState & 8) != 0;
        this.jumpKeyDown = (keyState & 0x10) != 0;
        this.sideinventoryKeyDown = (keyState & 0x20) != 0;
        this.hudModeKeyDown = (keyState & 0x40) != 0;
        this.toggleKeyDown = (keyState & 0x80) != 0;
    }

    public boolean hasThermometer() {
        this.update();
        return this.hasThermometer;
    }

    public boolean hasWrench() {
        this.update();
        return this.hasWrench;
    }

    public boolean hasCropanalyzer() {
        this.update();
        return this.hasCropAnalyzer;
    }

    public boolean hasEUReader() {
        this.update();
        return this.hasEUReader;
    }

    private void update() {
        if (this.player == null) {
            return;
        }
        if (this.lastCheck >= this.player.field_70170_p.func_82737_E()) {
            return;
        }
        this.lastCheck = this.player.field_70170_p.func_82737_E();
        this.hasEUReader = StackUtil.hasHotbarItem(this.player, CommonFilters.euReaderActive);
        this.hasCropAnalyzer = StackUtil.hasHotbarItem(this.player, CommonFilters.cropAnalyzerActive);
        this.hasThermometer = StackUtil.hasHotbarItem(this.player, CommonFilters.thermometerActive);
        this.hasWrench = StackUtil.hasHotbarItem(this.player, CommonFilters.wrenchActive);
    }

    public static PlayerHandler getHandlerForPlayer(EntityPlayer player) {
        PlayerHandler handler = handlers.get(player.func_110124_au());
        if (handler == null) {
            handler = new PlayerHandler();
            handlers.put(player.func_110124_au(), handler);
        }
        handler.player = player;
        return handler;
    }

    @SideOnly(value=Side.CLIENT)
    public static PlayerHandler getClientPlayerHandler() {
        if (clientHandler == null) {
            clientHandler = new PlayerHandler();
        }
        PlayerHandler.clientHandler.player = IC2.platform.getPlayerInstance();
        return clientHandler;
    }

    public static void onPlayerUnload(EntityPlayer player) {
        handlers.remove(player.func_110124_au());
    }

    public static void onUnload() {
        handlers.clear();
    }
}

