/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player.achievements.criteria;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

public class KilledWithItemTrigger
implements ICriterionTrigger<KillInstance> {
    private static final ResourceLocation ID = new ResourceLocation("ic2", "entity_killed_with_item");
    Map<PlayerAdvancements, Listeners> instances = new LinkedHashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<KillInstance> listener) {
        Listeners list = this.instances.get(playerAdvancementsIn);
        if (list == null) {
            list = new Listeners(playerAdvancementsIn);
            this.instances.put(playerAdvancementsIn, list);
        }
        list.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<KillInstance> listener) {
        Listeners list = this.instances.get(playerAdvancementsIn);
        if (list == null) {
            return;
        }
        if (list.remove(listener)) {
            this.instances.remove(playerAdvancementsIn);
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.instances.remove(playerAdvancementsIn);
    }

    public void onTrigger(EntityPlayerMP mp, Entity other, DamageSource source) {
        Listeners list = this.instances.get(mp.func_192039_O());
        if (list != null) {
            list.trigger(mp, other, source);
        }
    }

    public KillInstance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new KillInstance(ID, EntityPredicate.func_192481_a((JsonElement)json.get("entity")), DamageSourcePredicate.func_192447_a((JsonElement)json.get("killing_blow")), ItemPredicate.func_192492_a((JsonElement)json.get("item_used")));
    }

    public static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<KillInstance>> listeners = new LinkedHashSet<ICriterionTrigger.Listener<KillInstance>>();

        public Listeners(PlayerAdvancements player) {
            this.playerAdvancements = player;
        }

        public void add(ICriterionTrigger.Listener<KillInstance> instance) {
            this.listeners.add(instance);
        }

        public boolean remove(ICriterionTrigger.Listener<KillInstance> instance) {
            this.listeners.remove(instance);
            return this.listeners.isEmpty();
        }

        public void trigger(EntityPlayerMP mp, Entity killed, DamageSource source) {
            ArrayList<ICriterionTrigger.Listener<KillInstance>> list = new ArrayList<ICriterionTrigger.Listener<KillInstance>>();
            for (ICriterionTrigger.Listener<KillInstance> listener : this.listeners) {
                if (!((KillInstance)listener.func_192158_a()).test(mp, killed, source)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class KillInstance
    extends AbstractCriterionInstance {
        private final EntityPredicate entity;
        private final DamageSourcePredicate killingBlow;
        private final ItemPredicate predicate;

        public KillInstance(ResourceLocation id, EntityPredicate killed, DamageSourcePredicate source, ItemPredicate used) {
            super(id);
            this.entity = killed;
            this.killingBlow = source;
            this.predicate = used;
        }

        public boolean test(EntityPlayerMP player, Entity killed, DamageSource source) {
            if (!this.killingBlow.func_193418_a(player, source)) {
                return false;
            }
            if (!this.entity.func_192482_a(player, killed)) {
                return false;
            }
            return this.predicate.func_192493_a(player.func_184614_ca());
        }
    }
}

