/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.tile;

import icbm.classic.ICBMClassic;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.BlockICBM;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockExplosive
extends BlockICBM {
    public static final PropertyExplosive EX_PROP = new PropertyExplosive();

    public BlockExplosive() {
        super("explosives", Material.field_151590_u);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    public int func_180651_a(IBlockState state) {
        return ((Explosives)((Object)state.func_177229_b((IProperty)EX_PROP))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Explosives ex = Explosives.CONDENSED;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityExplosive) {
            ex = ((TileEntityExplosive)tile).explosive;
        }
        return state.func_177226_a((IProperty)EX_PROP, (Comparable)((Object)ex));
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b((IProperty)EX_PROP) != Explosives.SMINE;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(base_state, world, pos);
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b((IProperty)EX_PROP) != Explosives.SMINE;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b((IProperty)EX_PROP) != Explosives.SMINE;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_PROP, EX_PROP});
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityExplosive && ((TileEntityExplosive)tileEntity).explosive == Explosives.SMINE) {
            return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 0.2, (double)(pos.func_177952_p() + 1));
        }
        return super.func_180646_a(blockState, world, pos);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack stack = placer.func_184586_b(hand);
        return this.func_176223_P().func_177226_a((IProperty)ROTATION_PROP, (Comparable)facing).func_177226_a((IProperty)EX_PROP, (Comparable)((Object)Explosives.get(stack.func_77952_i())));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityExplosive) {
            Explosives ex;
            ((TileEntityExplosive)tile).explosive = ex = Explosives.get(itemStack.func_77952_i());
            if (world.func_175687_A(pos) > 0) {
                BlockExplosive.triggerExplosive(world, pos, ex, 0);
            }
            for (EnumFacing rotation : EnumFacing.field_176754_o) {
                Pos position = (Pos)new Pos(pos).add(rotation);
                Block blockId = position.getBlock((IBlockAccess)world);
                if (blockId != Blocks.field_150480_ab && blockId != Blocks.field_150356_k && blockId != Blocks.field_150353_l) continue;
                BlockExplosive.triggerExplosive(world, pos, ex, 2);
                break;
            }
            if (entityLiving != null) {
                ICBMClassic.logger().info("ICBMClassic>>BlockExplosive#onBlockPlacedBy: " + entityLiving.func_70005_c_() + " placed " + ex.handler.getExplosiveName() + " in: " + pos);
            }
        }
    }

    public void func_189540_a(IBlockState thisBlock, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityExplosive) {
            Explosives explosiveID = ((TileEntityExplosive)tile).explosive;
            int power = world.func_175687_A(pos);
            if (power > 0) {
                BlockExplosive.triggerExplosive(world, pos, explosiveID, 0);
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IBlockState state = world.func_180495_p(pos.func_177971_a(facing.func_176730_m()));
                Block block = state.func_177230_c();
                if (block != Blocks.field_150480_ab && block != Blocks.field_150356_k && block != Blocks.field_150353_l) continue;
                BlockExplosive.triggerExplosive(world, pos, explosiveID, 0);
                return;
            }
        }
    }

    public static void triggerExplosive(World world, BlockPos pos, Explosives explosiveID, int causeOfExplosion) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) != null && tileEntity instanceof TileEntityExplosive) {
            ((TileEntityExplosive)tileEntity).exploding = true;
            EntityExplosive eZhaDan = new EntityExplosive(world, (Pos)new Pos(pos).add(0.5), ((TileEntityExplosive)tileEntity).explosive, (byte)((TileEntityExplosive)tileEntity).getDirection().ordinal(), ((TileEntityExplosive)tileEntity).nbtData);
            switch (causeOfExplosion) {
                case 2: {
                    eZhaDan.func_70015_d(100);
                }
            }
            world.func_72838_d((Entity)eZhaDan);
            world.func_175698_g(pos);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.func_175625_s(pos) instanceof TileEntityExplosive) {
            BlockExplosive.triggerExplosive(world, pos, ((TileEntityExplosive)world.func_175625_s((BlockPos)pos)).explosive, 1);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (entityPlayer.func_184586_b(hand) != null && entityPlayer.func_184586_b(hand).func_77973_b() == Items.field_151033_d) {
            Explosives explosiveID = ((TileEntityExplosive)tileEntity).explosive;
            BlockExplosive.triggerExplosive(world, pos, explosiveID, 0);
            return true;
        }
        if (tileEntity instanceof TileEntityExplosive) {
            return ((TileEntityExplosive)tileEntity).explosive.handler.onBlockActivated(world, pos, entityPlayer, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_149708_J()) {
            for (Explosives zhaPin : Explosives.values()) {
                if (!zhaPin.handler.hasBlockForm()) continue;
                items.add((Object)new ItemStack((Block)this, 1, zhaPin.ordinal()));
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityExplosive();
    }

    public static final class PropertyExplosive
    extends PropertyEnum<Explosives> {
        public PropertyExplosive() {
            super("explosive", Explosives.class, Explosives.getBlocksOnly());
        }
    }
}

