/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MixerRecipePotion
extends MixerRecipe {
    public static final HashMap<PotionType, MixerRecipePotion> REGISTERED = new HashMap();
    public static final Set<String> BLACKLIST = new HashSet<String>();
    private final Set<Pair<FluidStack, IngredientStack[]>> alternateInputs = new HashSet<Pair<FluidStack, IngredientStack[]>>();

    public MixerRecipePotion(PotionType outputType, PotionType inputType, IngredientStack reagent) {
        super(MixerRecipePotion.getFluidStackForType(outputType, 1000), MixerRecipePotion.getFluidStackForType(inputType, 1000), new IngredientStack[]{reagent}, 6400);
    }

    public void addAlternateInput(PotionType inputType, IngredientStack reagent) {
        this.alternateInputs.add((Pair<FluidStack, IngredientStack[]>)Pair.of((Object)MixerRecipePotion.getFluidStackForType(inputType, 1000), (Object)new IngredientStack[]{reagent}));
    }

    public Set<Pair<FluidStack, IngredientStack[]>> getAlternateInputs() {
        return this.alternateInputs;
    }

    public static void registerPotionRecipe(PotionType output, PotionType input, IngredientStack reagent) {
        if (REGISTERED.containsKey(output)) {
            MixerRecipePotion recipe = REGISTERED.get(output);
            recipe.addAlternateInput(input, reagent);
        } else if (!BLACKLIST.contains(((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)output)).toString())) {
            MixerRecipePotion recipe = new MixerRecipePotion(output, input, reagent);
            MixerRecipe.recipeList.add(recipe);
            REGISTERED.put(output, recipe);
            BottlingMachineRecipe.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)output), new ItemStack(Items.field_151069_bo), MixerRecipePotion.getFluidStackForType(output, 250));
        }
    }

    public static FluidStack getFluidStackForType(PotionType type, int amount) {
        if (type == PotionTypes.field_185230_b || type == null) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        FluidStack stack = new FluidStack(IEContent.fluidPotion, amount);
        stack.tag = new NBTTagCompound();
        stack.tag.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)type)).toString());
        return stack;
    }

    @Override
    public FluidStack getFluidOutput(FluidStack input, NonNullList<ItemStack> components) {
        return super.getFluidOutput(input, components);
    }

    @Override
    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        if (super.matches(fluid, components)) {
            return true;
        }
        return this.alternateInputs.stream().anyMatch(alternate -> this.compareToInputs(fluid, components, (FluidStack)alternate.getLeft(), (IngredientStack[])alternate.getRight()));
    }

    @Override
    public int[] getUsedSlots(FluidStack fluid, NonNullList<ItemStack> components) {
        for (int i = 0; i < components.size(); ++i) {
            if (((ItemStack)components.get(i)).func_190926_b() || !BrewingRecipeRegistry.isValidIngredient((ItemStack)((ItemStack)components.get(i)))) continue;
            return new int[]{i};
        }
        return new int[0];
    }
}

