/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Refinery")
public class Refinery {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack input0, ILiquidStack input1, int energy) {
        FluidStack fOut = CraftTweakerHelper.toFluidStack(output);
        FluidStack fIn0 = CraftTweakerHelper.toFluidStack(input0);
        FluidStack fIn1 = CraftTweakerHelper.toFluidStack(input1);
        if (fOut == null || fIn0 == null || fIn1 == null) {
            return;
        }
        RefineryRecipe r = new RefineryRecipe(fOut, fIn0, fIn1, energy);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        if (CraftTweakerHelper.toFluidStack(output) != null) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toFluidStack(output)));
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack output;
        ArrayList<RefineryRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<RefineryRecipe> it = RefineryRecipe.recipeList.iterator();
            while (it.hasNext()) {
                RefineryRecipe r = it.next();
                if (r == null || !r.output.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public String describe() {
            return "Removing Refinery Recipes for " + this.output.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        private final RefineryRecipe recipe;

        public Add(RefineryRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RefineryRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Refinery Recipe for " + this.recipe.output.getLocalizedName();
        }
    }
}

