/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items;

import ic2.api.classic.reactor.IReactorPlanner;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.reactor.IReactor;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.item.reactor.base.ItemUraniumRodBase;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.items.urantypes.MOX;
import trinsdar.ic2c_extras.items.urantypes.Plutonium;
import trinsdar.ic2c_extras.items.urantypes.Thorium230;
import trinsdar.ic2c_extras.items.urantypes.Thorium232;
import trinsdar.ic2c_extras.items.urantypes.UOX;

public class ItemNuclearRod
extends ItemUraniumRodBase {
    NuclearRodTypes type;
    NuclearRodVariants variant;
    private int index;
    public static IUranium[] types = new IUranium[0];

    public ItemNuclearRod(NuclearRodTypes type, NuclearRodVariants variant) {
        this.type = type;
        this.variant = variant;
        String name = type.getPrefix() + variant.getPrefix();
        this.setRegistryName("ic2c_extras", name.toLowerCase() + "cell");
        this.func_77637_a(IC2CExtras.creativeTab);
        this.setUnlocalizedName((LocaleComp)new LangComponentHolder.LocaleItemComp("item." + name + "Cell"));
    }

    public static void init() {
        types = new IUranium[5];
        ItemNuclearRod.types[0] = new UOX();
        ItemNuclearRod.types[1] = new Plutonium();
        ItemNuclearRod.types[2] = new MOX();
        ItemNuclearRod.types[3] = new Thorium232();
        ItemNuclearRod.types[4] = new Thorium230();
        TileEntityUraniumEnricher.RECIPE_LIST.add(types[0]);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return this.getUran().getTexture(this.getRodType());
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.name;
    }

    public int getMaxCustomDamage(ItemStack stack) {
        return this.getUran().getMaxDurability();
    }

    public IUranium getUranium(ItemStack stack) {
        return this.getUran();
    }

    public IUranium.RodType getRodType(ItemStack itemStack) {
        return this.getRodType();
    }

    public ItemStack[] getSubParts() {
        return new ItemStack[0];
    }

    public boolean hasSubParts() {
        return false;
    }

    public ItemStack getReactorPart() {
        if (this.type == NuclearRodTypes.ISOTOPE) {
            return this.getUran().getNewIsotopicRod();
        }
        return this.getUran().getRodType(this.getRodType());
    }

    public short getID(ItemStack stack) {
        return this.getUran().getRodID(this.getRodType());
    }

    public IUranium.RodType getRodType(int metadata) {
        return this.getRodType();
    }

    public IUranium.RodType getRodType() {
        if (this.type == NuclearRodTypes.SINGLE) {
            return IUranium.RodType.SingleRod;
        }
        if (this.type == NuclearRodTypes.DOUBLE) {
            return IUranium.RodType.DualRod;
        }
        if (this.type == NuclearRodTypes.QUAD) {
            return IUranium.RodType.QuadRod;
        }
        if (this.type == NuclearRodTypes.ISOTOPE) {
            return IUranium.RodType.IsotopicRod;
        }
        return IUranium.RodType.SingleRod;
    }

    public IUranium getUran() {
        if (this.variant == NuclearRodVariants.UOX) {
            return types[0];
        }
        if (this.variant == NuclearRodVariants.PLUTONIUM) {
            return types[1];
        }
        if (this.variant == NuclearRodVariants.MOX) {
            return types[2];
        }
        if (this.variant == NuclearRodVariants.THORIUM232) {
            return types[3];
        }
        if (this.variant == NuclearRodVariants.THORIUM230) {
            return types[4];
        }
        return types[0];
    }

    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack itemStack) {
        if (this.type == NuclearRodTypes.ISOTOPE) {
            return IReactorPlannerComponent.ReactorType.Reactor;
        }
        return IReactorPlannerComponent.ReactorType.Both;
    }

    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack itemStack) {
        if (this.type == NuclearRodTypes.ISOTOPE) {
            return IReactorPlannerComponent.ReactorComponentType.IsotopeCell;
        }
        return IReactorPlannerComponent.ReactorComponentType.FuelRod;
    }

    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack itemStack) {
        return null;
    }

    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        IUranium uran = this.getUran();
        if (this.type == NuclearRodTypes.ISOTOPE) {
            return uran != null && stat == IReactorPlannerComponent.ReactorComponentStat.MaxDurability ? new NBTTagInt(uran.getMaxDurability()) : nulltag;
        }
        return super.getReactorStat(stat, stack);
    }

    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack itemStack) {
        return this.type != NuclearRodTypes.ISOTOPE && super.isAdvancedStat(stat, itemStack);
    }

    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        if (this.type == NuclearRodTypes.ISOTOPE) {
            return nulltag;
        }
        return super.getReactorStat(reactor, x, y, stack, stat);
    }

    public void processTick(ISteamReactor iSteamReactor, ItemStack itemStack, int i, int i1, boolean b, boolean b1) {
        if (this.type != NuclearRodTypes.ISOTOPE) {
            super.processTick(iSteamReactor, itemStack, i, i1, b, b1);
        }
    }

    public void processChamber(ItemStack itemStack, IReactor iReactor, int i, int i1, boolean b) {
        if (this.type != NuclearRodTypes.ISOTOPE) {
            super.processChamber(itemStack, iReactor, i, i1, b);
        }
    }

    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            if (this.type == NuclearRodTypes.ISOTOPE) {
                planner.addReEnrichPulse();
            } else {
                planner.addFuelPulse();
            }
        }
        IUranium uran = this.getUran();
        if (reactor instanceof ISteamReactor) {
            if (heatrun && this.type == NuclearRodTypes.ISOTOPE) {
                int myLevel = this.getCustomDamage(stack) - 1 - reactor.getHeat() / 3000;
                if (myLevel <= 0) {
                    reactor.setItemAt(youX, youY, uran.getRodType(IUranium.RodType.ReEnrichedRod));
                } else {
                    this.setCustomDamage(stack, myLevel);
                }
            }
            return true;
        }
        if (this.type == NuclearRodTypes.ISOTOPE) {
            int myLevel = this.getCustomDamage(stack) - 1 - reactor.getHeat() / 3000;
            if (myLevel <= 0) {
                reactor.setItemAt(youX, youY, uran.getRodType(IUranium.RodType.ReEnrichedRod));
            } else {
                this.setCustomDamage(stack, myLevel);
            }
        } else if (!heatrun) {
            reactor.addOutput(uran.getEUPerPulse());
        }
        return true;
    }

    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        if (this.type != NuclearRodTypes.ISOTOPE) {
            return this.getUran().getExplosionEffectModifier() * this.getRodAmount(this.type);
        }
        return 0.0f;
    }

    public int getRodAmount(ItemStack stack) {
        return (int)this.getRodAmount(this.type);
    }

    public IUranium getUranium(int i) {
        return this.getUran();
    }

    public float getRodAmount(NuclearRodTypes type) {
        if (type == NuclearRodTypes.SINGLE) {
            return 1.0f;
        }
        if (type == NuclearRodTypes.DOUBLE) {
            return 2.0f;
        }
        if (type == NuclearRodTypes.QUAD) {
            return 4.0f;
        }
        return 1.0f;
    }

    public int getTextureEntry(int i) {
        return 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            if (this.type == NuclearRodTypes.ISOTOPE) {
                items.add((Object)this.getUran().getNewIsotopicRod());
            } else {
                items.add((Object)new ItemStack((Item)this));
            }
        }
    }

    public static enum NuclearRodVariants {
        UOX("UOX"),
        PLUTONIUM("Plutonium"),
        MOX("MOX"),
        THORIUM232("Thorium232"),
        THORIUM230("Thorium230");

        private String prefix;

        private NuclearRodVariants(String name) {
            this.prefix = name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum NuclearRodTypes {
        SINGLE("single"),
        DOUBLE("double"),
        QUAD("quad"),
        ISOTOPE("isotopic");

        private String prefix;

        private NuclearRodTypes(String name) {
            this.prefix = name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

