/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.network;

import io.netty.buffer.ByteBuf;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class SwapperMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public SwapperMessage() {
        MalisisBlocks.network.registerMessage((IMessageHandler)this, Packet.class, Side.CLIENT);
    }

    public void process(Packet message, MessageContext ctx) {
        World world = IMalisisMessageHandler.getWorld((MessageContext)ctx);
        IBlockState state = Block.func_176220_d((int)message.stateId);
        world.func_175656_a(message.pos, state);
        world.func_175625_s(message.pos).func_145839_a(message.tag);
    }

    public static void sendTileEntityTag(TileEntity tileEntity) {
        MalisisBlocks.network.sendToPlayersWatchingChunk((IMessage)new Packet(tileEntity), tileEntity.func_145831_w().func_175726_f(tileEntity.func_174877_v()));
    }

    public static class Packet
    implements IMessage {
        BlockPos pos;
        int stateId;
        NBTTagCompound tag;

        public Packet() {
        }

        public Packet(TileEntity te) {
            this.pos = te.func_174877_v();
            this.stateId = Block.func_176210_f((IBlockState)te.func_145831_w().func_180495_p(te.func_174877_v()));
            this.tag = te.func_189517_E_();
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.stateId = buf.readInt();
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.stateId);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
    }
}

