/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.network.adv;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD})
public @interface NetworkField {
    public int index();

    public BitLevel compression() default BitLevel.Bit0;

    public boolean override() default false;

    public static enum BitLevel {
        Bit0(0),
        Bit8(1),
        Bit16(2),
        Bit24(3),
        Bit32(4),
        Bit40(5),
        Bit48(6),
        Bit56(7),
        Bit64(8);

        final int index;
        final long maxNumber;
        public static BitLevel[] levels;

        private BitLevel(int lvl) {
            this.index = lvl;
            this.maxNumber = 1L << lvl * 8;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isSkip() {
            return this.index == 0;
        }

        public boolean isValid(BitLevel limit) {
            if (this.index == 0) {
                return false;
            }
            return this.index < limit.index;
        }

        public long limitNumber(long input) {
            if (this.index == 0) {
                return 0L;
            }
            if (input >= this.maxNumber) {
                return this.maxNumber - 1L;
            }
            return input;
        }

        public static BitLevel getLevel(int index) {
            if (index < 0 || index > 8) {
                return Bit32;
            }
            return levels[index];
        }

        static {
            levels = new BitLevel[BitLevel.values().length];
            BitLevel[] bitLevelArray = BitLevel.values();
            int n = bitLevelArray.length;
            for (int i = 0; i < n; ++i) {
                BitLevel level;
                BitLevel.levels[level.getIndex()] = level = bitLevelArray[i];
            }
        }
    }
}

