/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.energy.tile.IEnergySourceInfo;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EmitterInfo;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityGeneratorBase
extends TileEntityMachine
implements ITickable,
IEUStorage,
IEnergySourceInfo,
IHasGui,
IEmitterTile {
    @NetworkField(index=3)
    public int fuel = 0;
    @NetworkField(index=4)
    public int storage = 0;
    @NetworkField(index=5)
    public int maxStorage;
    @NetworkField(index=6)
    public int production;
    public int tier = 1;
    public int ticksSinceLastActiveUpdate = random.nextInt(this.getDelay());
    public int activityMeter = 0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSource = null;

    public TileEntityGeneratorBase(int slots) {
        super(slots);
        this.addGuiFields("fuel", "storage");
        this.addInfos(new EnergyInfo(this), new SourceTierInfo(this), new EmitterInfo(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("Fuel");
        this.storage = nbt.func_74762_e("Storage");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("Storage", this.storage);
        return nbt;
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    public abstract ResourceLocation getTexture();

    public abstract Box2D getEnergyBox();

    public Vec2i getEnergyPos() {
        return Ic2GuiComp.machineProgressPos;
    }

    @Override
    public int getOutput() {
        return this.production;
    }

    @Override
    public int getStoredEU() {
        return this.storage;
    }

    @Override
    public int getMaxEU() {
        return this.maxStorage;
    }

    public void func_73660_a() {
        if (this.needsFuel() && this.gainFuel()) {
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        int oldEnergy = this.storage;
        boolean active = this.gainEnergy();
        if (this.storage > 0) {
            if (this.inventory.size() > 0 && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                this.storage = (int)((double)this.storage - ElectricItem.manager.charge((ItemStack)this.inventory.get(0), this.storage, this.tier, false, false));
            }
            if (this.storage > this.maxStorage) {
                this.storage = this.maxStorage;
            }
        }
        if (!this.delayActiveUpdate()) {
            this.setActive(active);
        } else {
            if (this.ticksSinceLastActiveUpdate % this.getDelay() == 0) {
                this.setActive(this.activityMeter > 0);
                this.activityMeter = 0;
            }
            this.activityMeter = active ? ++this.activityMeter : --this.activityMeter;
            ++this.ticksSinceLastActiveUpdate;
        }
        if (oldEnergy != this.storage) {
            this.getNetwork().updateTileGuiField(this, "storage");
        }
        this.updateComparators();
    }

    public boolean delayActiveUpdate() {
        return false;
    }

    public int getDelay() {
        return 256;
    }

    public boolean needsFuel() {
        return this.fuel <= 0 && this.storage + this.production <= this.maxStorage;
    }

    public boolean isConverting() {
        return this.fuel > 0 && this.storage + this.production <= this.maxStorage;
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.storage += this.production;
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            return true;
        }
        return false;
    }

    public abstract boolean gainFuel();

    public int getEnergyLevel(int lvl) {
        return (int)((double)this.storage / (double)this.maxStorage * (double)lvl);
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") && this.isActiveChanged()) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSource == null && this.getOperationSoundFile() != null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getOperationSoundFile(), true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public ResourceLocation getOperationSoundFile() {
        return null;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.9f;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.storage, this.production);
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage = (int)((double)this.storage - amount);
        this.getNetwork().updateTileGuiField(this, "storage");
    }

    @Override
    public int getMaxSendingEnergy() {
        return this.production + 1;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return this.getFacing() != facing;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }
}

