/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.reactor.IChamberReactor;
import ic2.api.classic.reactor.IReactorProduct;
import ic2.api.reactor.IBaseReactorComponent;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.reactor.IReactorComponent;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.IHasComparator;
import ic2.core.block.base.util.comparator.comparators.ComporatorReactorHeat;
import ic2.core.block.base.util.info.ReactorHeat;
import ic2.core.block.generator.container.ContainerNuclearReactor;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.explosion.ExplosionIC2;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ReactorFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.management.misc.ModularReactorSlot;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class TileEntityNuclearReactorBase
extends TileEntityMachine
implements ITickable,
IChamberReactor,
IHasGui {
    @NetworkField(index=3)
    public float output = 0.0f;
    @NetworkField(index=4)
    public int heat = 0;
    public int maxHeat = 10000;
    public float hem = 1.0f;
    public AudioSource audioSourceMain = null;
    public AudioSource audioSourceGeiger = null;
    public long lastCheck = -1L;
    public int size = 3;
    static int[][] slotArray;
    public boolean reactorPowered = false;
    public boolean didAddSomething = true;
    public boolean refreshRequest = false;
    List<IHasComparator> chambers = new LinkedList<IHasComparator>();

    public TileEntityNuclearReactorBase() {
        super(54);
        this.addInfos(new ReactorHeat(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        int[] slots = MathUtil.fromTo(0, 54);
        handler.registerModularSlot(RotationList.ALL, new ModularReactorSlot(this));
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, slots);
        handler.registerInputFilter(new ReactorFilter(this), slots);
        handler.registerSlotType(SlotType.Reactor, slots);
        handler.dissableSlotModifiers();
        handler.dissableRotation();
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComporatorReactorHeat(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("ReactorHeat");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ReactorHeat", this.heat);
        return nbt;
    }

    @Override
    public void setFacing(EnumFacing face) {
    }

    @Override
    public EnumFacing getFacing() {
        return EnumFacing.NORTH;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    private int[][] createSlots() {
        int[][] array = new int[10][];
        for (int size = 1; size < 10; ++size) {
            array[size] = new int[6 * size];
            int slot = 0;
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < size; ++x) {
                    array[size][slot] = x + y * 9;
                    ++slot;
                }
            }
        }
        return array;
    }

    public int[] getSlotArray() {
        if (slotArray == null) {
            slotArray = this.createSlots();
        }
        return slotArray[this.getReactorSize()];
    }

    @Override
    public void refreshChambers() {
        this.refreshRequest = true;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerNuclearReactor(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_82737_E() % (long)this.getTickRate() != 0L) {
            return;
        }
        if (!this.field_145850_b.func_175697_a(this.field_174879_c, 2)) {
            this.output = 0.0f;
        } else {
            this.handleRedstone();
            this.reactorPowered = this.isRedstonePowered();
            this.dropUselessItems();
            this.output = 0.0f;
            this.maxHeat = 10000;
            this.hem = 1.0f;
            this.processChambers();
            if (this.calculateHeatEffects()) {
                return;
            }
            this.setActive(this.heat >= 1000 || this.output > 0.0f);
            this.getNetwork().updateTileEntityField(this, "heat");
            this.updateComparators();
        }
        this.getNetwork().updateTileEntityField(this, "output");
    }

    @Override
    public void updateComparators() {
        super.updateComparators();
        for (IHasComparator com : this.chambers) {
            ComparatorManager manager = com.getManager();
            if (manager == null) continue;
            manager.update();
        }
    }

    public boolean calculateHeatEffects() {
        Material mat;
        BlockPos nextPos;
        if (this.isRendering()) {
            return false;
        }
        if (this.heat < 4000) {
            return false;
        }
        if (IC2.config.getFloat("explosionPowerReactorMax") <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        Random rand = this.field_145850_b.field_73012_v;
        if (power >= 0.85f && rand.nextFloat() <= 0.2f * this.hem && (nextPos = this.getRandomPos(rand, 2)) != null) {
            IBlockState state = this.field_145850_b.func_180495_p(nextPos);
            if (state.func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175656_a(nextPos, Blocks.field_150480_ab.func_176223_P());
            } else {
                float hardness = state.func_185887_b(this.field_145850_b, nextPos);
                if (hardness >= 0.0f && hardness <= 10.0f && this.field_145850_b.func_175625_s(this.field_174879_c) == null) {
                    Material mat2 = state.func_185904_a();
                    if (mat2 == Material.field_151576_e || mat2 == Material.field_151573_f || mat2 == Material.field_151587_i || mat2 == Material.field_151578_c || mat2 == Material.field_151571_B) {
                        this.field_145850_b.func_180501_a(nextPos, Blocks.field_150356_k.func_176203_a(15), 3);
                    } else {
                        this.field_145850_b.func_175656_a(nextPos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        if (power >= 7.0f) {
            List base = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0));
            for (EntityLivingBase entity : base) {
                entity.func_70097_a((DamageSource)IC2DamageSource.radiation, (float)rand.nextInt(4) * this.hem);
            }
        }
        if (power >= 5.0f && rand.nextFloat() <= this.hem && (nextPos = this.getRandomPos(rand, 2)) != null && this.field_145850_b.func_180495_p(nextPos).func_185904_a() == Material.field_151586_h) {
            this.field_145850_b.func_175698_g(nextPos);
        }
        if (power >= 4.0f && rand.nextFloat() <= this.hem && (nextPos = this.getRandomPos(rand, 2)) != null && ((mat = this.field_145850_b.func_180495_p(nextPos).func_185904_a()) == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151580_n)) {
            this.field_145850_b.func_175656_a(nextPos, Blocks.field_150480_ab.func_176223_P());
        }
        return false;
    }

    public BlockPos getRandomPos(Random rand, int radius) {
        int z;
        int y;
        if (radius <= 0) {
            return null;
        }
        int x = rand.nextInt(2 * radius + 1) - radius;
        BlockPos nextPos = this.field_174879_c.func_177982_a(x, y = rand.nextInt(2 * radius + 1) - radius, z = rand.nextInt(2 * radius + 1) - radius);
        if (this.field_174879_c.equals((Object)nextPos)) {
            return null;
        }
        return nextPos;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < size; ++x) {
                    ItemStack thing = this.getMatrixItem(x, y);
                    if (thing.func_190926_b() || !(thing.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)thing.func_77973_b();
                    comp.processChamber(thing, this, x, y, pass == 0);
                }
            }
        }
    }

    public void dropUselessItems() {
        int size = this.getReactorSize();
        if (!this.didAddSomething) {
            return;
        }
        this.didAddSomething = false;
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack stack = this.getMatrixItem(x, y);
                if (stack.func_190926_b() || x < size && this.isUsefullItem(stack, false)) continue;
                this.eject(stack);
                this.setMatrixItem(x, y, ItemStack.field_190927_a);
            }
        }
    }

    public void eject(ItemStack stack) {
        if (this.isRendering()) {
            return;
        }
        StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), stack);
    }

    public boolean isUsefullItem(ItemStack stack, boolean insert) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (insert) {
            if (item instanceof IBaseReactorComponent) {
                return ((IBaseReactorComponent)item).canBePlacedIn(stack, this);
            }
            return false;
        }
        if (item instanceof IReactorComponent) {
            return true;
        }
        if (item instanceof IReactorProduct) {
            return ((IReactorProduct)item).isProduct(stack);
        }
        return false;
    }

    @Override
    public TileEntity getCoreTe() {
        return this;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int newHeat) {
        this.heat = newHeat;
    }

    @Override
    public int addHeat(int amount) {
        return this.heat += amount;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public void addEmitHeat(int heat) {
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.output;
    }

    @Override
    public float addOutput(float energy) {
        return this.output += energy;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getMatrixItem(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setMatrixItem(x, y, item);
    }

    public void setMatrixItem(int x, int y, ItemStack item) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return;
        }
        this.setStackInSlot(y * 9 + x, item);
    }

    public ItemStack getMatrixItem(int x, int y) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return ItemStack.field_190927_a;
        }
        return this.getStackInSlot(y * 9 + x);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        int size = this.getReactorSize();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                ItemStack stack = this.getMatrixItem(x, y);
                if (stack.func_77973_b() instanceof IReactorComponent) {
                    float f = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(stack, this);
                    if (f > 0.0f && f < 1.0f) {
                        boomMod *= f;
                    } else {
                        boomPower += f;
                    }
                }
                this.setMatrixItem(x, y, ItemStack.field_190927_a);
            }
        }
        IC2.log.info("Nuclear Reactor at " + this.field_145850_b.field_73011_w.getDimension() + ":(" + this.field_174879_c.func_177958_n() + "," + this.field_174879_c.func_177956_o() + "," + this.field_174879_c.func_177952_p() + ") melted (explosion power " + (boomPower *= this.hem * boomMod) + ")");
        float maxPower = IC2.config.getFloat("explosionPowerReactorMax");
        if (boomPower > maxPower) {
            boomPower = maxPower;
        }
        for (Direction direction : Direction.directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IReactor)) continue;
            this.field_145850_b.func_175698_g(target.func_174877_v());
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, new Vec3d((Vec3i)this.field_174879_c), boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
        for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_186662_g((double)(IC2.platform.getServer().func_184103_al().func_72372_a() - 32)))) {
            this.issueAchievement(player);
        }
    }

    public void issueAchievement(EntityPlayer player) {
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public boolean produceEnergy() {
        return this.reactorPowered;
    }

    @Override
    public boolean isFluidCooled() {
        return false;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        if (stack != null) {
            this.didAddSomething = true;
        }
    }

    @Override
    public int getReactorSize() {
        if (this.func_145830_o() && (this.lastCheck < this.func_145831_w().func_82737_E() || this.refreshRequest)) {
            this.updateReactorSize();
        }
        return this.size;
    }

    @Override
    public int getSlotCountX() {
        return this.getReactorSize();
    }

    @Override
    public int getSlotCountY() {
        return 6;
    }

    public void updateReactorSize() {
        this.refreshRequest = false;
        this.lastCheck = this.func_145831_w().func_82737_E() + 20L;
        int lastSize = this.size;
        this.size = 3;
        this.chambers.clear();
        for (Direction dir : Direction.directions) {
            IHasComparator comp;
            TileEntity tile = dir.applyToTileEntity(this);
            if (!this.isValidChamber(tile)) continue;
            ++this.size;
            if (!(tile instanceof IHasComparator) || (comp = (IHasComparator)tile).getManager() == null) continue;
            this.chambers.add(comp);
        }
        if (lastSize != this.size) {
            this.didAddSomething = true;
            if (this.size < lastSize) {
                for (int x = this.size; x < 9; ++x) {
                    for (int y = 0; y < 6; ++y) {
                        ItemStack stack = this.getStackInSlot(y * 9 + x);
                        if (stack.func_190926_b()) continue;
                        this.eject(stack);
                        this.setStackInSlot(y * 9 + x, ItemStack.field_190927_a);
                    }
                }
            }
            this.getHandler().onSlotChange();
        }
    }

    public boolean isValidChamber(TileEntity tile) {
        return tile instanceof IReactorChamber;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }
}

