/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.item.IFoamProvider;
import ic2.api.classic.item.IFuelableItem;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.classic.tile.machine.ISpeedMachine;
import ic2.api.energy.EnergyNet;
import ic2.api.item.ICustomDamageItem;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.comparator.comparators.ComparatorSpeed;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.SpeedInfo;
import ic2.core.block.machine.med.container.ContainerVacuumCanner;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityVacuumCanner
extends TileEntityElecMachine
implements ITickable,
ISpeedMachine,
IProgressMachine,
IOutputMachine,
IHasGui {
    public int progress = 0;
    public int speed = 0;
    public static final int maxSpeed = 10000;
    public int fuelQuality = 0;
    public int step = 0;
    public int lastMode = 0;
    public int ticker = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    @NetworkField(index=7)
    public int energyConsume;
    @NetworkField(index=8)
    public int operationLength;
    @NetworkField(index=9)
    public float soundLevel;
    @NetworkField(index=10)
    public boolean redstoneInverted;
    @NetworkField(index=11)
    public boolean redstoneSensitive;
    public boolean defaultSensitive;
    public boolean isProcessing;
    public IFilter filter;

    public TileEntityVacuumCanner() {
        super(8, 128);
        this.setFuelSlot(0);
        this.energyConsume = 15;
        this.defaultEnergyConsume = 15;
        this.operationLength = 3000;
        this.defaultOperationLength = 3000;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = 45000;
        this.defaultSensitive = true;
        this.ticker = IC2.random.nextInt(100);
        this.addNetworkFields("redstoneInverted", "redstoneSensitive", "soundLevel");
        this.addGuiFields("operationLength", "energyConsume", "progress", "speed");
        this.addInfos(new ProgressInfo(this), new SpeedInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        this.filter = new MachineFilter(this);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1, 2, 3, 4);
        handler.registerDefaultSlotAccess(AccessRule.Export, 5);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerInputFilter(CommonFilters.CannerInput, 1);
        handler.registerInputFilter(this.filter, 2, 3, 4);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerDefaultSlotsForSide(RotationList.UP, 2, 3, 4);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 1, 5);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerSlotType(SlotType.SecondInput, 2, 3, 4);
        handler.registerSlotType(SlotType.Input, 1);
        handler.registerSlotType(SlotType.Output, 5);
        handler.registerSlotType(SlotType.Discharge, 0);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorSpeed(this));
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public float getMaxSpeed() {
        return 10000.0f;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return this.getMaxRecipeProgress();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
        this.speed = nbt.func_74762_e("Speed");
        this.step = nbt.func_74762_e("Step");
        this.lastMode = nbt.func_74762_e("LastMode");
        this.fuelQuality = nbt.func_74762_e("Fuel");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("Speed", this.speed);
        nbt.func_74768_a("Step", this.step);
        nbt.func_74768_a("LastMode", this.lastMode);
        nbt.func_74768_a("Fuel", this.fuelQuality);
        return nbt;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.vacuumCanner;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        boolean canOperate;
        if (this.ticker++ % 20 == 0) {
            this.sortInventory();
        }
        this.handleRedstone();
        this.updateNeighbors();
        int mode = this.getMode();
        boolean canWork = this.canWork() || mode != 0 && this.energy > 0;
        boolean bl = canOperate = this.canOperate(mode) && canWork;
        if (canWork || mode != 0) {
            this.handleChargeSlot(this.operationLength * this.energyConsume);
        }
        if ((canWork || mode != 0) && this.energy > 0) {
            if (this.speed < 10000) {
                ++this.speed;
                this.getNetwork().updateTileGuiField(this, "speed");
            }
            this.useEnergy(1);
        } else if (this.speed > 0) {
            this.speed -= Math.min(this.speed, 4);
            this.getNetwork().updateTileGuiField(this, "speed");
        }
        if (canOperate && this.energy >= this.energyConsume) {
            this.setActive(true);
            this.isProcessing = true;
            this.progress += this.speed / 30;
            this.useEnergy(this.energyConsume);
            if (mode == 1 && this.progress >= this.getFoodValue((ItemStack)this.inventory.get(2)) * 800) {
                this.operate(false, mode);
                this.progress = 0;
                this.notifyNeighbors();
            } else if (mode == 2) {
                if (this.step < 9 && this.progress / 800 > this.step) {
                    this.operate(true, mode);
                    ++this.step;
                } else if (this.step == 9 && this.progress / 800 > this.step) {
                    this.operate(false, mode);
                    this.fuelQuality = 0;
                    this.step = 0;
                    this.progress = 0;
                    this.notifyNeighbors();
                }
            } else if ((mode == 3 || mode == 4 || mode == 5) && this.progress >= 1200) {
                this.operate(false, mode);
                this.progress = 0;
                this.notifyNeighbors();
            }
            this.getNetwork().updateTileGuiField(this, "progress");
        } else {
            if (mode == 0 && this.progress != 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField(this, "progress");
            }
            if (!canWork || this.energy < 0) {
                this.setActive(true);
            }
            this.isProcessing = false;
        }
        if (canWork && this.energy > 0) {
            this.setActive(true);
        }
        if (this.lastMode != mode) {
            if (this.lastMode == 2) {
                this.fuelQuality = 0;
                this.step = 0;
            }
            this.lastMode = mode;
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, this);
        }
        this.updateComparators();
    }

    public void operate(boolean incremental, int mode) {
        if (mode == 1) {
            int food = this.getFoodValue((ItemStack)this.inventory.get(2));
            int meta = this.getFoodMeta((ItemStack)this.inventory.get(2));
            if (((ItemStack)this.inventory.get(2)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(2))) {
                this.inventory.set(2, (Object)((ItemStack)this.inventory.get(2)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(2)));
            } else if (((ItemStack)this.inventory.get(2)).func_77973_b() instanceof ItemSoup) {
                this.inventory.set(2, (Object)new ItemStack(Items.field_151054_z));
            } else {
                ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            }
            ((ItemStack)this.inventory.get(1)).func_190918_g(food);
            if (((ItemStack)this.inventory.get(5)).func_190926_b()) {
                this.inventory.set(5, (Object)StackUtil.copyWithDamageAndSize(Ic2Items.filledTinCan, meta, food));
            } else {
                ((ItemStack)this.inventory.get(5)).func_190917_f(food);
            }
        } else if (mode == 2) {
            int fuel = this.getFuelValue((ItemStack)this.inventory.get(2));
            ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            this.fuelQuality += fuel;
            if (incremental) {
                return;
            }
            if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IFuelableItem)) {
                this.fuelQuality = 0;
                this.step = 0;
                return;
            }
            IFuelableItem item = (IFuelableItem)((ItemStack)this.inventory.get(1)).func_77973_b();
            ItemStack newItem = item.fill(((ItemStack)this.inventory.get(1)).func_77946_l(), this.fuelQuality);
            if (((ItemStack)this.inventory.get(1)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(1))) {
                this.inventory.set(1, (Object)ItemStack.field_190927_a);
            } else {
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            }
            this.inventory.set(5, (Object)newItem);
        } else if (mode == 3) {
            int amount = this.getPelletValue((ItemStack)this.inventory.get(2));
            ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            IFoamProvider prov = (IFoamProvider)((ItemStack)this.inventory.get(1)).func_77973_b();
            prov.fillFoam((ItemStack)this.inventory.get(1), amount);
            int left = prov.getFreeRoom((ItemStack)this.inventory.get(1));
            if (left < amount) {
                this.inventory.set(5, this.inventory.get(1));
            }
        } else if (mode == 4) {
            boolean full;
            Tuple<IRecipeInput, Integer> result = ClassicRecipes.canningMachine.getRepairResult((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), false);
            ItemStack toRepair = (ItemStack)this.inventory.get(1);
            if (result == null || !(toRepair.func_77973_b() instanceof ICustomDamageItem)) {
                return;
            }
            ((ItemStack)this.inventory.get(2)).func_190918_g(((IRecipeInput)result.func_76341_a()).getAmount());
            ICustomDamageItem item = (ICustomDamageItem)toRepair.func_77973_b();
            int change = (Integer)result.func_76340_b();
            int max = item.getMaxCustomDamage(toRepair);
            int current = item.getCustomDamage(toRepair);
            boolean bl = change > 0 ? current >= max : (full = (current += change) <= 0);
            if (current > max) {
                current = max;
            } else if (current < 0) {
                current = 0;
            }
            item.setCustomDamage(toRepair, current);
            if (full) {
                this.inventory.set(5, this.inventory.get(1));
            }
        } else if (mode == 5) {
            Tuple<IRecipeInput, ItemStack> result = ClassicRecipes.canningMachine.getCanningResult((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), true);
            if (result == null) {
                return;
            }
            ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            ((ItemStack)this.inventory.get(2)).func_190918_g(((IRecipeInput)result.func_76341_a()).getAmount());
            if (((ItemStack)this.inventory.get(5)).func_190926_b()) {
                this.inventory.set(5, (Object)((ItemStack)result.func_76340_b()).func_77946_l());
            } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(5), (ItemStack)result.func_76340_b(), false, false)) {
                ((ItemStack)this.inventory.get(5)).func_190917_f(((ItemStack)result.func_76340_b()).func_190916_E());
            }
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onProcessFinished(item, this);
        }
    }

    public boolean canOperate(int mode) {
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return false;
        }
        if (mode == 0) {
            return false;
        }
        if (mode == 1) {
            int food = this.getFoodValue((ItemStack)this.inventory.get(2));
            return food > 0 && food <= ((ItemStack)this.inventory.get(1)).func_190916_E() && (((ItemStack)this.inventory.get(5)).func_190926_b() || ((ItemStack)this.inventory.get(5)).func_77973_b() == Ic2Items.filledTinCan.func_77973_b() && ((ItemStack)this.inventory.get(5)).func_77960_j() == this.getFoodMeta((ItemStack)this.inventory.get(2)) && ((ItemStack)this.inventory.get(5)).func_190916_E() + food <= ((ItemStack)this.inventory.get(5)).func_77976_d());
        }
        if (mode == 2) {
            return this.getFuelValue((ItemStack)this.inventory.get(2)) > 0 && ((ItemStack)this.inventory.get(5)).func_190926_b();
        }
        if (mode == 3) {
            int amount = this.getPelletValue((ItemStack)this.inventory.get(5));
            if (amount > 0 && ((IFoamProvider)((ItemStack)this.inventory.get(1)).func_77973_b()).getFreeRoom((ItemStack)this.inventory.get(1)) >= amount && ((ItemStack)this.inventory.get(5)).func_190926_b()) {
                return true;
            }
        } else {
            if (mode == 4) {
                return ((ItemStack)this.inventory.get(5)).func_190926_b() && ClassicRecipes.canningMachine.getRepairResult((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), false) != null;
            }
            if (mode == 5) {
                Tuple<IRecipeInput, ItemStack> result = ClassicRecipes.canningMachine.getCanningResult((ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), false);
                if (result == null) {
                    return false;
                }
                if (this.inventory.get(5) == null || StackUtil.isStackEqual((ItemStack)this.inventory.get(5), (ItemStack)result.func_76340_b(), false, false) && ((ItemStack)this.inventory.get(5)).func_190916_E() + ((ItemStack)result.func_76340_b()).func_190916_E() <= ((ItemStack)this.inventory.get(5)).func_77976_d()) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getMode() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return 0;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.tinCan)) {
            return 1;
        }
        if (((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IFuelableItem && ((IFuelableItem)((ItemStack)this.inventory.get(1)).func_77973_b()).canFill((ItemStack)this.inventory.get(1))) {
            return 2;
        }
        if (((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IFoamProvider) {
            return 3;
        }
        if (((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICustomDamageItem) {
            return 4;
        }
        if (ClassicRecipes.canningMachine.hasCanningContainer((ItemStack)this.inventory.get(1))) {
            return 5;
        }
        return 0;
    }

    public int getFoodValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.func_77973_b() instanceof ItemFood) {
            return (int)Math.ceil((double)((ItemFood)item.func_77973_b()).func_150905_g(item) / 2.0);
        }
        if (item.func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150414_aQ)) {
            return 6;
        }
        return 0;
    }

    public int getFoodMeta(ItemStack item) {
        if (item == null) {
            return 0;
        }
        return ClassicRecipes.canningMachine.getEffectForItem(item);
    }

    public int getFuelValue(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        ICannerRegistry.FuelInfo info = ClassicRecipes.canningMachine.getFuelInfo(stack);
        if (info == null) {
            return 0;
        }
        if (info.getAmount() > 0) {
            return info.getAmount();
        }
        if ((double)info.getMultiplier() > 0.0) {
            return (int)((double)this.fuelQuality * (double)info.getMultiplier());
        }
        return 0;
    }

    public int getPelletValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (StackUtil.isStackEqual(item, Ic2Items.constructionFoamPellet)) {
            return 26;
        }
        return 0;
    }

    private void sortInventory() {
        for (int i = 2; i < 4; ++i) {
            int left;
            if (((ItemStack)this.inventory.get(i)).func_190926_b() && !((ItemStack)this.inventory.get(i + 1)).func_190926_b()) {
                this.inventory.set(i, this.inventory.get(i + 1));
                this.inventory.set(i + 1, (Object)ItemStack.field_190927_a);
                continue;
            }
            if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(i), (ItemStack)this.inventory.get(i + 1), false, false) || (left = ((ItemStack)this.inventory.get(i)).func_77976_d() - ((ItemStack)this.inventory.get(i)).func_190916_E()) <= 0) continue;
            if (left >= ((ItemStack)this.inventory.get(i + 1)).func_190916_E()) {
                ((ItemStack)this.inventory.get(i)).func_190917_f(((ItemStack)this.inventory.get(i + 1)).func_190916_E());
                this.inventory.set(i + 1, (Object)ItemStack.field_190927_a);
                continue;
            }
            ((ItemStack)this.inventory.get(i)).func_190917_f(((ItemStack)this.inventory.get(i)).func_77976_d());
            ((ItemStack)this.inventory.get(i + 1)).func_190918_g(left);
        }
    }

    public boolean canWork() {
        if (!this.redstoneSensitive) {
            return true;
        }
        return this.isRedstonePowered();
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstoneInverted) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return true;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
        if (this.redstoneSensitive != active) {
            this.redstoneSensitive = active;
        }
    }

    @Override
    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    @Override
    public boolean isProcessing() {
        return this.isProcessing;
    }

    @Override
    public World getMachineWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1.func_190926_b()) {
            return false;
        }
        int mode = this.getMode();
        if (mode == 0) {
            if (par1.func_77973_b() instanceof IFuelableItem) {
                return ((IFuelableItem)par1.func_77973_b()).canFill(par1);
            }
            if (par1.func_77973_b() instanceof IFoamProvider) {
                return ((IFoamProvider)par1.func_77973_b()).getFreeRoom(par1) > 0;
            }
            return StackUtil.isStackEqual(par1, Ic2Items.tinCan);
        }
        if (mode == 1) {
            return this.getFoodValue(par1) > 0;
        }
        if (mode == 2) {
            ICannerRegistry.FuelInfo info = ClassicRecipes.canningMachine.getFuelInfo(par1);
            if (info == null) {
                return false;
            }
            return info.getAmount() > 0 || info.getMultiplier() > 0.0f;
        }
        if (mode == 3) {
            return this.getPelletValue(par1) > 0;
        }
        if (mode == 4) {
            return ClassicRecipes.canningMachine.getRepairResult((ItemStack)this.inventory.get(1), par1, true) != null;
        }
        if (mode == 5) {
            return ClassicRecipes.canningMachine.getCanningResult((ItemStack)this.inventory.get(1), par1, true) != null;
        }
        return false;
    }

    @Override
    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper(this, 5);
    }

    @Override
    public IHasInventory getInputInventory() {
        IFilter[] array = new IFilter[4];
        array[0] = CommonFilters.CannerInput;
        array[2] = array[3] = this.filter;
        array[1] = array[3];
        return new RangedInventoryWrapper(this, 1, 2, 3, 4).addFilters(array);
    }

    @Override
    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        HashSet<IMachineUpgradeItem.UpgradeType> set = new HashSet<IMachineUpgradeItem.UpgradeType>(Arrays.asList(IMachineUpgradeItem.UpgradeType.values()));
        set.remove((Object)IMachineUpgradeItem.UpgradeType.MachineModifierA);
        return set;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerVacuumCanner(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.CannerGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = this.defaultSensitive;
        for (int i = 0; i < 2; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraProcessTime += upgrade.getExtraProcessTime(item, this) * item.func_190916_E();
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(item, this), item.func_190916_E());
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.func_190916_E();
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.func_190916_E());
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.func_190916_E());
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, this), item.func_190916_E()));
            extraTier += upgrade.getExtraTier(item, this) * item.func_190916_E();
            if (!upgrade.useRedstoneInverter(item, this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.energyConsume = TileEntityVacuumCanner.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.operationLength = TileEntityVacuumCanner.applyModifier(this.defaultOperationLength, extraProcessTime, processTimeMultiplier);
        this.setMaxEnergy(TileEntityVacuumCanner.applyModifier(this.defaultEnergyStorage, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.maxInput < 0) {
            this.maxInput = Integer.MAX_VALUE;
        }
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        this.soundLevel = soundModfier;
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        if (this.energyConsume < 1) {
            this.energyConsume = 1;
        }
        this.getNetwork().updateTileEntityField(this, "redstoneInverted");
        this.getNetwork().updateTileEntityField(this, "redstoneSensitive");
        this.getNetwork().updateTileEntityField(this, "soundLevel");
        this.getNetwork().updateTileGuiField(this, "operationLength");
        this.getNetwork().updateTileGuiField(this, "energyConsume");
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }

    public int getMaxRecipeProgress() {
        switch (this.getMode()) {
            case 1: {
                return 800 * this.getFoodValue((ItemStack)this.inventory.get(2));
            }
            case 2: {
                return 8000;
            }
            case 3: {
                return 1200;
            }
            case 4: {
                return 1200;
            }
            case 5: {
                return 1200;
            }
        }
        return 0;
    }
}

