/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.buttons;

import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.IToolTipButton;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.textures.Ic2Icons;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;

public class ToggleButton
extends IC2Button
implements IToolTipButton {
    List<LocaleComp>[] toolTips = this.createList(2);
    LocaleComp[] comps = new LocaleComp[2];
    ItemStack[] icons = new ItemStack[2];
    boolean[] showNames = new boolean[]{true, true};
    boolean isOn;
    boolean single;
    boolean forcedRender = false;

    public ToggleButton(int buttonId, int x, int y, int widthIn, int heightIn) {
        super(buttonId, x, y, widthIn, heightIn, "");
    }

    public ToggleButton setIcons(ItemStack off, ItemStack on) {
        this.icons[0] = off;
        this.icons[1] = on;
        this.single = false;
        return this;
    }

    public ToggleButton setIcon(ItemStack stack) {
        this.icons[0] = stack;
        this.icons[1] = stack;
        this.single = true;
        return this;
    }

    public ToggleButton setForcedIcon(ItemStack stack) {
        this.icons[0] = stack;
        this.icons[1] = stack;
        this.single = true;
        this.forcedRender = true;
        return this;
    }

    public ToggleButton setNames(LocaleComp off, LocaleComp on) {
        this.comps[0] = off;
        this.comps[1] = on;
        return this;
    }

    public ToggleButton setState(boolean on) {
        this.isOn = on;
        return this;
    }

    public ToggleButton setTextVisiblity(boolean off, boolean on) {
        this.showNames[0] = off;
        this.showNames[1] = on;
        return this;
    }

    public ToggleButton addToolTip(boolean on, LocaleComp comp) {
        int value = on ? 1 : 0;
        this.showNames[value] = false;
        this.toolTips[value].add(comp);
        return this;
    }

    public ToggleButton addToolTip(boolean on, List<LocaleComp> comp) {
        int value = on ? 1 : 0;
        this.showNames[value] = false;
        this.toolTips[value].addAll(comp);
        return this;
    }

    public ToggleButton addToolTip(List<LocaleComp> comp) {
        this.showNames[0] = false;
        this.showNames[1] = false;
        this.toolTips[0].addAll(comp);
        this.toolTips[1].addAll(comp);
        return this;
    }

    public ToggleButton addToolTip(LocaleComp comp) {
        this.showNames[0] = false;
        this.showNames[1] = false;
        this.toolTips[0].add(comp);
        this.toolTips[1].add(comp);
        return this;
    }

    public boolean isPressed() {
        return this.isOn;
    }

    @Override
    public LocaleComp getName() {
        return this.comps[this.isOn ? 1 : 0];
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float ticks) {
        int value = this.isOn ? 1 : 0;
        this.setTextVisiblity(this.showNames[value]);
        GlStateManager.func_179140_f();
        super.func_191745_a(mc, mouseX, mouseY, ticks);
        ItemStack stack = this.icons[value];
        if (stack != null && this.field_146125_m) {
            if (this.single) {
                TextureManager textureManager = mc.func_110434_K();
                mc.func_147117_R();
                textureManager.func_110577_a(TextureMap.field_110575_b);
                if (this.forcedRender) {
                    GlStateManager.func_179126_j();
                    RenderHelper.func_74520_c();
                    mc.func_175599_af().func_180450_b(stack, this.field_146128_h + 2, this.field_146129_i + 2);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                } else {
                    TextureAtlasSprite sprite = mc.func_175599_af().func_184393_a(stack, null, null).func_177554_e();
                    this.func_175175_a(this.field_146128_h + 2, this.field_146129_i + 2, sprite, this.field_146120_f - 4, this.field_146121_g - 4);
                }
                TextureAtlasSprite theSprite = Ic2Icons.getTextures("Gui")[this.isOn ? 0 : 1];
                this.field_73735_i += 1000.0f;
                this.func_175175_a(this.field_146128_h + this.field_146120_f - 10, this.field_146129_i + this.field_146121_g - 10, theSprite, this.field_146120_f - 12, this.field_146121_g - 12);
                this.field_73735_i -= 1000.0f;
            } else if (this.field_146120_f == 20 && this.field_146121_g == 20) {
                GlStateManager.func_179126_j();
                RenderHelper.func_74520_c();
                mc.func_175599_af().func_180450_b(stack, this.field_146128_h + 2, this.field_146129_i + 2);
                RenderHelper.func_74519_b();
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
            } else {
                TextureAtlasSprite sprite = mc.func_175599_af().func_184393_a(stack, null, null).func_177554_e();
                TextureManager textureManager = mc.func_110434_K();
                mc.func_147117_R();
                textureManager.func_110577_a(TextureMap.field_110575_b);
                this.func_175175_a(this.field_146128_h + 2, this.field_146129_i + 2, sprite, this.field_146120_f - 4, this.field_146121_g - 4);
            }
        }
    }

    @Override
    public void addToolTips(GuiIC2 gui, int mouseX, int mouseY, List<String> toolTip) {
        if (this.field_146123_n && this.field_146125_m) {
            int value;
            int n = value = this.isOn ? 1 : 0;
            if (this.showNames[value]) {
                return;
            }
            LocaleComp text = this.comps[value];
            if (text != null) {
                toolTip.add(text.getLocalized());
            }
            for (LocaleComp comp : this.toolTips[value]) {
                toolTip.add(comp.getLocalized());
            }
        }
    }

    private List<LocaleComp>[] createList(int count) {
        List[] data = new List[count];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ArrayList();
        }
        return data;
    }
}

