/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropSeed;
import ic2.core.IC2;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.machine.low.TileEntitySeedManager;
import ic2.core.block.machine.low.logic.crops.CropSorters;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.inventory.slots.SlotDisplay;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SeedManagerComp
extends GuiComponent {
    TileEntitySeedManager manager;

    public SeedManagerComp(TileEntitySeedManager tile) {
        super(Ic2GuiComp.nullBox);
        this.manager = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.MouseClick, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        if (this.manager.sorting) {
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            gui.func_73729_b(x - 73, y + 90, 176, 0, 74, 44);
        }
        for (int i = 0; i < 5; ++i) {
            int index = this.manager.currentIndex * 5 + i;
            if (index >= this.manager.syncer.size()) continue;
            Tuple<ItemStack, CropCard> entry = this.manager.syncer.getEntry(index);
            this.drawTopTab(gui, 20 + i * 28, -28, (ItemStack)entry.func_76341_a(), entry.func_76340_b() == this.manager.getCurrentCrop());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        ItemStack stack = this.getCrop(gui.getSlotUnderMouse());
        if (!stack.func_190926_b()) {
            ICropSeed seed = (ICropSeed)stack.func_77973_b();
            CropCard card = seed.getCropFromStack(stack);
            gui.drawString(Ic2Crops.instance.getCropName(card), 5, 5, 0xFFFFFF);
            gui.drawString(Ic2GuiLang.cropTier.getLocalizedFormatted(card.getProperties().getTier()), 5, 15, 0xFFFFFF);
            gui.drawString(Ic2GuiLang.cropGrowth.getLocalized() + " " + seed.getGrowthFromStack(stack), 5, 30, 11403055);
            gui.drawString(Ic2GuiLang.cropGain.getLocalized() + " " + seed.getGainFromStack(stack), 5, 40, 15649024);
            gui.drawString(Ic2GuiLang.cropResistance.getLocalized() + " " + seed.getResistanceFromStack(stack), 5, 50, 52945);
            int count = StackUtil.getNbtData(stack).func_74762_e("CropCount");
            if (count > 255) {
                gui.drawString(Ic2GuiLang.cropCount.getLocalizedFormatted(Ic2GuiLang.enough), 5, 65, 0xFFFFFF);
                return;
            }
            gui.drawString(Ic2GuiLang.cropCount.getLocalizedFormatted(count), 5, 65, 0xFFFFFF);
        }
        if (this.manager.sorting) {
            gui.drawString(CropSorters.instance.getSorterName(this.manager.comparator), -70, 95, 0x404040);
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseClick(GuiIC2 gui, int mouseX, int mouseY, int mouseButton) {
        for (int i = 0; i < 5; ++i) {
            int index = this.manager.currentIndex * 5 + i;
            if (index >= this.manager.syncer.size()) {
                return false;
            }
            int xPos = 20 + i * 28;
            if (mouseY < -28 || mouseY > 0 || mouseX < xPos || mouseX > xPos + 28) continue;
            IC2.audioManager.playOnce(this.manager, SoundEvents.field_187909_gi.func_187503_a());
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 1, i);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        int index;
        for (int i = 0; i < 5 && (index = this.manager.currentIndex * 5 + i) < this.manager.syncer.size(); ++i) {
            int xPos = 20 + i * 28;
            if (mouseY < -28 || mouseY > 0 || mouseX < xPos || mouseX > xPos + 28) continue;
            tooltips.add(((ItemStack)this.manager.syncer.getEntry(index).func_76341_a()).func_82833_r());
        }
    }

    public ItemStack getCrop(Slot slot) {
        ItemStack stack;
        if (slot instanceof SlotDisplay && (stack = slot.func_75211_c()).func_77973_b() instanceof ICropSeed) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IC2Button(0, x + 3, y - 22, 15, 20, "<"));
        gui.registerButton(new IC2Button(1, x + 162, y - 22, 15, 20, ">"));
        gui.registerButton(new IC2Button(2, x + 80, y + 125, 20, 10, "D"));
        gui.registerButton(new IC2Button(3, x + 105, y + 125, 20, 10, "U"));
        gui.registerButton(new ToggleButton(4, x + 5, y + 92, 20, 20).setState(this.manager.sorting).setIcon(new ItemStack(Items.field_151132_bS)).addToolTip(Ic2GuiLang.sort));
        if (this.manager.sorting) {
            gui.registerButton(new IC2Button(5, x - 69, y + 115, 30, 13, Ic2GuiLang.next));
            gui.registerButton(new ToggleButton(6, x - 30, y + 110, 20, 20).setState(this.manager.inverted).setIcon(new ItemStack(Blocks.field_150429_aA)).addToolTip(Ic2GuiLang.upgradeInvert));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        int amount;
        gui.getCastedButton(4, ToggleButton.class).setState(this.manager.sorting);
        if (this.manager.sorting) {
            gui.getCastedButton(6, ToggleButton.class).setState(this.manager.inverted);
        }
        if (gui.getSlotUnderMouse() instanceof SlotDisplay && (double)(amount = Mouse.getDWheel()) != 0.0) {
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 2, -(amount / 120));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0 || id == 1) {
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 0, id == 1 ? 1 : -1);
        } else if (id == 2 || id == 3) {
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 2, id == 2 ? 1 : -1);
        } else if (id == 4) {
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 4, 0);
        } else if (id == 5) {
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 5, 0);
        } else if (id == 6) {
            this.manager.getNetwork().initiateClientTileEntityEvent(this.manager, 4, 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawTopTab(GuiIC2 gui, int xOffset, int yOffset, ItemStack item, boolean enabled) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        RenderItem render = gui.getRenderItem();
        GL11.glPushMatrix();
        gui.func_73729_b(x + xOffset, y + yOffset, enabled ? 28 : 0, 222, 28, enabled ? 31 : 28);
        RenderHelper.func_74520_c();
        gui.setZLevel(200);
        render.field_77023_b = 200.0f;
        render.func_180450_b(item, x + xOffset + 6, y + yOffset + 8);
        gui.setZLevel(0);
        render.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GlStateManager.func_179144_i((int)gui.getTextureObject().func_110552_b());
    }
}

