/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport.wrapper;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import net.minecraft.item.ItemStack;

public class RangedInventoryWrapper
implements IHasInventory {
    IHasInventory inv;
    int[] slots;
    IFilter[] filter;

    public RangedInventoryWrapper(IHasInventory inventory, int ... slotIndexes) {
        this.inv = inventory;
        this.slots = slotIndexes;
    }

    public RangedInventoryWrapper addFilters(IFilter[] array) {
        this.filter = array;
        return this;
    }

    public RangedInventoryWrapper setFilters(IFilter filters) {
        this.filter = new IFilter[this.slots.length];
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i] = filters;
        }
        return this;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.setStackInSlot(this.slots[slot], stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(this.slots[slot]);
    }

    @Override
    public int getSlotCount() {
        return this.slots.length;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return this.inv.getMaxStackSize(this.slots[slot]);
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        if (this.filter == null || this.filter.length <= slot || this.filter[slot] == null) {
            return true;
        }
        return this.filter[slot].matches(stack);
    }
}

