/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.item.reactor.ItemReactorHeatStorageBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.ItemStackCoord;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;

public class ItemHeatSwitch
extends ItemReactorHeatStorageBase
implements IBootable {
    Map<Integer, SwitchProperty> prop = new HashMap<Integer, SwitchProperty>();

    public ItemHeatSwitch() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.heatSwitches);
    }

    @Override
    public void onLoad() {
        this.prop.put(0, new SwitchProperty(16, Ic2ItemLang.heatSwitch, 2500, 12, 4, 27));
        this.prop.put(1, new SwitchProperty(17, Ic2ItemLang.heatSwitchCore, 5000, 0, 72, 28));
        this.prop.put(2, new SwitchProperty(18, Ic2ItemLang.heatSwitchSpread, 5000, 36, 0, 29));
        this.prop.put(3, new SwitchProperty(19, Ic2ItemLang.heatSwitchAdvanced, 10000, 24, 8, 30));
        Ic2Items.reactorHeatSwitch = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorHeatSwitchCore = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorHeatSwitchGold = new ItemStack((Item)this, 1, 2);
        Ic2Items.reactorHeatSwitchDiamond = new ItemStack((Item)this, 1, 3);
    }

    @Override
    public List<Integer> getValidVariants() {
        return this.getSortedList();
    }

    public List<Integer> getSortedList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.prop.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public int getTextureEntry(int meta) {
        SwitchProperty entry = this.prop.get(meta);
        if (entry != null) {
            return entry.getTexture();
        }
        return 0;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        SwitchProperty entry = this.prop.get(stack.func_77960_j());
        if (entry != null) {
            return entry.getName();
        }
        return super.getLangComponent(stack);
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        SwitchProperty entry = this.prop.get(stack.func_77960_j());
        if (entry != null) {
            return entry.getHeatSotrage();
        }
        return 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Integer meta : this.getSortedList()) {
            items.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
        }
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        this.processChamber(yourStack, reactor, x, y, heatrun);
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        SwitchProperty switchProp = this.prop.get(stack.func_77960_j());
        if (switchProp == null) {
            return;
        }
        int side = switchProp.getSelf();
        int react = switchProp.getReactor();
        int myHeat = 0;
        ArrayList<ItemStackCoord> heatAcceptors = new ArrayList<ItemStackCoord>();
        double med = (double)this.getCurrentHeat(stack, reactor, x, y) / (double)this.getMaxHeat(stack, reactor, x, y);
        int c = 1;
        if (react > 0) {
            ++c;
            med += (double)reactor.getHeat() / (double)reactor.getMaxHeat();
        }
        if (side > 0) {
            med += this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            med += this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            med += this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            med += this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
        }
        med /= (double)(c + heatAcceptors.size());
        if (side > 0) {
            for (ItemStackCoord stackcoord : heatAcceptors) {
                IReactorComponent heatable = (IReactorComponent)stackcoord.stack.func_77973_b();
                int add = (int)(med * (double)heatable.getMaxHeat(stackcoord.stack, reactor, stackcoord.x, stackcoord.y) - (double)heatable.getCurrentHeat(stackcoord.stack, reactor, stackcoord.x, stackcoord.y));
                if (add > side) {
                    add = side;
                }
                if (add < -side) {
                    add = -side;
                }
                myHeat -= add;
                add = heatable.alterHeat(stackcoord.stack, reactor, stackcoord.x, stackcoord.y, add);
                myHeat += add;
            }
        }
        if (react > 0) {
            int add = (int)(med * (double)reactor.getMaxHeat() - (double)reactor.getHeat());
            if (add > react) {
                add = react;
            }
            if (add < -react) {
                add = -react;
            }
            myHeat -= add;
            reactor.setHeat(reactor.getHeat() + add);
        }
        this.alterHeat(stack, reactor, x, y, myHeat);
    }

    private double checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList<ItemStackCoord> heatAcceptors) {
        IReactorComponent comp;
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing.func_77973_b() instanceof IReactorComponent && (comp = (IReactorComponent)thing.func_77973_b()).canStoreHeat(thing, reactor, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
            double max = comp.getMaxHeat(thing, reactor, x, y);
            if (max <= 0.0) {
                return 0.0;
            }
            double cur = comp.getCurrentHeat(thing, reactor, x, y);
            return cur / max;
        }
        return 0.0;
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[this.prop.size()];
        int step = 0;
        for (Integer meta : this.getSortedList()) {
            items[step] = new ItemStack((Item)this, 1, meta.intValue());
            ++step;
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return ItemStack.field_190927_a;
    }

    @Override
    public short getID(ItemStack stack) {
        SwitchProperty info = this.prop.get(stack.func_77960_j());
        if (info == null) {
            return 0;
        }
        return info.getPlannerID();
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.HeatSwitch;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        SwitchProperty info = this.prop.get(stack.func_77960_j());
        if (info != null) {
            if (stat == IReactorPlannerComponent.ReactorComponentStat.ReactorChange) {
                return new NBTTagInt(info.getReactor());
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.PartChange) {
                return new NBTTagInt(info.getSelf());
            }
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }

    public static class SwitchProperty {
        public int texture;
        public LocaleComp name;
        public int heatSotrage;
        public int reactor;
        public int self;
        public short id;

        public SwitchProperty(int textureID, LocaleComp unlocalizedName, int max, int switchSelf, int switchReactor, int plannerID) {
            this.texture = textureID;
            this.name = unlocalizedName;
            this.heatSotrage = max;
            this.reactor = switchReactor;
            this.self = switchSelf;
            this.id = (short)plannerID;
        }

        public short getPlannerID() {
            return this.id;
        }

        public LocaleComp getName() {
            return this.name;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getHeatSotrage() {
            return this.heatSotrage;
        }

        public int getReactor() {
            return this.reactor;
        }

        public int getSelf() {
            return this.self;
        }
    }
}

