/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.client;

import ic2.core.IC2;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FieldRequestPacket
extends IC2Packet {
    int dimID;
    BlockPos pos;
    UUID id;

    public FieldRequestPacket() {
    }

    public FieldRequestPacket(TileEntity tile, UUID player) {
        this.dimID = tile.func_145831_w().field_73011_w.getDimension();
        this.pos = tile.func_174877_v();
        this.id = player;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        this.pos = BlockPos.func_177969_a((long)par1.readLong());
        long most = par1.readLong();
        long least = par1.readLong();
        this.id = new UUID(most, least);
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeLong(this.pos.func_177986_g());
        par1.writeLong(this.id.getMostSignificantBits());
        par1.writeLong(this.id.getLeastSignificantBits());
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet was sended Wrong: " + this.dimID + ":" + this.pos);
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile != null) {
            if (!par1.func_110124_au().equals(this.id)) {
                par1 = world.func_152378_a(this.id);
            }
            if (par1 == null) {
                return;
            }
            IC2.network.get(true).sendInitialData((EntityPlayerMP)par1, tile);
        }
    }
}

