/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import tinker_io.network.MessageEmptyTank;
import tinker_io.network.NetworkHandler;
import tinker_io.registry.BlockRegistry;
import tinker_io.tileentity.TileEntitySmartOutput;

public class GuiSmartOutput
extends GuiContainer {
    public static final int BUTTON_EMPTY_TANK = 0;
    private InventoryPlayer playerInv;
    private TileEntitySmartOutput tile;
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("tinker_io", "textures/gui/smart_output.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 166;
    private GuiButton buttonEmptyTank;

    public GuiSmartOutput(Container container, TileEntitySmartOutput tile, InventoryPlayer playerInv) {
        super(container);
        this.playerInv = playerInv;
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonEmptyTank = new GuiButton(0, this.field_147003_i - 20, this.field_147009_r + this.field_147000_g - 150, 20, 20, ""){

            public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                GuiSmartOutput.this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 178, 82, 20, 20);
            }
        };
        this.field_146292_n.add(this.buttonEmptyTank);
        this.buttonEmptyTank.field_146124_l = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int progress = this.tile.getProgress(24);
        this.func_73729_b(this.field_147003_i + 93, this.field_147009_r + 33, 176, 0, progress + 1, 17);
        if (this.tile.isCanControlledByRedstone()) {
            if (!this.tile.canWork()) {
                this.func_73729_b(this.field_147003_i + 119, this.field_147009_r + 55, 176, 18, 22, 20);
                this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 32, 176, 60, 26, 20);
            } else {
                this.func_73729_b(this.field_147003_i + 120, this.field_147009_r + 55, 177, 39, 21, 20);
            }
        }
        if (this.tile.getCurrentMode() == 1) {
            this.func_73729_b(this.field_147003_i + 77, this.field_147009_r + 52, 177, 104, 16, 16);
            this.func_73729_b(this.field_147003_i + 59, this.field_147009_r + 52, 177, 121, 16, 16);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        FluidStack fluid = this.tile.getFluid();
        int fluidAmount = this.tile.getFluidBarHeight(52);
        if (fluid != null) {
            GuiUtil.renderTiledFluid((int)(this.field_147003_i + 26), (int)(this.field_147009_r + 15 + 52 - fluidAmount), (int)12, (int)fluidAmount, (float)this.field_73735_i, (FluidStack)fluid);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        List<String> tooltip;
        String name = I18n.func_135052_a((String)(BlockRegistry.smartOutput.func_149739_a() + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94, 0x404040);
        int outputSize = this.tile.getMaxOutputStackSize();
        this.field_146289_q.func_78276_b(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tio.gui.SO.max_output", (Object[])new Object[0]) + outputSize, 100, 17, 0x404040);
        FluidStack fluid = this.tile.getFluid();
        if (fluid != null && (tooltip = GuiSmartOutput.getTankTooltip((IFluidTank)this.tile.getTank(), fluid, mouseX, mouseY, this.field_147003_i + 26, this.field_147009_r + 15, this.field_147003_i + 38, this.field_147009_r + 67)) != null) {
            this.func_146283_a(tooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.buttonEmptyTank.field_146124_l = Util.isShiftKeyDown();
        if (this.buttonEmptyTank.func_146115_a()) {
            String[] desc = new String[]{TextFormatting.RED + I18n.func_135052_a((String)"tio.gui.SO.toolTips.button_head", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"tio.gui.SO.toolTips.button_info", (Object[])new Object[0])};
            List<String> temp = Arrays.asList(desc);
            this.drawHoveringText(temp, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.tile.emptyTank();
                NetworkHandler.sendToServer(new MessageEmptyTank(this.tile.func_174877_v()));
                break;
            }
        }
    }

    private static List<String> getTankTooltip(IFluidTank tank, FluidStack fluid, int mouseX, int mouseY, int xmin, int ymin, int xmax, int ymax) {
        if (xmin <= mouseX && mouseX < xmax && ymin <= mouseY && mouseY < ymax) {
            Consumer<Integer> stringFn;
            FluidStack hovered = fluid;
            ArrayList text = Lists.newArrayList();
            Consumer<Integer> consumer = stringFn = Util.isShiftKeyDown() ? i -> GuiUtil.amountToString((int)i, (List)text) : i -> GuiUtil.amountToIngotString((int)i, (List)text);
            if (hovered == null) {
                int usedCap = tank.getFluidAmount();
                int maxCap = tank.getCapacity();
                text.add(TextFormatting.WHITE + Util.translate((String)"gui.smeltery.capacity", (Object[])new Object[0]));
                stringFn.accept(maxCap);
                text.add(Util.translateFormatted((String)"gui.smeltery.capacity_available", (Object[])new Object[0]));
                stringFn.accept(maxCap - usedCap);
                text.add(Util.translateFormatted((String)"gui.smeltery.capacity_used", (Object[])new Object[0]));
                stringFn.accept(usedCap);
                if (!Util.isShiftKeyDown()) {
                    text.add("");
                    text.add(Util.translate((String)"tooltip.tank.holdShift", (Object[])new Object[0]));
                }
            } else {
                text.add(TextFormatting.WHITE + hovered.getLocalizedName());
                GuiUtil.liquidToString((FluidStack)hovered, (List)text);
            }
            return text;
        }
        return null;
    }
}

