/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.plugins.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import tinker_io.gui.GuiFuelInputMachine;
import tinker_io.gui.GuiOreCrusher;
import tinker_io.gui.GuiSmartOutput;
import tinker_io.helper.OreCrusherRecipe;
import tinker_io.plugins.jei.fuelInputMachine.FuelInputMachineRecipeCategory;
import tinker_io.plugins.jei.fuelInputMachine.FuelInputMachineRecipeChecker;
import tinker_io.plugins.jei.fuelInputMachine.FuelInputMachineRecipeHandler;
import tinker_io.plugins.jei.fuelInputMachine.FuelInputMachineRecipeWrapper;
import tinker_io.plugins.jei.oreCrusher.OreCrusherRecipeCategory;
import tinker_io.plugins.jei.oreCrusher.OreCrusherRecipeHandler;
import tinker_io.plugins.jei.smartOutput.SmartOutputRecipeCategory;
import tinker_io.plugins.jei.smartOutput.SmartOutputRecipeChecker;
import tinker_io.plugins.jei.smartOutput.SmartOutputRecipeHandler;
import tinker_io.plugins.jei.smartOutput.SmartOutputRecipeWrapper;
import tinker_io.registry.BlockRegistry;
import tinker_io.registry.OreCrusherRecipeRegister;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static ICraftingGridHelper craftingGridHelper;
    public static IRecipeRegistry recipeRegistry;
    public static OreCrusherRecipeCategory oreCrusherRecipeCategory;
    public static SmartOutputRecipeCategory smartOutputRecipeCategory;
    public static FuelInputMachineRecipeCategory fuelInputMachineRecipeCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        oreCrusherRecipeCategory = new OreCrusherRecipeCategory(guiHelper);
        smartOutputRecipeCategory = new SmartOutputRecipeCategory(guiHelper);
        fuelInputMachineRecipeCategory = new FuelInputMachineRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{oreCrusherRecipeCategory, smartOutputRecipeCategory, fuelInputMachineRecipeCategory});
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.handleRecipes(OreCrusherRecipe.class, (IRecipeWrapperFactory)new OreCrusherRecipeHandler(), OreCrusherRecipeCategory.CATEGORY);
        registry.addRecipes(OreCrusherRecipeRegister.oreCrusherRecipes, OreCrusherRecipeCategory.CATEGORY);
        registry.handleRecipes(SmartOutputRecipeWrapper.class, (IRecipeWrapperFactory)new SmartOutputRecipeHandler(), SmartOutputRecipeCategory.CATEGORY);
        registry.addRecipes(SmartOutputRecipeChecker.getCastingRecipes(), SmartOutputRecipeCategory.CATEGORY);
        registry.handleRecipes(FuelInputMachineRecipeWrapper.class, (IRecipeWrapperFactory)new FuelInputMachineRecipeHandler(), FuelInputMachineRecipeCategory.CATEGORY);
        registry.addRecipes(FuelInputMachineRecipeChecker.getFuel(), FuelInputMachineRecipeCategory.CATEGORY);
        registry.addRecipeClickArea(GuiOreCrusher.class, 82, 35, 24, 15, new String[]{OreCrusherRecipeCategory.CATEGORY});
        registry.addRecipeClickArea(GuiSmartOutput.class, 94, 34, 24, 15, new String[]{SmartOutputRecipeCategory.CATEGORY});
        registry.addRecipeClickArea(GuiFuelInputMachine.class, 102, 35, 18, 18, new String[]{FuelInputMachineRecipeCategory.CATEGORY});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.fuelInputMachine), new String[]{FuelInputMachineRecipeCategory.CATEGORY});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.smartOutput), new String[]{SmartOutputRecipeCategory.CATEGORY});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.oreCrusher), new String[]{OreCrusherRecipeCategory.CATEGORY});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }
}

