/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.foci;

import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.lib.utils.BlockUtils;

public class FocusEffectDislocate
extends FocusEffect {
    private static final String TAG_AVAILABLE = "available";
    private static final String TAG_TILE_CMP = "tileCmp";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_META = "blockMeta";

    public boolean execute(RayTraceResult rayTraceResult, @Nullable Trajectory trajectory, float v, int i) {
        if (rayTraceResult == null) {
            return false;
        }
        if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = rayTraceResult.func_178782_a();
        IBlockState blockState = this.getPackage().world.func_180495_p(pos);
        TileEntity tileEntity = this.getPackage().world.func_175625_s(pos);
        ItemStack casterStack = ItemStack.field_190927_a;
        if (this.getPackage().getCaster().func_184614_ca() != null && this.getPackage().getCaster().func_184614_ca().func_77973_b() instanceof ItemCaster) {
            casterStack = this.getPackage().getCaster().func_184614_ca();
        } else if (this.getPackage().getCaster().func_184592_cb() != null && this.getPackage().getCaster().func_184592_cb().func_77973_b() instanceof ItemCaster) {
            casterStack = this.getPackage().getCaster().func_184592_cb();
        }
        if (casterStack == null) {
            return false;
        }
        if (casterStack == ItemStack.field_190927_a) {
            return false;
        }
        ItemStack focus = ((ItemCaster)casterStack.func_77973_b()).getFocusStack(casterStack);
        if (this.getPackage().getCaster() instanceof EntityPlayer && ((EntityPlayer)this.getPackage().getCaster()).func_175151_a(pos, rayTraceResult.field_178784_b, casterStack)) {
            IBlockState stateStored = this.getStoredState(focus);
            if (stateStored != null) {
                switch (rayTraceResult.field_178784_b) {
                    case UP: {
                        pos = pos.func_177984_a();
                        break;
                    }
                    case DOWN: {
                        pos = pos.func_177977_b();
                        break;
                    }
                    case NORTH: {
                        pos = pos.func_177978_c();
                        break;
                    }
                    case EAST: {
                        pos = pos.func_177974_f();
                        break;
                    }
                    case SOUTH: {
                        pos = pos.func_177968_d();
                        break;
                    }
                    case WEST: {
                        pos = pos.func_177976_e();
                    }
                }
                if (blockState.func_177230_c().func_176198_a(this.getPackage().world, pos, rayTraceResult.field_178784_b) && !this.getPackage().world.field_72995_K) {
                    this.getPackage().world.func_180501_a(pos, stateStored, 3);
                    NBTTagCompound tileCmp = this.getStackTileEntity(focus);
                    if (tileCmp != null && !tileCmp.func_82582_d()) {
                        TileEntity tile1 = TileEntity.func_190200_a((World)this.getPackage().world, (NBTTagCompound)tileCmp);
                        tile1.func_174878_a(pos);
                        this.getPackage().world.func_175690_a(pos, tile1);
                    }
                    stateStored.func_177230_c().func_180633_a(this.getPackage().world, pos, stateStored, this.getPackage().getCaster(), new ItemStack(stateStored.func_177230_c()));
                    this.clearPickedBlock(focus);
                }
            } else if (!(blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getPackage().world, pos) || BlockUtils.isPortableHoleBlackListed((IBlockState)blockState) || this.getPackage().world.field_72995_K)) {
                this.storePickedBlock(blockState, pos, tileEntity, focus);
                if (tileEntity != null) {
                    this.getPackage().world.func_175713_t(pos);
                }
                this.getPackage().world.func_175698_g(pos);
            }
        }
        return false;
    }

    private void storePickedBlock(IBlockState blockState, BlockPos pos, TileEntity tileEntity, ItemStack focus) {
        ResourceLocation blockName = blockState.func_177230_c().getRegistryName();
        int metadata = blockState.func_177230_c().func_176201_c(blockState);
        ItemNBTHelper.setString(focus, TAG_BLOCK_NAME, blockName.toString());
        ItemNBTHelper.setInteger(focus, TAG_BLOCK_META, metadata);
        NBTTagCompound cmp = new NBTTagCompound();
        if (tileEntity != null) {
            tileEntity.func_189515_b(cmp);
        }
        ItemNBTHelper.getItemTag(focus).func_74782_a(TAG_TILE_CMP, (NBTBase)cmp);
        ItemNBTHelper.setBool(focus, TAG_AVAILABLE, true);
    }

    private void clearPickedBlock(ItemStack focus) {
        ItemNBTHelper.setBool(focus, TAG_AVAILABLE, false);
        ItemNBTHelper.getItemTag(focus).func_82580_o(TAG_TILE_CMP);
        ItemNBTHelper.getItemTag(focus).func_82580_o(TAG_BLOCK_NAME);
        ItemNBTHelper.getItemTag(focus).func_82580_o(TAG_BLOCK_META);
    }

    private NBTTagCompound getStackTileEntity(ItemStack focus) {
        NBTTagCompound cmp;
        if (ItemNBTHelper.getItemTag(focus).func_74764_b(TAG_TILE_CMP) && (cmp = ItemNBTHelper.getItemTag(focus).func_74775_l(TAG_TILE_CMP)).func_186856_d() != 0) {
            return cmp;
        }
        return null;
    }

    private IBlockState getStoredState(ItemStack focus) {
        if (!ItemNBTHelper.getBool(focus, TAG_AVAILABLE, false)) {
            return null;
        }
        ResourceLocation location = new ResourceLocation(ItemNBTHelper.getString(focus, TAG_BLOCK_NAME, "minecraft:air"));
        int metadata = ItemNBTHelper.getInteger(focus, TAG_BLOCK_META, 0);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        IBlockState state = block.func_176203_a(metadata);
        return state;
    }

    public void renderParticleFX(World world, double v, double v1, double v2, double v3, double v4, double v5) {
    }

    public int getComplexity() {
        return 1;
    }

    public Aspect getAspect() {
        return Aspect.AIR;
    }

    public String getKey() {
        return "dislocation";
    }

    public String getResearch() {
        return "FIRSTSTEPS";
    }
}

