/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.packets;

import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityEnchanter;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRemoveEnchant
implements IMessage {
    private BlockPos pos;
    private int enchantID;

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public int getEnchantID() {
        return this.enchantID;
    }

    public void setEnchantID(int enchantID) {
        this.enchantID = enchantID;
    }

    public PacketRemoveEnchant() {
    }

    public PacketRemoveEnchant(TileEntityEnchanter enchanter, int enchantID) {
        this.pos = enchanter.func_174877_v();
        this.enchantID = enchantID;
    }

    public PacketRemoveEnchant(BlockPos pos, int enchantID) {
        this.pos = pos;
        this.enchantID = enchantID;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = BlockPos.func_177969_a((long)byteBuf.readLong());
        this.enchantID = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeLong(this.pos.func_177986_g());
        byteBuf.writeInt(this.enchantID);
    }

    public static class Handler
    implements IMessageHandler<PacketRemoveEnchant, IMessage> {
        public IMessage onMessage(PacketRemoveEnchant packetAddEnchant, MessageContext messageContext) {
            FMLCommonHandler.instance().getWorldThread(messageContext.netHandler).func_152344_a(() -> this.handle(packetAddEnchant, messageContext));
            return null;
        }

        private void handle(PacketRemoveEnchant packetAddEnchant, MessageContext ctx) {
            TileEntity te;
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            if (world.func_175667_e(packetAddEnchant.getPos()) && (te = world.func_175625_s(packetAddEnchant.getPos())) instanceof TileEntityEnchanter) {
                TileEntityEnchanter enchanter = (TileEntityEnchanter)te;
                enchanter.removeEnchant(enchanter.getEnchantments().indexOf(packetAddEnchant.enchantID));
                enchanter.removeLevel(enchanter.getEnchantments().indexOf(packetAddEnchant.enchantID));
            }
        }
    }
}

