/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.proxy;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.render.CamoBlockColor;
import omtteam.openmodularturrets.blocks.BlockBaseAddon;
import omtteam.openmodularturrets.blocks.LeverBlock;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.client.render.models.TurretBaseBakedModel;
import omtteam.openmodularturrets.client.render.renderers.blockitem.TileEntityRenderers;
import omtteam.openmodularturrets.client.render.renderers.projectiles.ProjectileRenderers;
import omtteam.openmodularturrets.handler.OMTConfigHandler;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.init.ModItems;
import omtteam.openmodularturrets.init.ModTESRItems;
import omtteam.openmodularturrets.items.AddonMetaItem;
import omtteam.openmodularturrets.items.AmmoMetaItem;
import omtteam.openmodularturrets.items.IntermediateProductRegular;
import omtteam.openmodularturrets.items.IntermediateProductTiered;
import omtteam.openmodularturrets.items.UpgradeMetaItem;
import omtteam.openmodularturrets.items.UsableMetaItem;
import omtteam.openmodularturrets.proxy.CommonProxy;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString().toLowerCase()));
    }

    private void registerItemModel(Item item, int meta, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(item.getRegistryName().toString().toLowerCase()), variantName));
    }

    private void registerItemModel(Item item, int meta, String customName, boolean useCustomName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("openmodularturrets".toLowerCase() + ":" + customName.toLowerCase()));
    }

    private void registerBlockModelAsItem(Block block, int meta, String blockName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("openmodularturrets".toLowerCase() + ":" + blockName, "inventory"));
    }

    private void registerBlockModelAsItem(Block block, int meta, String blockName, String variantName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("openmodularturrets".toLowerCase() + ":" + blockName, variantName));
    }

    @Override
    public void init() {
        super.init();
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new CamoBlockColor(), new Block[]{ModBlocks.turretBase});
    }

    @Override
    public void initModelLoaders() {
        int i;
        StateMap ignoreRotation = new StateMap.Builder().func_178442_a(new IProperty[]{LeverBlock.ROTATION}).func_178441_a();
        StateMap ignoreConcealed = new StateMap.Builder().func_178442_a(new IProperty[]{BlockAbstractTurretHead.CONCEALED}).func_178441_a();
        StateMap ignoreFacing = new StateMap.Builder().func_178442_a(new IProperty[]{BlockBaseAddon.FACING}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.leverBlock, (IStateMapper)ignoreRotation);
        if (OMTConfigHandler.getDisposableTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.disposableItemTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getGrenadeTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.grenadeLauncherTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getTeleporterTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.teleporterTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getIncendiaryTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.incendiaryTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getLaserTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.laserTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getRailgunTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.railGunTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getRelativisticTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.relativisticTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getRocketTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.rocketTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getGunTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.machineGunTurret, (IStateMapper)ignoreConcealed);
        }
        if (OMTConfigHandler.getPotatoCannonTurretSettings().isEnabled()) {
            ModelLoader.setCustomStateMapper((Block)ModBlocks.potatoCannonTurret, (IStateMapper)ignoreConcealed);
        }
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new TurretBaseBakedModel.ModelLoader());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.turretBase, (IStateMapper)new TurretBaseBakedModel.Statemapper());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.baseAddon, (IStateMapper)ignoreFacing);
        for (i = 0; i < 5; ++i) {
            this.registerBlockModelAsItem(ModBlocks.turretBase, i, "turret_base_normal", "tier=" + (i + 1));
        }
        for (i = 0; i < 10; ++i) {
            this.registerBlockModelAsItem(ModBlocks.expander, i, "expander", "facing=north,meta=" + i);
        }
        for (i = 0; i < 1; ++i) {
            this.registerBlockModelAsItem(ModBlocks.baseAddon, i, "base_addon", "facing=north,model=" + i);
        }
        for (i = 0; i < 15; ++i) {
            this.registerItemModel(ModItems.intermediateProductTiered, i, IntermediateProductTiered.subNames[i], true);
        }
        for (i = 0; i < 8; ++i) {
            this.registerItemModel(ModItems.addonMetaItem, i, AddonMetaItem.subNames[i], true);
        }
        for (i = 0; i < 5; ++i) {
            this.registerItemModel(ModItems.upgradeMetaItem, i, UpgradeMetaItem.subNames[i], true);
        }
        for (i = 0; i < 1; ++i) {
            this.registerItemModel(ModItems.intermediateProductRegular, i, IntermediateProductRegular.subNames[i], true);
        }
        for (i = 0; i < 5; ++i) {
            this.registerItemModel(ModItems.ammoMetaItem, i, AmmoMetaItem.subNames[i], true);
        }
        for (i = 0; i < 3; ++i) {
            this.registerItemModel(ModItems.usableMetaItem, i, UsableMetaItem.subNames[i], true);
        }
        this.initTileRenderers();
    }

    @Override
    protected void initTileRenderers() {
        super.initTileRenderers();
        TileEntityRenderers.init();
        ModTESRItems.init();
    }

    @Override
    protected void initEntityRenderers() {
        super.initEntityRenderers();
        ProjectileRenderers.init();
    }

    @Override
    public void initHandlers() {
        super.initHandlers();
    }
}

